(* 
   The Parsed AST 
*) 
type var = string 

type type_expr = TEint | TEbool | TEunit

type formals = (var * type_expr) list

type oper = ADD | MUL | SUB | LT | AND | OR | EQ | EQB | EQI

type unary_oper = NEG | NOT 

type loc = Lexing.position 

type expr = 
       | Unit of loc  
       | What of loc 
       | Var of loc * var
       | Integer of loc * int
       | Boolean of loc * bool
       | UnaryOp of loc * unary_oper * expr
       | Op of loc * expr * oper * expr
       | If of loc * expr * expr * expr
       | App of loc * var * expr list
       | Let of loc * binding_list * expr
       | LetFun of loc * var * formals * type_expr * expr * expr
       | LetRecFun of loc * var * formals * type_expr * expr * expr

and binding_list = (var * type_expr * expr) list  

