{
  open Parser
  open Lexing 

(* next_line copied from  Ch. 16 of "Real Workd Ocaml" *) 
let next_line lexbuf =
  let pos = lexbuf.lex_curr_p in
  lexbuf.lex_curr_p <-
    { pos with pos_bol = lexbuf.lex_curr_pos;
               pos_lnum = pos.pos_lnum + 1
    }

}

let newline = ('\010' | "\013\010" )

rule token = parse
  | [' ' '\t'] { token lexbuf }
  | '(' { LPAREN }
  | ')' { RPAREN }
  | "," { COMMA }
  | ":" { COLON }
  | "+" { ADD }
  | "-" { SUB }
  | "*" { MUL }
  | "~" { NOT }
  | "=" { EQUAL }
  | "<" { LT }
  | "&&" { ANDOP }
  | "||" { OROP }
  | "?" { WHAT }
  | "()" { UNIT }
  | "and" { AND }
  | "true" { TRUE }
  | "false" { FALSE }
  | "if" { IF }
  | "then" { THEN }
  | "else" { ELSE }
  | "let" { LET }
  | "rec" { REC }
  | "in" { IN }
  | "end" { END }
  | "bool" { BOOL }
  | "int" { INTTYPE }
  | "unit" { UNITTYPE }
  | ['0'-'9']+ { INT (int_of_string (Lexing.lexeme lexbuf)) }
  | ['A'-'Z' 'a'-'z']+ ['0'-'9' 'A'-'Z' 'a'-'z' '_' '\'']* { IDENT (Lexing.lexeme lexbuf) }
  | "(*" { comment lexbuf } 
  | newline { next_line lexbuf; token lexbuf } 
  | eof { EOF }
  | _ { Common.complain ("Lexer : Illegal character " ^ (Char.escaped(Lexing.lexeme_char lexbuf 0)))
}

(* note : not currently handling nested comments *) 
and comment = parse
  | "*)" { token lexbuf } 
  | newline { next_line lexbuf; token lexbuf } 
  | _ { comment lexbuf } 
      

