
val verbose : bool ref 

val stack_max : int ref 

type oper = ADD | MUL | SUB | LT | AND | OR | EQB | EQI

type unary_oper = NEG | NOT 

type label = string 
type code_index = int 
type stack_index = int 
type offset  = int 
type static_distance = int 

type status_code = 
  | Halted 
  | Running 
  | CodeIndexOutOfBound 
  | StackIndexOutOfBound 
  | StackUnderflow 

type stack_item = 
  | CONSTANT of Common.constant 
  | CODE_INDEX of code_index    (* return address               *) 
  | STACK_INDEX of stack_index  (* frame pointer or static link *) 

type instruction = 
  | PUSH of Common.constant 
  | GOTO of label * (code_index option) 
  | TEST of label * (code_index option) 
  | CALL of label * (code_index option) * static_distance 
  | ARG of static_distance * offset 
  | DoOp of oper 
  | DoUnary of unary_oper 
  | RETURN of int 
  | SKIP 
  | READ 
  | HALT 

type l_instruction = NotLabelled of instruction  | Labelled of label * instruction 

type listing = l_instruction list 

type vm_state = 
  {
    stack_bound : stack_index; 
    code_bound : code_index; 
    stack : stack_item array; 
    program : l_instruction array; 
    mutable sp : stack_index;  (* stack pointer *) 
    mutable fp : stack_index;  (* frame pointer *) 
    mutable cp : code_index;   (* code pointer  *) 
    mutable status : status_code; 
  } 


val string_of_listing : listing -> string 

val step : vm_state -> vm_state 

val driver : int -> vm_state -> vm_state 

val run : listing -> Common.constant
