
(* fib : int -> int *) 
let rec fib m =
    if m = 0 
    then 1 
    else if m = 1 
         then 1 
         else fib(m - 1) + fib (m - 2) 


(* fib_cps : ((int -> int) * int) -> int  *) 
let rec fib_cps (cnt, m) =
    if m = 0 
    then cnt 1 
    else if m = 1 
         then cnt 1 
         else fib_cps((fun a -> fib_cps((fun b -> cnt (a + b)), m - 2)),  
                      m - 1)
(* 
   fib_1 : int -> int 

   note : fib_1 m = fib_cps (ID, m) = ID(fib(m)) = fib(m). 

   note the need for ()s around the lambda! 
   Otherwise Ocaml treats (fun a -> a, m)
   as if it where written (fun a -> (a, m)).  
   OK, OK -- one can get used to this ... 
*) 
let fib_1 m = fib_cps((fun a -> a), m)


