package uk.ac.cam.rkh23.DesignPatterns.Composite;

import java.util.List;

public class ProductGroup extends Product {
	
	private List<Product> mGroupContents;
	private float mDiscount=0.9f;

	public ProductGroup(List<Product> products, float discount) {
		super(0.0f); // Have to set something, but we don't use mPrice so the value is irrelevant
		mGroupContents=products;
	}
	
	// Override this so it computes the discounted price
	public float getPrice() {
		float price=0.0f;
		for (Product p : mGroupContents) price+=p.getPrice();	
		return price*mDiscount;
	}

}
