package uk.ac.cam.rkh23.ExamplesClass.Logging;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;

public final class Logger {
	private static Logger sInstance=new Logger();
	private PrintWriter mOut=null;
	private boolean mReady=false;
	
	private Logger()  {
		try {
			mOut = new PrintWriter(new File("/tmp/Log.txt"));
			mReady=true;
		}
		catch(IOException ioe) {
			System.err.println("Unable to create log file");
		}
		
	}

	public static Logger getInstance() {
		if (sInstance.mReady)	return sInstance;
		else return null;
	}
	
	public void log(String s) {
		mOut.write(System.nanoTime()+" "+s+"\n");
		mOut.flush();
	}
	
	@Override
	protected void finalize() throws Throwable {
	     try {
	         mOut.close();        // close open files
	         System.out.println("Log closed");
	     } finally {
	         super.finalize();
	     }
	 }
}
