package uk.ac.cam.rkh23.Comparing;

public class CompPerson extends Person implements Comparable<CompPerson>{
	
	public CompPerson(String forename, String surname, int age) {
		super(forename,surname,age);
	}
	
	@Override
	public boolean equals (Object obj) {
		if (obj instanceof CompPerson) {   // Check the comparison object is valid
			CompPerson p = (CompPerson)obj;    // Cast back
			if (	getSurname().equals(p.getSurname()) &&
					getForename().equals(p.getForename()) &&
					getAge() == p.getAge()
				) return true;
			else return false;
		}
		else return false;
	}

	// This is the method we have by implementing Comparable<CompPerson>
	// It compares two CompPerson objects by surname, then forename, then age
	@Override
	public int compareTo(CompPerson o) {
		 if (getSurname().compareTo(o.getSurname())==0) {
			 if (getForename().compareTo(o.getForename())==0) {
				 if (getAge()<o.getAge()) return -1;
				 else if (getAge()>o.getAge()) return 1;
				 else return 0;
			 }
			 else return getForename().compareTo(o.getForename());
		 }
		 else return getSurname().compareTo(o.getSurname());	 
	}

}
