//
// $Id: $

#include <assert.h>
#include <stdlib.h>
#include "tenos.h"


static u64_t prazor_masks[64];
static bool prazor_masks_done=false;


#if 0  
// temporarily removed because xlk is not defined in tenos.h and so this file won't compile!
volatile bool sim_overp() 
{
  extern bool sc_is_running();
  return !sc_is_running();
}


// temporarily removed because xlk is not defined in tenos.h and so this file won't compile!
void tenos_simcontrol::start() 
{ 
  xlk.lock(); 
  m_active_workers+=1; 
  xlk.unlock();
}

void tenos_simcontrol::stop() 
{ 
  xlk.lock(); 
  m_active_workers-=1; 
  xlk.unlock();
  cout << "No further active workers\n";
    if (m_active_workers == 0) sc_stop();
}
#endif

u64_t prazor_mask(int w)
{
  assert(w > 0 && w <= 64);
  if (!prazor_masks_done)
    {
      prazor_masks[1] = 1;
      for (int i=2; i<= 64; i++) prazor_masks[i] = prazor_masks[i-1]*2 + 1;
      prazor_masks_done=true;
    }
  return (prazor_masks[w]);
}

int bound_log2(u64_t d) // E.g. if d in 4 to 7 we return 3.
{
  int r = 0;
  while (d > 1LLU) { d /= 2LLU; r++; }
  return r;
}

int pow_2(uint64_t pow) {
  return 1 << pow;
}

#if 0
int bound_log2(u32_t d) // E.g. if d in 4 to 7 we return 3.
{
  int r = 0;
  while (d > 1) { d /= 2; r++; }
  return r;
}
#endif

void tenos_assert_fail(const char *iname, const char *m, const char*file, int line)
{
  printf("%s: assert \"%s\" failed at %s:%i\n", m, iname, file, line);
  exit(1);
}

void tenos_diagnostic_if::diagnostic_report(FILE *fd, int severity, const char *msg)
{
  std::cout << "Missing virtual method: diagnostic report " << msg << "\n";
}

void tenos_diagnostics_s::checkpoint(int severity, const char *where, const char *msg)
{
  std::cout << "diagnostic checkpoint:" << where << "\n";
  for(std::vector< tenos_diagnostic_if *>::const_iterator l_it = m_vec.begin(); l_it != m_vec.end(); ++l_it)
    { 
      (*l_it)->diagnostic_report(stdout, severity, msg);
    }
}


// For output to spreadsheets and other curve fitters we can use sylk or csv.
// Here is a simple database for staging outputs.

static tenos_report_item *g_tenos_report_items = 0;

// constructor 1/4
tenos_report_item::tenos_report_item(const char *name1, const char *name2,  const char *string_value) :
  name1(name1),
  name2(name2),
  string_value(string_value)
{
  u64_value = 0;
  float_value = 0;
  int_value = 0;
  next = g_tenos_report_items;
  g_tenos_report_items = this;
}

// constructor 2/4
tenos_report_item::tenos_report_item(const char *name1, const char *name2,  float *float_value) :
  name1(name1),
  name2(name2),
  float_value(float_value)
{
  u64_value = 0;
  string_value = 0;
  int_value = 0;
  next = g_tenos_report_items;
  g_tenos_report_items = this;
}

// constructor 3/4
tenos_report_item::tenos_report_item(const char *name1, const char *name2,  int *int_value) :
  name1(strdup(name1)),
  name2(strdup(name2)),
  int_value(int_value)
{
  u64_value = 0;
  float_value = 0;
  string_value = 0;
  next = g_tenos_report_items;
  g_tenos_report_items = this;
}
// constructor 4/4
tenos_report_item::tenos_report_item(const char *name1, const char *name2,  u64_t *u64_t_value) :
  name1(strdup(name1)),
  name2(strdup(name2)),
  u64_value(u64_value)
{
  int_value = 0;
  float_value = 0;
  string_value = 0;
  next = g_tenos_report_items;
  g_tenos_report_items = this;
}


extern void tenos_report_items(const char *msg, FILE *fd)
{
  for (int pass = 0; pass<2; pass++)
    {
      //printf("%s: Pass %i %p\n", msg, pass, g_tenos_report_items);
      fprintf(fd, pass ? "CSV,%s": "TCSV,%s,", msg);
      for (tenos_report_item *p = g_tenos_report_items; p; p=p->next)
	{
	  if (pass == 0) fprintf(fd, ",%s.%s", p->name1, p->name2);
	  else if (p->string_value) fprintf(fd, ",%s", p->string_value);
	  else if (p->int_value) fprintf(fd, ",%i", *p->int_value);
	  else if (p->float_value) fprintf(fd, ",%f", *p->float_value);
	  else if (p->u64_value) fprintf(fd, "," PFI64, *p->u64_value);
	  else fprintf(fd, ",<null>", p->float_value);
	}
      fprintf(fd, "\n");
    }
}


// eof
