#ifndef OR1200IF_H
#define OR1200IF_H

#include "systemc.h"
#include "tenos.h"


#ifndef POWER3
#ifdef TLM_POWER3
#include "tlm_power.h"
#define POWER3(X) X
using namespace sc_pwr;
#else
typedef tlm::tlm_base_protocol_types PW_TLM_TYPES;
typedef tlm::tlm_generic_payload PW_TLM_PAYTYPE;
#define POWER3(X)
#endif
#endif

#include "cpu_busaccess.h"

// An interface/wrapper for various forms of the CPU (e.g. fast, slow, power-annotated, verilated ...).


extern int g_dmi_disablef;

#define VISIBLE __attribute__ ((visibility("default")))

class VISIBLE OR1200IF : // CPU interface
   public sc_core::sc_module
#ifdef TLM_POWER3
  , public pw_module
#endif
{

 public:
  SC_HAS_PROCESS(OR1200IF);
  uint8_t procID;
  bool harvardf;
  u64_t reset_vector;
  int countdown; // Number of clock cycles to wait before reset

  // Todo: make this work so parent can bind directly to me.
  //sc_export<tlm_utils::simple_initiator_socket<OR1200, 64, PW_TLM_TYPES> > initiator_socket;

  sc_time bus_period; // Reciprocal of front side bus frequency
  sc_time core_period; // Reciprocal of core clock frequency

  bool halted;  // True if not running (waiting for interrupt or other wakeup).

  void set_clock_frequencies(sc_time bus, sc_time core) 
    {
      bus_period = bus;
      core_period = core;
    }

  void register_reset_vector(u64_t a) { reset_vector = a; };

  virtual void run()=0;
  virtual bool *connect_interrupt(bool *a)=0;
  virtual void stat_report(const char *msg, FILE *fd, bool resetf=false)=0;
  virtual const char *kind() { return "OR1200IF"; }
  virtual void reset(bool selfstart)=0;



  cpu_busaccess busaccess;
  void traceregion_add(traceregion *n) { n->add(busaccess.traceregions); }

  u64_t xlat32to64(u32_t a)
  {
    // I/O space is defined to be when the top two bits of the address are set.
    // Caches should not cache this!
    u64_t r = a;
    if ((a & 0xC0000000)==0xC0000000) r |= 0xFFFFffff00000000LLU;
    return r;
  }


 OR1200IF(sc_core::sc_module_name names, u8_t pID, bool harvardf, int countdown=0) : // Constructor.
  sc_module(names),
    countdown(countdown),
    harvardf(harvardf),
    busaccess(this, "busaccess", pID, harvardf?1:0, g_dmi_disablef),
    bus_period(5, SC_NS),
    core_period(5, SC_NS),
    procID(pID)
      { };

  //
 private:
    OR1200IF(); // This constructor is hidden since one should never directly instantiate this inteface.

 public:
  virtual ~OR1200IF() 
    {
      
    };

};




#endif
