/* execgen.c -- Automatically generated decoder

   Copyright (C) 1999 Damjan Lampret, lampret@opencores.org
   Copyright (C) 2008 Embecosm Limited

   Contributor Jeremy Bennett <jeremy.bennett@embecosm.com>

   This file is part of Or1ksim, the OpenRISC 1000 Architectural Simulator.

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along
   with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* This program is commented throughout in a fashion suitable for processing
   with Doxygen. */

/* This file was automatically generated by generate (see cpu/or32/generate.c) : do not edit. Edit execgen.c in preference to iss.C */



void orsim::exit_backdoor(const char *m)
{
#if 0
  fprintf(stderr, "@reset : cycles %lld, insn #%lld\n",
	  runtime.sim.reset_cycles, runtime.cpu.reset_instructions);
  fprintf(stderr, "@exit  : cycles %lld, insn #%lld\n", runtime.sim.cycles,
	  runtime.cpu.instructions);
  fprintf(stderr, " diff  : cycles %lld, insn #%lld\n",
	  runtime.sim.cycles - runtime.sim.reset_cycles,
	  runtime.cpu.instructions - runtime.cpu.reset_instructions);
#else
  fprintf(stderr, "@reset :  insn #%d\n",	  runtime.cpu.reset_instructions);
  fprintf(stderr, "@exit  :  insn #%d\n",	  runtime.cpu.instructions); 
  fprintf(stderr, " diff  :  insn #%d\n",	  runtime.cpu.instructions - runtime.cpu.reset_instructions);
#endif
  if (config.debug.gdb_enabled)
    set_stall_state (1);
  else
    sim_done(m);

}


void orsim::decoder (struct iqueue_entry *current)
{
  uint32_t insn = current->insn;
  switch((insn >> 26) & 0x3f) {
  case 0x0:
    /* Instruction: l.j */
    {
      uorreg_t a;
      /* Number of operands: 1 */
      a = (insn >> 0) & 0x3ffffff;
      if(a & 0x02000000) a |= 0xfe000000;
      #define PARAM0 a
      {         /* "l_j" */
        cpu_state.pc_delay = cpu_state.pc + (orreg_t)PARAM0 * 4;
        next_delay_insn = 1;
      }
      #undef PARAM0

      if (do_stats) {
        current->insn_index = 0;   /* "l.j" */
        analysis(current);
      }
    }
    break;
  case 0x1:
    /* Instruction: l.jal */
    {
      uorreg_t a;
      /* Number of operands: 1 */
      a = (insn >> 0) & 0x3ffffff;
      if(a & 0x02000000) a |= 0xfe000000;
      #define PARAM0 a
      {         /* "l_jal" */
        cpu_state.pc_delay = cpu_state.pc + (orreg_t)PARAM0 * 4;
        
        setsim_reg(LINK_REGNO, cpu_state.pc + 8);
        next_delay_insn = 1;
        if (config.sim.profile) {
          struct label_entry *tmp;
          if (verify_memoryarea(cpu_state.pc_delay) && (tmp = get_label (cpu_state.pc_delay)))
            fprintf (runtime.sim.fprof, "+%08llX %" PRIxADDR " %" PRIxADDR " %s\n",
                     runtime.sim.cycles, cpu_state.pc + 8, cpu_state.pc_delay,
                     tmp->name);
          else
            fprintf (runtime.sim.fprof, "+%08llX %" PRIxADDR " %" PRIxADDR " @%" PRIxADDR "\n",
                     runtime.sim.cycles, cpu_state.pc + 8, cpu_state.pc_delay,
                     cpu_state.pc_delay);
        }
      }
      #undef PARAM0

      if (do_stats) {
        current->insn_index = 1;   /* "l.jal" */
        analysis(current);
      }
    }
    break;
  case 0x2:
    /* Invalid instruction(s) */
    break;
  case 0x3:
    /* Instruction: l.bnf */
    {
      uorreg_t a;
      /* Number of operands: 1 */
      a = (insn >> 0) & 0x3ffffff;
      if(a & 0x02000000) a |= 0xfe000000;
      #define PARAM0 a
      {         /* "l_bnf" */
        if (config.bpb.enabled) {
          int fwd = (PARAM0 >= cpu_state.pc) ? 1 : 0;
          or1k_mstats.bnf[cpu_state.sprs[SPR_SR] & SPR_SR_F ? 0 : 1][fwd]++;
          bpb_update(current->insn_addr, cpu_state.sprs[SPR_SR] & SPR_SR_F ? 0 : 1);
        }
        if (!(cpu_state.sprs[SPR_SR] & SPR_SR_F)) {
          cpu_state.pc_delay = cpu_state.pc + (orreg_t)PARAM0 * 4;
          btic_update(pcnext);
          next_delay_insn = 1;
        } else {
          btic_update(cpu_state.pc);
        }
      }
      #undef PARAM0

      if (do_stats) {
        current->insn_index = 2;   /* "l.bnf" */
        analysis(current);
      }
    }
    break;
  case 0x4:
    /* Instruction: l.bf */
    {
      uorreg_t a;
      /* Number of operands: 1 */
      a = (insn >> 0) & 0x3ffffff;
      if(a & 0x02000000) a |= 0xfe000000;
      #define PARAM0 a
      {         /* "l_bf" */
        if (config.bpb.enabled) {
          int fwd = (PARAM0 >= cpu_state.pc) ? 1 : 0;
          or1k_mstats.bf[cpu_state.sprs[SPR_SR] & SPR_SR_F ? 1 : 0][fwd]++;
          bpb_update(current->insn_addr, cpu_state.sprs[SPR_SR] & SPR_SR_F ? 1 : 0);
        }
        if(cpu_state.sprs[SPR_SR] & SPR_SR_F) {
          cpu_state.pc_delay = cpu_state.pc + (orreg_t)PARAM0 * 4;
          btic_update(pcnext);
          next_delay_insn = 1;
        } else {
          btic_update(cpu_state.pc);
        }
      }
      #undef PARAM0

      if (do_stats) {
        current->insn_index = 3;   /* "l.bf" */
        analysis(current);
      }
    }
    break;
  case 0x5:
    /* Not unique: real mask ff000000 and current mask fc000000 differ - do final check */
    if((insn & 0xff000000) == 0x15000000) {
      /* Instruction: l.nop */
      {
        uorreg_t a;
        /* Number of operands: 1 */
        a = (insn >> 0) & 0xffff;
        #define PARAM0 a
        {           /* "l_nop" */
          oraddr_t stackaddr;
          uint32_t k = PARAM0;
          switch (k) {
            case NOP_NOP:
              break;
            case NOP_EXIT:
 	      exit_backdoor("nop exit backdoor");
              break;

            case NOP_CNT_RESET:
              PRINTF("****************** counters reset ******************\n");
              PRINTF("cycles %lld, insn #%d\n", runtime.sim.cycles, runtime.cpu.instructions); 
              PRINTF("****************** counters reset ******************\n");
              runtime.sim.reset_cycles = runtime.sim.cycles;
              runtime.cpu.reset_instructions = runtime.cpu.instructions;
              break;    
            case NOP_PRINTF:
              stackaddr = evalsim_reg(4);
              simprintf(stackaddr, evalsim_reg(3));
              break;
            case NOP_PUTC:		/*JPB */
              printf( "%c", (char)(evalsim_reg( 3 ) & 0xff));
              fflush( stdout );
              break;

            case NOP_REPORT:
              PRINTF("report(0x%" PRIxREG ");\n", evalsim_reg(3));
	      break;

   	    case NOP_TRACE100:  /* DJG */
 	      trace100("backdoor nop trace100");
 	      break;

  	    case NOP_ATOMIC:  /* DJG */
	      atomic_prefix();
	      break;

  	    case NOP_COREPAUSE:  /* DJG */
	      corepause(evalsim_reg(3), cpu_state.pc);
	      break;

            default:
              if (k >= NOP_REPORT_FIRST && k <= NOP_REPORT_LAST)
              PRINTF("report %" PRIdREG " (0x%" PRIxREG ");\n", k - NOP_REPORT_FIRST, evalsim_reg(3));
              break;
          }
        }
        #undef PARAM0

        if (do_stats) {
          current->insn_index = 4;   /* "l.nop" */
          analysis(current);
        }
      }
    } else {
      /* Invalid insn */
      {
        l_invalid ();

        if (do_stats) {
          current->insn_index = -1;   /* "???" */
          analysis(current);
        }
      }
    }
    break;
  case 0x6:
    switch((insn >> 16) & 0x1) {
    case 0x0:
      /* Instruction: l.movhi */
      {
        uorreg_t a, b;
        /* Number of operands: 2 */
        a = (insn >> 21) & 0x1f;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        b = (insn >> 0) & 0xffff;
        #define PARAM1 b
        {           /* "l_movhi" */
          SET_PARAM0(PARAM1 << 16);
        }
        #undef SET_PARAM
        #undef PARAM0
        #undef PARAM1

        if (do_stats) {
          current->insn_index = 5;   /* "l.movhi" */
          analysis(current);
        }
        cpu_state.reg[0] = 0; /* Repair in case we changed it */
      }
      break;
    case 0x1:
      /* Not unique: real mask fc01ffff and current mask fc010000 differ - do final check */
      if((insn & 0xfc01ffff) == 0x18010000) {
        /* Instruction: l.macrc */
        {
          uorreg_t a;
          /* Number of operands: 1 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          {             /* "l_macrc" */
            uorreg_t lo, hi;
            LONGEST l;
            /* No need for synchronization here -- all MAC instructions are 1 cycle long.  */
            lo =  cpu_state.sprs[SPR_MACLO];
            hi =  cpu_state.sprs[SPR_MACHI];
            l = (ULONGEST) lo | ((LONGEST)hi << 32);
            l >>= 28;
            //PRINTF ("<%08x>\n", (unsigned long)l);
            SET_PARAM0((orreg_t)l);
            cpu_state.sprs[SPR_MACLO] = 0;
            cpu_state.sprs[SPR_MACHI] = 0;
          }
          #undef SET_PARAM
          #undef PARAM0

          if (do_stats) {
            current->insn_index = 6;   /* "l.macrc" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
      } else {
        /* Invalid insn */
        {
          l_invalid ();

          if (do_stats) {
            current->insn_index = -1;   /* "???" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
      }
      break;
    }
    break;
  case 0x7:
    /* Invalid instruction(s) */
    break;
  case 0x8:
    switch((insn >> 16) & 0x7f) {
    case 0x0:
      switch((insn >> 23) & 0x7) {
      case 0x0:
        /* Instruction: l.sys */
        {
	  //printf("%s: l.sys a=x\n", __FILE__, a);
          uorreg_t a;
          /* Number of operands: 1 */
          a = (insn >> 0) & 0xffff;
          #define PARAM0 a
          {             /* "l_sys" */
            except_handle(EXCEPT_SYSCALL, cpu_state.sprs[SPR_EEAR_BASE]);
          }
          #undef PARAM0

          if (do_stats) {
            current->insn_index = 7;   /* "l.sys" */
            analysis(current);
          }
        }
        break;
      case 0x1:
        /* Invalid instruction(s) */
        break;
      case 0x2:
        /* Instruction: l.trap */
        {
          uorreg_t a;
          /* Number of operands: 1 */
          a = (insn >> 0) & 0xffff;
          #define PARAM0 a
          {             /* "l_trap" */
            /* TODO: some SR related code here! */
            except_handle(EXCEPT_TRAP, cpu_state.sprs[SPR_EEAR_BASE]);
          }
          #undef PARAM0

          if (do_stats) {
            current->insn_index = 8;   /* "l.trap" */
            analysis(current);
          }
        }
        break;
      case 0x3:
        /* Invalid instruction(s) */
        break;
      case 0x4:
        /* Not unique: real mask ffffffff and current mask ffff0000 differ - do final check */
        if((insn & 0xffffffff) == 0x22000000) {
          /* Instruction: l.msync */
          {
            uorreg_t a;
            /* Number of operands: 1 */
            a = (insn >> 0) & 0x0;
            #define SET_PARAM0(val) cpu_state.reg[a] = val
            #define PARAM0 cpu_state.reg[a]
            l_none ();
            #undef SET_PARAM
            #undef PARAM0

            if (do_stats) {
              current->insn_index = 9;   /* "l.msync" */
              analysis(current);
            }
          }
        } else {
          /* Invalid insn */
          {
            l_invalid ();

            if (do_stats) {
              current->insn_index = -1;   /* "???" */
              analysis(current);
            }
          }
        }
        break;
      case 0x5:
        /* Not unique: real mask ffffffff and current mask ffff0000 differ - do final check */
        if((insn & 0xffffffff) == 0x22800000) {
          /* Instruction: l.psync */
          {
            uorreg_t a;
            /* Number of operands: 1 */
            a = (insn >> 0) & 0x0;
            #define SET_PARAM0(val) cpu_state.reg[a] = val
            #define PARAM0 cpu_state.reg[a]
            l_none ();
            #undef SET_PARAM
            #undef PARAM0

            if (do_stats) {
              current->insn_index = 10;   /* "l.psync" */
              analysis(current);
            }
          }
        } else {
          /* Invalid insn */
          {
            l_invalid ();

            if (do_stats) {
              current->insn_index = -1;   /* "???" */
              analysis(current);
            }
          }
        }
        break;
      case 0x6:
        /* Not unique: real mask ffffffff and current mask ffff0000 differ - do final check */
        if((insn & 0xffffffff) == 0x23000000) {
          /* Instruction: l.csync */
          {
            uorreg_t a;
            /* Number of operands: 1 */
            a = (insn >> 0) & 0x0;
            #define SET_PARAM0(val) cpu_state.reg[a] = val
            #define PARAM0 cpu_state.reg[a]
            l_none ();
            #undef SET_PARAM
            #undef PARAM0

            if (do_stats) {
              current->insn_index = 11;   /* "l.csync" */
              analysis(current);
            }
          }
        } else {
          /* Invalid insn */
          {
            l_invalid ();

            if (do_stats) {
              current->insn_index = -1;   /* "???" */
              analysis(current);
            }
          }
        }
        break;
      case 0x7:
        /* Invalid instruction(s) */
        break;
      }
      break;
    case 0x1:
    case 0x2:
    case 0x3:
    case 0x4:
    case 0x5:
    case 0x6:
    case 0x7:
    case 0x8:
    case 0x9:
    case 0xa:
    case 0xb:
    case 0xc:
    case 0xd:
    case 0xe:
    case 0xf:
    case 0x10:
    case 0x11:
    case 0x12:
    case 0x13:
    case 0x14:
    case 0x15:
    case 0x16:
    case 0x17:
    case 0x18:
    case 0x19:
    case 0x1a:
    case 0x1b:
    case 0x1c:
    case 0x1d:
    case 0x1e:
    case 0x1f:
    case 0x20:
    case 0x21:
    case 0x22:
    case 0x23:
    case 0x24:
    case 0x25:
    case 0x26:
    case 0x27:
    case 0x28:
    case 0x29:
    case 0x2a:
    case 0x2b:
    case 0x2c:
    case 0x2d:
    case 0x2e:
    case 0x2f:
    case 0x30:
    case 0x31:
    case 0x32:
    case 0x33:
    case 0x34:
    case 0x35:
    case 0x36:
    case 0x37:
    case 0x38:
    case 0x39:
    case 0x3a:
    case 0x3b:
    case 0x3c:
    case 0x3d:
    case 0x3e:
    case 0x3f:
    case 0x40:
    case 0x41:
    case 0x42:
    case 0x43:
    case 0x44:
    case 0x45:
    case 0x46:
    case 0x47:
    case 0x48:
    case 0x49:
    case 0x4a:
    case 0x4b:
    case 0x4c:
    case 0x4d:
    case 0x4e:
    case 0x4f:
    case 0x50:
    case 0x51:
    case 0x52:
    case 0x53:
    case 0x54:
    case 0x55:
    case 0x56:
    case 0x57:
    case 0x58:
    case 0x59:
    case 0x5a:
    case 0x5b:
    case 0x5c:
    case 0x5d:
    case 0x5e:
    case 0x5f:
    case 0x60:
    case 0x61:
    case 0x62:
    case 0x63:
    case 0x64:
    case 0x65:
    case 0x66:
    case 0x67:
    case 0x68:
    case 0x69:
    case 0x6a:
    case 0x6b:
    case 0x6c:
    case 0x6d:
    case 0x6e:
    case 0x6f:
    case 0x70:
    case 0x71:
    case 0x72:
    case 0x73:
    case 0x74:
    case 0x75:
    case 0x76:
    case 0x77:
    case 0x78:
    case 0x79:
    case 0x7a:
    case 0x7b:
    case 0x7c:
    case 0x7d:
    case 0x7e:
    case 0x7f:
      /* Invalid instruction(s) */
      break;
    }
    break;
  case 0x9:
    /* Instruction: l.rfe */
    {
      uorreg_t a;
      /* Number of operands: 1 */
      a = (insn >> 0) & 0x0;
      #define SET_PARAM0(val) cpu_state.reg[a] = val
      #define PARAM0 cpu_state.reg[a]
      {         /* "l_rfe" */
        pcnext = cpu_state.sprs[SPR_EPCR_BASE];
        mtspr(SPR_SR, cpu_state.sprs[SPR_ESR_BASE]);
      }
      #undef SET_PARAM
      #undef PARAM0

      if (do_stats) {
        current->insn_index = 12;   /* "l.rfe" */
        analysis(current);
      }
    }
    break;
  case 0xa:
    switch((insn >> 4) & 0xf) {
    case 0x0:
      /* Invalid instruction(s) */
      break;
    case 0x1:
      switch((insn >> 0) & 0xf) {
      case 0x0:
        /* Instruction: lv.all_eq.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 13;   /* "lv.all_eq.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x1:
        /* Instruction: lv.all_eq.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 14;   /* "lv.all_eq.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x2:
        /* Instruction: lv.all_ge.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 15;   /* "lv.all_ge.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x3:
        /* Instruction: lv.all_ge.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 16;   /* "lv.all_ge.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x4:
        /* Instruction: lv.all_gt.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 17;   /* "lv.all_gt.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x5:
        /* Instruction: lv.all_gt.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 18;   /* "lv.all_gt.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x6:
        /* Instruction: lv.all_le.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 19;   /* "lv.all_le.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x7:
        /* Instruction: lv.all_le.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 20;   /* "lv.all_le.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x8:
        /* Instruction: lv.all_lt.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 21;   /* "lv.all_lt.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x9:
        /* Instruction: lv.all_lt.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 22;   /* "lv.all_lt.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0xa:
        /* Instruction: lv.all_ne.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 23;   /* "lv.all_ne.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0xb:
        /* Instruction: lv.all_ne.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 24;   /* "lv.all_ne.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0xc:
      case 0xd:
      case 0xe:
      case 0xf:
        /* Invalid instruction(s) */
        break;
      }
      break;
    case 0x2:
      switch((insn >> 0) & 0xf) {
      case 0x0:
        /* Instruction: lv.any_eq.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 25;   /* "lv.any_eq.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x1:
        /* Instruction: lv.any_eq.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 26;   /* "lv.any_eq.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x2:
        /* Instruction: lv.any_ge.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 27;   /* "lv.any_ge.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x3:
        /* Instruction: lv.any_ge.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 28;   /* "lv.any_ge.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x4:
        /* Instruction: lv.any_gt.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 29;   /* "lv.any_gt.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x5:
        /* Instruction: lv.any_gt.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 30;   /* "lv.any_gt.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x6:
        /* Instruction: lv.any_le.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 31;   /* "lv.any_le.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x7:
        /* Instruction: lv.any_le.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 32;   /* "lv.any_le.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x8:
        /* Instruction: lv.any_lt.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 33;   /* "lv.any_lt.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x9:
        /* Instruction: lv.any_lt.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 34;   /* "lv.any_lt.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0xa:
        /* Instruction: lv.any_ne.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 35;   /* "lv.any_ne.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0xb:
        /* Instruction: lv.any_ne.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 36;   /* "lv.any_ne.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0xc:
      case 0xd:
      case 0xe:
      case 0xf:
        /* Invalid instruction(s) */
        break;
      }
      break;
    case 0x3:
      switch((insn >> 0) & 0xf) {
      case 0x0:
        /* Instruction: lv.add.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 37;   /* "lv.add.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x1:
        /* Instruction: lv.add.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 38;   /* "lv.add.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x2:
        /* Instruction: lv.adds.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 39;   /* "lv.adds.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x3:
        /* Instruction: lv.adds.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 40;   /* "lv.adds.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x4:
        /* Instruction: lv.addu.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 41;   /* "lv.addu.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x5:
        /* Instruction: lv.addu.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 42;   /* "lv.addu.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x6:
        /* Instruction: lv.addus.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 43;   /* "lv.addus.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x7:
        /* Instruction: lv.addus.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 44;   /* "lv.addus.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x8:
        /* Instruction: lv.and */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 45;   /* "lv.and" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x9:
        /* Instruction: lv.avg.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 46;   /* "lv.avg.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0xa:
        /* Instruction: lv.avg.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 47;   /* "lv.avg.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0xb:
      case 0xc:
      case 0xd:
      case 0xe:
      case 0xf:
        /* Invalid instruction(s) */
        break;
      }
      break;
    case 0x4:
      switch((insn >> 0) & 0xf) {
      case 0x0:
        /* Instruction: lv.cmp_eq.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 48;   /* "lv.cmp_eq.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x1:
        /* Instruction: lv.cmp_eq.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 49;   /* "lv.cmp_eq.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x2:
        /* Instruction: lv.cmp_ge.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 50;   /* "lv.cmp_ge.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x3:
        /* Instruction: lv.cmp_ge.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 51;   /* "lv.cmp_ge.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x4:
        /* Instruction: lv.cmp_gt.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 52;   /* "lv.cmp_gt.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x5:
        /* Instruction: lv.cmp_gt.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 53;   /* "lv.cmp_gt.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x6:
        /* Instruction: lv.cmp_le.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 54;   /* "lv.cmp_le.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x7:
        /* Instruction: lv.cmp_le.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 55;   /* "lv.cmp_le.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x8:
        /* Instruction: lv.cmp_lt.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 56;   /* "lv.cmp_lt.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x9:
        /* Instruction: lv.cmp_lt.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 57;   /* "lv.cmp_lt.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0xa:
        /* Instruction: lv.cmp_ne.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 58;   /* "lv.cmp_ne.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0xb:
        /* Instruction: lv.cmp_ne.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 59;   /* "lv.cmp_ne.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0xc:
      case 0xd:
      case 0xe:
      case 0xf:
        /* Invalid instruction(s) */
        break;
      }
      break;
    case 0x5:
      switch((insn >> 0) & 0xf) {
      case 0x0:
      case 0x1:
      case 0x2:
      case 0x3:
        /* Invalid instruction(s) */
        break;
      case 0x4:
        /* Instruction: lv.madds.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 60;   /* "lv.madds.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x5:
        /* Instruction: lv.max.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 61;   /* "lv.max.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x6:
        /* Instruction: lv.max.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 62;   /* "lv.max.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x7:
        /* Instruction: lv.merge.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 63;   /* "lv.merge.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x8:
        /* Instruction: lv.merge.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 64;   /* "lv.merge.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x9:
        /* Instruction: lv.min.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 65;   /* "lv.min.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0xa:
        /* Instruction: lv.min.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 66;   /* "lv.min.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0xb:
        /* Instruction: lv.msubs.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 67;   /* "lv.msubs.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0xc:
        /* Instruction: lv.muls.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 68;   /* "lv.muls.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0xd:
        /* Instruction: lv.nand */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 69;   /* "lv.nand" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0xe:
        /* Instruction: lv.nor */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 70;   /* "lv.nor" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0xf:
        /* Instruction: lv.or */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 71;   /* "lv.or" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      }
      break;
    case 0x6:
      switch((insn >> 0) & 0xf) {
      case 0x0:
        /* Instruction: lv.pack.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 72;   /* "lv.pack.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x1:
        /* Instruction: lv.pack.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 73;   /* "lv.pack.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x2:
        /* Instruction: lv.packs.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 74;   /* "lv.packs.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x3:
        /* Instruction: lv.packs.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 75;   /* "lv.packs.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x4:
        /* Instruction: lv.packus.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 76;   /* "lv.packus.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x5:
        /* Instruction: lv.packus.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 77;   /* "lv.packus.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x6:
        /* Instruction: lv.perm.n */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 78;   /* "lv.perm.n" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x7:
        /* Instruction: lv.rl.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 79;   /* "lv.rl.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x8:
        /* Instruction: lv.rl.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 80;   /* "lv.rl.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x9:
        /* Instruction: lv.sll.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 81;   /* "lv.sll.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0xa:
        /* Instruction: lv.sll.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 82;   /* "lv.sll.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0xb:
        /* Instruction: lv.sll */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 83;   /* "lv.sll" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0xc:
        /* Instruction: lv.srl.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 84;   /* "lv.srl.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0xd:
        /* Instruction: lv.srl.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 85;   /* "lv.srl.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0xe:
        /* Instruction: lv.sra.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 86;   /* "lv.sra.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0xf:
        /* Instruction: lv.sra.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 87;   /* "lv.sra.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      }
      break;
    case 0x7:
      switch((insn >> 0) & 0xf) {
      case 0x0:
        /* Instruction: lv.srl */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 88;   /* "lv.srl" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x1:
        /* Instruction: lv.sub.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 89;   /* "lv.sub.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x2:
        /* Instruction: lv.sub.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 90;   /* "lv.sub.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x3:
        /* Instruction: lv.subs.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 91;   /* "lv.subs.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x4:
        /* Instruction: lv.subs.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 92;   /* "lv.subs.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x5:
        /* Instruction: lv.subu.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 93;   /* "lv.subu.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x6:
        /* Instruction: lv.subu.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 94;   /* "lv.subu.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x7:
        /* Instruction: lv.subus.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 95;   /* "lv.subus.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x8:
        /* Instruction: lv.subus.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 96;   /* "lv.subus.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x9:
        /* Instruction: lv.unpack.b */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 97;   /* "lv.unpack.b" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0xa:
        /* Instruction: lv.unpack.h */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 98;   /* "lv.unpack.h" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0xb:
        /* Instruction: lv.xor */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 99;   /* "lv.xor" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0xc:
      case 0xd:
      case 0xe:
      case 0xf:
        /* Invalid instruction(s) */
        break;
      }
      break;
    case 0x8:
    case 0x9:
    case 0xa:
    case 0xb:
      /* Invalid instruction(s) */
      break;
    case 0xc:
      /* Instruction: lv.cust1 */
      {
        uorreg_t a;
        /* Number of operands: 1 */
        a = (insn >> 0) & 0x0;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        l_invalid ();
        #undef SET_PARAM
        #undef PARAM0

        if (do_stats) {
          current->insn_index = 100;   /* "lv.cust1" */
          analysis(current);
        }
      }
      break;
    case 0xd:
      /* Instruction: lv.cust2 */
      {
        uorreg_t a;
        /* Number of operands: 1 */
        a = (insn >> 0) & 0x0;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        l_invalid ();
        #undef SET_PARAM
        #undef PARAM0

        if (do_stats) {
          current->insn_index = 101;   /* "lv.cust2" */
          analysis(current);
        }
      }
      break;
    case 0xe:
      /* Instruction: lv.cust3 */
      {
        uorreg_t a;
        /* Number of operands: 1 */
        a = (insn >> 0) & 0x0;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        l_invalid ();
        #undef SET_PARAM
        #undef PARAM0

        if (do_stats) {
          current->insn_index = 102;   /* "lv.cust3" */
          analysis(current);
        }
      }
      break;
    case 0xf:
      /* Instruction: lv.cust4 */
      {
        uorreg_t a;
        /* Number of operands: 1 */
        a = (insn >> 0) & 0x0;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        l_invalid ();
        #undef SET_PARAM
        #undef PARAM0

        if (do_stats) {
          current->insn_index = 103;   /* "lv.cust4" */
          analysis(current);
        }
      }
      break;
    }
    break;
  case 0xb:
  case 0xc:
  case 0xd:
  case 0xe:
  case 0xf:
  case 0x10:
    /* Invalid instruction(s) */
    break;
  case 0x11:
    /* Instruction: l.jr */
    {
      uorreg_t a;
      /* Number of operands: 1 */
      a = (insn >> 11) & 0x1f;
      #define SET_PARAM0(val) cpu_state.reg[a] = val
      #define PARAM0 cpu_state.reg[a]
      {         /* "l_jr" */
        cpu_state.pc_delay = PARAM0;
        next_delay_insn = 1;
        if (config.sim.profile)
          fprintf (runtime.sim.fprof, "-%08llX %" PRIxADDR "\n", runtime.sim.cycles,
                   cpu_state.pc_delay);
      }
      #undef SET_PARAM
      #undef PARAM0

      if (do_stats) {
        current->insn_index = 104;   /* "l.jr" */
        analysis(current);
      }
    }
    break;
  case 0x12:
    /* Instruction: l.jalr */
    {
      uorreg_t a;
      /* Number of operands: 1 */
      a = (insn >> 11) & 0x1f;
      #define SET_PARAM0(val) cpu_state.reg[a] = val
      #define PARAM0 cpu_state.reg[a]
      {         /* "l_jalr" */
        cpu_state.pc_delay = PARAM0;
        setsim_reg(LINK_REGNO, cpu_state.pc + 8);
        next_delay_insn = 1;
      }
      #undef SET_PARAM
      #undef PARAM0

      if (do_stats) {
        current->insn_index = 105;   /* "l.jalr" */
        analysis(current);
      }
    }
    break;
  case 0x13:
    /* Instruction: l.maci */
    {
      uorreg_t a, b;
      /* Number of operands: 2 */
      a = (insn >> 16) & 0x1f;
      #define SET_PARAM0(val) cpu_state.reg[a] = val
      #define PARAM0 cpu_state.reg[a]
      b = (insn >> 0) & 0x7ff;
      b |= ((insn >> 21) & 0x1f) << 11;
      if(b & 0x00008000) b |= 0xffff8000;
      #define PARAM1 b
      {         /* "l_mac" */
        uorreg_t lo, hi;
        LONGEST l;
        orreg_t x, y;
      
        lo = cpu_state.sprs[SPR_MACLO];
        hi = cpu_state.sprs[SPR_MACHI];
        x = PARAM0;
        y = PARAM1;
      /*   PRINTF ("[%"PRIxREG",%"PRIxREG"]\t", x, y); */
        l = (ULONGEST)lo | ((LONGEST)hi << 32);
        l += (LONGEST) x * (LONGEST) y;
      
        /* This implementation is very fast - it needs only one cycle for mac.  */
        lo = ((ULONGEST)l) & 0xFFFFFFFF;
        hi = ((LONGEST)l) >> 32;
        cpu_state.sprs[SPR_MACLO] = lo;
        cpu_state.sprs[SPR_MACHI] = hi;
      /*   PRINTF ("(%"PRIxREG",%"PRIxREG"\n", hi, lo); */
      }
      #undef SET_PARAM
      #undef PARAM0
      #undef PARAM1

      if (do_stats) {
        current->insn_index = 106;   /* "l.maci" */
        analysis(current);
      }
    }
    break;
  case 0x14:
  case 0x15:
  case 0x16:
  case 0x17:
  case 0x18:
  case 0x19:
  case 0x1a:
  case 0x1b:
    /* Invalid instruction(s) */
    break;
  case 0x1c:
    /* Instruction: l.cust1 */
    {
      uorreg_t a;
      /* Number of operands: 1 */
      a = (insn >> 0) & 0x0;
      #define SET_PARAM0(val) cpu_state.reg[a] = val
      #define PARAM0 cpu_state.reg[a]
      {         /* "l_cust1" */
        /*int destr = current->insn >> 21;
          int src1r = current->insn >> 15;
          int src2r = current->insn >> 9;*/
      }
      #undef SET_PARAM
      #undef PARAM0

      if (do_stats) {
        current->insn_index = 107;   /* "l.cust1" */
        analysis(current);
      }
    }
    break;
  case 0x1d:
    /* Instruction: l.cust2 */
    {
      uorreg_t a;
      /* Number of operands: 1 */
      a = (insn >> 0) & 0x0;
      #define SET_PARAM0(val) cpu_state.reg[a] = val
      #define PARAM0 cpu_state.reg[a]
      {         /* "l_cust2" */
      }
      #undef SET_PARAM
      #undef PARAM0

      if (do_stats) {
        current->insn_index = 108;   /* "l.cust2" */
        analysis(current);
      }
    }
    break;
  case 0x1e:
    /* Instruction: l.cust3 */
    {
      uorreg_t a;
      /* Number of operands: 1 */
      a = (insn >> 0) & 0x0;
      #define SET_PARAM0(val) cpu_state.reg[a] = val
      #define PARAM0 cpu_state.reg[a]
      {         /* "l_cust3" */
      }
      #undef SET_PARAM
      #undef PARAM0

      if (do_stats) {
        current->insn_index = 109;   /* "l.cust3" */
        analysis(current);
      }
    }
    break;
  case 0x1f:
    /* Instruction: l.cust4 */
    {
      uorreg_t a;
      /* Number of operands: 1 */
      a = (insn >> 0) & 0x0;
      #define SET_PARAM0(val) cpu_state.reg[a] = val
      #define PARAM0 cpu_state.reg[a]
      {         /* "l_cust4" */
      }
      #undef SET_PARAM
      #undef PARAM0

      if (do_stats) {
        current->insn_index = 110;   /* "l.cust4" */
        analysis(current);
      }
    }
    break;
  case 0x20:
    /* Instruction: l.ld */
    {
      uorreg_t a, b;
      /* Number of operands: 2 */
      a = (insn >> 21) & 0x1f;
      #define SET_PARAM0(val) cpu_state.reg[a] = val
      #define PARAM0 cpu_state.reg[a]
      b = (insn >> 0) & 0xffff;
      if(b & 0x00008000) b |= 0xffff8000;
      *(orreg_t *)&b += (orreg_t)cpu_state.reg[(insn >> 16) & 0x1f];
      #define PARAM1 b
      l_invalid ();
      #undef SET_PARAM
      #undef PARAM0
      #undef PARAM1

      if (do_stats) {
        cpu_state.insn_ea = b;
        current->insn_index = 111;   /* "l.ld" */
        analysis(current);
      }
      cpu_state.reg[0] = 0; /* Repair in case we changed it */
    }
    break;
  case 0x21:
    /* Instruction: l.lwz */
    {
      uorreg_t a, b;
      /* Number of operands: 2 */
      a = (insn >> 21) & 0x1f;
      #define SET_PARAM0(val) cpu_state.reg[a] = val
      #define PARAM0 cpu_state.reg[a]
      b = (insn >> 0) & 0xffff;
      if(b & 0x00008000) b |= 0xffff8000;
      *(orreg_t *)&b += (orreg_t)cpu_state.reg[(insn >> 16) & 0x1f];
      #define PARAM1 b
      {         /* "l_lwz" */
        uint32_t val;
        if (config.cpu.sbuf_len) sbuf_load ();
        val = eval_mem32(PARAM1, &breakpoint);
        /* If eval operand produced exception don't set anything. JPB changed to
           trigger on breakpoint, as well as except_pending (seemed to be a bug). */
        if (!(except_pending || breakpoint))
          SET_PARAM0(val);
      }
      #undef SET_PARAM
      #undef PARAM0
      #undef PARAM1

      if (do_stats) {
        cpu_state.insn_ea = b;
        current->insn_index = 112;   /* "l.lwz" */
        analysis(current);
      }
      cpu_state.reg[0] = 0; /* Repair in case we changed it */
    }
    break;
  case 0x22:
    /* Instruction: l.lws */
    {
      uorreg_t a, b;
      /* Number of operands: 2 */
      a = (insn >> 21) & 0x1f;
      #define SET_PARAM0(val) cpu_state.reg[a] = val
      #define PARAM0 cpu_state.reg[a]
      b = (insn >> 0) & 0xffff;
      if(b & 0x00008000) b |= 0xffff8000;
      *(orreg_t *)&b += (orreg_t)cpu_state.reg[(insn >> 16) & 0x1f];
      #define PARAM1 b
      l_invalid ();
      #undef SET_PARAM
      #undef PARAM0
      #undef PARAM1

      if (do_stats) {
        cpu_state.insn_ea = b;
        current->insn_index = 113;   /* "l.lws" */
        analysis(current);
      }
      cpu_state.reg[0] = 0; /* Repair in case we changed it */
    }
    break;
  case 0x23:
    /* Instruction: l.lbz */
    {
      uorreg_t a, b;
      /* Number of operands: 2 */
      a = (insn >> 21) & 0x1f;
      #define SET_PARAM0(val) cpu_state.reg[a] = val
      #define PARAM0 cpu_state.reg[a]
      b = (insn >> 0) & 0xffff;
      if(b & 0x00008000) b |= 0xffff8000;
      *(orreg_t *)&b += (orreg_t)cpu_state.reg[(insn >> 16) & 0x1f];
      #define PARAM1 b
      {         /* "l_lbz" */
        uint8_t val;
        if (config.cpu.sbuf_len) sbuf_load ();
        val = eval_mem8(PARAM1, &breakpoint);
        /* If eval operand produced exception don't set anything. JPB changed to
           trigger on breakpoint, as well as except_pending (seemed to be a bug). */
        if (!(except_pending || breakpoint))
          SET_PARAM0(val);
      }
      #undef SET_PARAM
      #undef PARAM0
      #undef PARAM1

      if (do_stats) {
        cpu_state.insn_ea = b;
        current->insn_index = 114;   /* "l.lbz" */
        analysis(current);
      }
      cpu_state.reg[0] = 0; /* Repair in case we changed it */
    }
    break;
  case 0x24:
    /* Instruction: l.lbs */
    {
      uorreg_t a, b;
      /* Number of operands: 2 */
      a = (insn >> 21) & 0x1f;
      #define SET_PARAM0(val) cpu_state.reg[a] = val
      #define PARAM0 cpu_state.reg[a]
      b = (insn >> 0) & 0xffff;
      if(b & 0x00008000) b |= 0xffff8000;
      *(orreg_t *)&b += (orreg_t)cpu_state.reg[(insn >> 16) & 0x1f];
      #define PARAM1 b
      {         /* "l_lbs" */
        int8_t val;
        if (config.cpu.sbuf_len) sbuf_load ();
        val = eval_mem8(PARAM1, &breakpoint);
        /* If eval operand produced exception don't set anything. JPB changed to
           trigger on breakpoint, as well as except_pending (seemed to be a bug). */
        if (!(except_pending || breakpoint))
          SET_PARAM0(val);
      }
      #undef SET_PARAM
      #undef PARAM0
      #undef PARAM1

      if (do_stats) {
        cpu_state.insn_ea = b;
        current->insn_index = 115;   /* "l.lbs" */
        analysis(current);
      }
      cpu_state.reg[0] = 0; /* Repair in case we changed it */
    }
    break;
  case 0x25:
    /* Instruction: l.lhz */
    {
      uorreg_t a, b;
      /* Number of operands: 2 */
      a = (insn >> 21) & 0x1f;
      #define SET_PARAM0(val) cpu_state.reg[a] = val
      #define PARAM0 cpu_state.reg[a]
      b = (insn >> 0) & 0xffff;
      if(b & 0x00008000) b |= 0xffff8000;
      *(orreg_t *)&b += (orreg_t)cpu_state.reg[(insn >> 16) & 0x1f];
      #define PARAM1 b
      {         /* "l_lhz" */
        uint16_t val;
        if (config.cpu.sbuf_len) sbuf_load ();
        val = eval_mem16(PARAM1, &breakpoint);
        /* If eval operand produced exception don't set anything. JPB changed to
           trigger on breakpoint, as well as except_pending (seemed to be a bug). */
        if (!(except_pending || breakpoint))
          SET_PARAM0(val);
      }
      #undef SET_PARAM
      #undef PARAM0
      #undef PARAM1

      if (do_stats) {
        cpu_state.insn_ea = b;
        current->insn_index = 116;   /* "l.lhz" */
        analysis(current);
      }
      cpu_state.reg[0] = 0; /* Repair in case we changed it */
    }
    break;
  case 0x26:
    /* Instruction: l.lhs */
    {
      uorreg_t a, b;
      /* Number of operands: 2 */
      a = (insn >> 21) & 0x1f;
      #define SET_PARAM0(val) cpu_state.reg[a] = val
      #define PARAM0 cpu_state.reg[a]
      b = (insn >> 0) & 0xffff;
      if(b & 0x00008000) b |= 0xffff8000;
      *(orreg_t *)&b += (orreg_t)cpu_state.reg[(insn >> 16) & 0x1f];
      #define PARAM1 b
      {         /* "l_lhs" */
        int16_t val;
        if (config.cpu.sbuf_len) sbuf_load ();
        val = eval_mem16(PARAM1, &breakpoint);
        /* If eval operand produced exception don't set anything. JPB changed to
           trigger on breakpoint, as well as except_pending (seemed to be a bug). */
        if (!(except_pending || breakpoint))
          SET_PARAM0(val);
      }
      #undef SET_PARAM
      #undef PARAM0
      #undef PARAM1

      if (do_stats) {
        cpu_state.insn_ea = b;
        current->insn_index = 117;   /* "l.lhs" */
        analysis(current);
      }
      cpu_state.reg[0] = 0; /* Repair in case we changed it */
    }
    break;
  case 0x27:
    /* Instruction: l.addi */
    {
      uorreg_t a, b, c;
      /* Number of operands: 3 */
      a = (insn >> 21) & 0x1f;
      #define SET_PARAM0(val) cpu_state.reg[a] = val
      #define PARAM0 cpu_state.reg[a]
      b = (insn >> 16) & 0x1f;
      #define PARAM1 cpu_state.reg[b]
      c = (insn >> 0) & 0xffff;
      if(c & 0x00008000) c |= 0xffff8000;
      #define PARAM2 c
      {         /* "l_add" */
        orreg_t temp1, temp2, temp3;
        int8_t temp4;
        
        temp2 = (orreg_t)PARAM2;
        temp3 = (orreg_t)PARAM1;
        temp1 = temp2 + temp3;
        SET_PARAM0(temp1);
        SET_OV_FLAG_FN (temp1);
        if (ARITH_SET_FLAG) {
          if(!temp1)
            cpu_state.sprs[SPR_SR] |= SPR_SR_F;
          else
            cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
        }
        if ((uorreg_t) temp1 < (uorreg_t) temp2)
          cpu_state.sprs[SPR_SR] |= SPR_SR_CY;
        else
          cpu_state.sprs[SPR_SR] &= ~SPR_SR_CY;
      
        temp4 = temp1;
        if (temp4 == temp1)
          or1k_mstats.byteadd++;
      }
      #undef SET_PARAM
      #undef PARAM0
      #undef PARAM1
      #undef PARAM2

      if (do_stats) {
        current->insn_index = 118;   /* "l.addi" */
        analysis(current);
      }
      cpu_state.reg[0] = 0; /* Repair in case we changed it */
    }
    break;
  case 0x28:
    /* Instruction: l.addic */
    {
      uorreg_t a, b, c;
      /* Number of operands: 3 */
      a = (insn >> 21) & 0x1f;
      #define SET_PARAM0(val) cpu_state.reg[a] = val
      #define PARAM0 cpu_state.reg[a]
      b = (insn >> 16) & 0x1f;
      #define PARAM1 cpu_state.reg[b]
      c = (insn >> 0) & 0xffff;
      if(c & 0x00008000) c |= 0xffff8000;
      #define PARAM2 c
      l_invalid ();
      #undef SET_PARAM
      #undef PARAM0
      #undef PARAM1
      #undef PARAM2

      if (do_stats) {
        current->insn_index = 119;   /* "l.addic" */
        analysis(current);
      }
      cpu_state.reg[0] = 0; /* Repair in case we changed it */
    }
    break;
  case 0x29:
    /* Instruction: l.andi */
    {
      uorreg_t a, b, c;
      /* Number of operands: 3 */
      a = (insn >> 21) & 0x1f;
      #define SET_PARAM0(val) cpu_state.reg[a] = val
      #define PARAM0 cpu_state.reg[a]
      b = (insn >> 16) & 0x1f;
      #define PARAM1 cpu_state.reg[b]
      c = (insn >> 0) & 0xffff;
      #define PARAM2 c
      {         /* "l_and" */
        uorreg_t temp1;
        temp1 = PARAM1 & PARAM2;
        SET_OV_FLAG_FN (temp1);
        SET_PARAM0(temp1);
        if (ARITH_SET_FLAG) {
          if(!temp1)
            cpu_state.sprs[SPR_SR] |= SPR_SR_F;
          else
            cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
        }
      }
      #undef SET_PARAM
      #undef PARAM0
      #undef PARAM1
      #undef PARAM2

      if (do_stats) {
        current->insn_index = 120;   /* "l.andi" */
        analysis(current);
      }
      cpu_state.reg[0] = 0; /* Repair in case we changed it */
    }
    break;
  case 0x2a:
    /* Instruction: l.ori */
    {
      uorreg_t a, b, c;
      /* Number of operands: 3 */
      a = (insn >> 21) & 0x1f;
      #define SET_PARAM0(val) cpu_state.reg[a] = val
      #define PARAM0 cpu_state.reg[a]
      b = (insn >> 16) & 0x1f;
      #define PARAM1 cpu_state.reg[b]
      c = (insn >> 0) & 0xffff;
      #define PARAM2 c
      {         /* "l_or" */
        uorreg_t temp1;
        temp1 = PARAM1 | PARAM2;
        SET_OV_FLAG_FN (temp1);
        SET_PARAM0(temp1);
      }
      #undef SET_PARAM
      #undef PARAM0
      #undef PARAM1
      #undef PARAM2

      if (do_stats) {
        current->insn_index = 121;   /* "l.ori" */
        analysis(current);
      }
      cpu_state.reg[0] = 0; /* Repair in case we changed it */
    }
    break;
  case 0x2b:
    /* Instruction: l.xori */
    {
      uorreg_t a, b, c;
      /* Number of operands: 3 */
      a = (insn >> 21) & 0x1f;
      #define SET_PARAM0(val) cpu_state.reg[a] = val
      #define PARAM0 cpu_state.reg[a]
      b = (insn >> 16) & 0x1f;
      #define PARAM1 cpu_state.reg[b]
      c = (insn >> 0) & 0xffff;
      if(c & 0x00008000) c |= 0xffff8000;
      #define PARAM2 c
      {         /* "l_xor" */
        uorreg_t temp1;
        temp1 = PARAM1 ^ PARAM2;
        SET_OV_FLAG_FN (temp1);
        SET_PARAM0(temp1);
      }
      #undef SET_PARAM
      #undef PARAM0
      #undef PARAM1
      #undef PARAM2

      if (do_stats) {
        current->insn_index = 122;   /* "l.xori" */
        analysis(current);
      }
      cpu_state.reg[0] = 0; /* Repair in case we changed it */
    }
    break;
  case 0x2c:
    /* Instruction: l.muli */
    {
      uorreg_t a, b, c;
      /* Number of operands: 3 */
      a = (insn >> 21) & 0x1f;
      #define SET_PARAM0(val) cpu_state.reg[a] = val
      #define PARAM0 cpu_state.reg[a]
      b = (insn >> 16) & 0x1f;
      #define PARAM1 cpu_state.reg[b]
      c = (insn >> 0) & 0xffff;
      if(c & 0x00008000) c |= 0xffff8000;
      #define PARAM2 c
      {         /* "l_mul" */
        orreg_t temp1;
        
        temp1 = (orreg_t)PARAM1 * (orreg_t)PARAM2;
        SET_OV_FLAG_FN (temp1);
        SET_PARAM0(temp1);
        /*if (!(mcount++ & 1023)) {
          PRINTF ("[%i]\n",mcount);
          }*/
      }
      #undef SET_PARAM
      #undef PARAM0
      #undef PARAM1
      #undef PARAM2

      if (do_stats) {
        current->insn_index = 123;   /* "l.muli" */
        analysis(current);
      }
      cpu_state.reg[0] = 0; /* Repair in case we changed it */
    }
    break;
  case 0x2d:
    /* Instruction: l.mfspr */
    {
      uorreg_t a, b, c;
      /* Number of operands: 3 */
      a = (insn >> 21) & 0x1f;
      #define SET_PARAM0(val) cpu_state.reg[a] = val
      #define PARAM0 cpu_state.reg[a]
      b = (insn >> 16) & 0x1f;
      #define PARAM1 cpu_state.reg[b]
      c = (insn >> 0) & 0xffff;
      #define PARAM2 c
      {         /* "l_mfspr" */
        uint16_t regno = PARAM1 + PARAM2;
        uorreg_t value = mfspr(regno);
      
        if (cpu_state.sprs[SPR_SR] & SPR_SR_SM)
          SET_PARAM0(value);
        else {
          SET_PARAM0(0);
          PRINTF("WARNING: trying to read SPR while SR[SUPV] is cleared.\n");
          sim_done("WARNING: trying to read SPR while SR[SUPV] is cleared.\n");
        }
      }
      #undef SET_PARAM
      #undef PARAM0
      #undef PARAM1
      #undef PARAM2

      if (do_stats) {
        current->insn_index = 124;   /* "l.mfspr" */
        analysis(current);
      }
      cpu_state.reg[0] = 0; /* Repair in case we changed it */
    }
    break;
  case 0x2e:
    switch((insn >> 6) & 0x3) {
    case 0x0:
      /* Instruction: l.slli */
      {
        uorreg_t a, b, c;
        /* Number of operands: 3 */
        a = (insn >> 21) & 0x1f;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        b = (insn >> 16) & 0x1f;
        #define PARAM1 cpu_state.reg[b]
        c = (insn >> 0) & 0x3f;
        #define PARAM2 c
        {           /* "l_sll" */
          uorreg_t temp1;
        
          temp1 = PARAM1 << PARAM2;
          SET_OV_FLAG_FN (temp1);
          SET_PARAM0(temp1);
          /* runtime.sim.cycles += 2; */
        }
        #undef SET_PARAM
        #undef PARAM0
        #undef PARAM1
        #undef PARAM2

        if (do_stats) {
          current->insn_index = 125;   /* "l.slli" */
          analysis(current);
        }
        cpu_state.reg[0] = 0; /* Repair in case we changed it */
      }
      break;
    case 0x1:
      /* Instruction: l.srli */
      {
        uorreg_t a, b, c;
        /* Number of operands: 3 */
        a = (insn >> 21) & 0x1f;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        b = (insn >> 16) & 0x1f;
        #define PARAM1 cpu_state.reg[b]
        c = (insn >> 0) & 0x3f;
        #define PARAM2 c
        {           /* "l_srl" */
          uorreg_t temp1;
          temp1 = PARAM1 >> PARAM2;
          SET_OV_FLAG_FN (temp1);
          SET_PARAM0(temp1);
          /* runtime.sim.cycles += 2; */
        }
        #undef SET_PARAM
        #undef PARAM0
        #undef PARAM1
        #undef PARAM2

        if (do_stats) {
          current->insn_index = 126;   /* "l.srli" */
          analysis(current);
        }
        cpu_state.reg[0] = 0; /* Repair in case we changed it */
      }
      break;
    case 0x2:
      /* Instruction: l.srai */
      {
        uorreg_t a, b, c;
        /* Number of operands: 3 */
        a = (insn >> 21) & 0x1f;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        b = (insn >> 16) & 0x1f;
        #define PARAM1 cpu_state.reg[b]
        c = (insn >> 0) & 0x3f;
        #define PARAM2 c
        {           /* "l_sra" */
          orreg_t temp1;
          
          temp1 = (orreg_t)PARAM1 >> PARAM2;
          SET_OV_FLAG_FN (temp1);
          SET_PARAM0(temp1);
          /* runtime.sim.cycles += 2; */
        }
        #undef SET_PARAM
        #undef PARAM0
        #undef PARAM1
        #undef PARAM2

        if (do_stats) {
          current->insn_index = 127;   /* "l.srai" */
          analysis(current);
        }
        cpu_state.reg[0] = 0; /* Repair in case we changed it */
      }
      break;
    case 0x3:
      /* Instruction: l.rori */
      {
        uorreg_t a, b, c;
        /* Number of operands: 3 */
        a = (insn >> 21) & 0x1f;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        b = (insn >> 16) & 0x1f;
        #define PARAM1 cpu_state.reg[b]
        c = (insn >> 0) & 0x3f;
        #define PARAM2 c
        l_invalid ();
        #undef SET_PARAM
        #undef PARAM0
        #undef PARAM1
        #undef PARAM2

        if (do_stats) {
          current->insn_index = 128;   /* "l.rori" */
          analysis(current);
        }
        cpu_state.reg[0] = 0; /* Repair in case we changed it */
      }
      break;
    }
    break;
  case 0x2f:
    switch((insn >> 21) & 0x1f) {
    case 0x0:
      /* Instruction: l.sfeqi */
      {
        uorreg_t a, b;
        /* Number of operands: 2 */
        a = (insn >> 16) & 0x1f;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        b = (insn >> 0) & 0xffff;
        if(b & 0x00008000) b |= 0xffff8000;
        #define PARAM1 b
        {           /* "l_sfeq" */
          if(PARAM0 == PARAM1)
            cpu_state.sprs[SPR_SR] |= SPR_SR_F;
          else
            cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
        }
        #undef SET_PARAM
        #undef PARAM0
        #undef PARAM1

        if (do_stats) {
          current->insn_index = 129;   /* "l.sfeqi" */
          analysis(current);
        }
      }
      break;
    case 0x1:
      /* Instruction: l.sfnei */
      {
        uorreg_t a, b;
        /* Number of operands: 2 */
        a = (insn >> 16) & 0x1f;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        b = (insn >> 0) & 0xffff;
        if(b & 0x00008000) b |= 0xffff8000;
        #define PARAM1 b
        {           /* "l_sfne" */
          if(PARAM0 != PARAM1)
            cpu_state.sprs[SPR_SR] |= SPR_SR_F;
          else
            cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
        }
        #undef SET_PARAM
        #undef PARAM0
        #undef PARAM1

        if (do_stats) {
          current->insn_index = 130;   /* "l.sfnei" */
          analysis(current);
        }
      }
      break;
    case 0x2:
      /* Instruction: l.sfgtui */
      {
        uorreg_t a, b;
        /* Number of operands: 2 */
        a = (insn >> 16) & 0x1f;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        b = (insn >> 0) & 0xffff;
        if(b & 0x00008000) b |= 0xffff8000;
        #define PARAM1 b
        {           /* "l_sfgtu" */
          if(PARAM0 > PARAM1)
            cpu_state.sprs[SPR_SR] |= SPR_SR_F;
          else
            cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
        }
        #undef SET_PARAM
        #undef PARAM0
        #undef PARAM1

        if (do_stats) {
          current->insn_index = 131;   /* "l.sfgtui" */
          analysis(current);
        }
      }
      break;
    case 0x3:
      /* Instruction: l.sfgeui */
      {
        uorreg_t a, b;
        /* Number of operands: 2 */
        a = (insn >> 16) & 0x1f;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        b = (insn >> 0) & 0xffff;
        if(b & 0x00008000) b |= 0xffff8000;
        #define PARAM1 b
        {           /* "l_sfgeu" */
          if(PARAM0 >= PARAM1)
            cpu_state.sprs[SPR_SR] |= SPR_SR_F;
          else
            cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
        }
        #undef SET_PARAM
        #undef PARAM0
        #undef PARAM1

        if (do_stats) {
          current->insn_index = 132;   /* "l.sfgeui" */
          analysis(current);
        }
      }
      break;
    case 0x4:
      /* Instruction: l.sfltui */
      {
        uorreg_t a, b;
        /* Number of operands: 2 */
        a = (insn >> 16) & 0x1f;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        b = (insn >> 0) & 0xffff;
        if(b & 0x00008000) b |= 0xffff8000;
        #define PARAM1 b
        {           /* "l_sfltu" */
          if(PARAM0 < PARAM1)
            cpu_state.sprs[SPR_SR] |= SPR_SR_F;
          else
            cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
        }
        #undef SET_PARAM
        #undef PARAM0
        #undef PARAM1

        if (do_stats) {
          current->insn_index = 133;   /* "l.sfltui" */
          analysis(current);
        }
      }
      break;
    case 0x5:
      /* Instruction: l.sfleui */
      {
        uorreg_t a, b;
        /* Number of operands: 2 */
        a = (insn >> 16) & 0x1f;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        b = (insn >> 0) & 0xffff;
        if(b & 0x00008000) b |= 0xffff8000;
        #define PARAM1 b
        {           /* "l_sfleu" */
          if(PARAM0 <= PARAM1)
            cpu_state.sprs[SPR_SR] |= SPR_SR_F;
          else
            cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
        }
        #undef SET_PARAM
        #undef PARAM0
        #undef PARAM1

        if (do_stats) {
          current->insn_index = 134;   /* "l.sfleui" */
          analysis(current);
        }
      }
      break;
    case 0x6:
    case 0x7:
    case 0x8:
    case 0x9:
      /* Invalid instruction(s) */
      break;
    case 0xa:
      /* Instruction: l.sfgtsi */
      {
        uorreg_t a, b;
        /* Number of operands: 2 */
        a = (insn >> 16) & 0x1f;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        b = (insn >> 0) & 0xffff;
        if(b & 0x00008000) b |= 0xffff8000;
        #define PARAM1 b
        {           /* "l_sfgts" */
          if((orreg_t)PARAM0 > (orreg_t)PARAM1)
            cpu_state.sprs[SPR_SR] |= SPR_SR_F;
          else
            cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
        }
        #undef SET_PARAM
        #undef PARAM0
        #undef PARAM1

        if (do_stats) {
          current->insn_index = 135;   /* "l.sfgtsi" */
          analysis(current);
        }
      }
      break;
    case 0xb:
      /* Instruction: l.sfgesi */
      {
        uorreg_t a, b;
        /* Number of operands: 2 */
        a = (insn >> 16) & 0x1f;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        b = (insn >> 0) & 0xffff;
        if(b & 0x00008000) b |= 0xffff8000;
        #define PARAM1 b
        {           /* "l_sfges" */
          if((orreg_t)PARAM0 >= (orreg_t)PARAM1)
            cpu_state.sprs[SPR_SR] |= SPR_SR_F;
          else
            cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
        }
        #undef SET_PARAM
        #undef PARAM0
        #undef PARAM1

        if (do_stats) {
          current->insn_index = 136;   /* "l.sfgesi" */
          analysis(current);
        }
      }
      break;
    case 0xc:
      /* Instruction: l.sfltsi */
      {
        uorreg_t a, b;
        /* Number of operands: 2 */
        a = (insn >> 16) & 0x1f;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        b = (insn >> 0) & 0xffff;
        if(b & 0x00008000) b |= 0xffff8000;
        #define PARAM1 b
        {           /* "l_sflts" */
          if((orreg_t)PARAM0 < (orreg_t)PARAM1)
            cpu_state.sprs[SPR_SR] |= SPR_SR_F;
          else
            cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
        }
        #undef SET_PARAM
        #undef PARAM0
        #undef PARAM1

        if (do_stats) {
          current->insn_index = 137;   /* "l.sfltsi" */
          analysis(current);
        }
      }
      break;
    case 0xd:
      /* Instruction: l.sflesi */
      {
        uorreg_t a, b;
        /* Number of operands: 2 */
        a = (insn >> 16) & 0x1f;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        b = (insn >> 0) & 0xffff;
        if(b & 0x00008000) b |= 0xffff8000;
        #define PARAM1 b
        {           /* "l_sfles" */
          if((orreg_t)PARAM0 <= (orreg_t)PARAM1)
            cpu_state.sprs[SPR_SR] |= SPR_SR_F;
          else
            cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
        }
        #undef SET_PARAM
        #undef PARAM0
        #undef PARAM1

        if (do_stats) {
          current->insn_index = 138;   /* "l.sflesi" */
          analysis(current);
        }
      }
      break;
    case 0xe:
    case 0xf:
    case 0x10:
    case 0x11:
    case 0x12:
    case 0x13:
    case 0x14:
    case 0x15:
    case 0x16:
    case 0x17:
    case 0x18:
    case 0x19:
    case 0x1a:
    case 0x1b:
    case 0x1c:
    case 0x1d:
    case 0x1e:
    case 0x1f:
      /* Invalid instruction(s) */
      break;
    }
    break;
  case 0x30:
    /* Instruction: l.mtspr */
    {
      uorreg_t a, b, c;
      /* Number of operands: 3 */
      a = (insn >> 16) & 0x1f;
      #define SET_PARAM0(val) cpu_state.reg[a] = val
      #define PARAM0 cpu_state.reg[a]
      b = (insn >> 11) & 0x1f;
      #define PARAM1 cpu_state.reg[b]
      c = (insn >> 0) & 0x7ff;
      c |= ((insn >> 21) & 0x1f) << 11;
      #define PARAM2 c
      {         /* "l_mtspr" */
        uint16_t regno = PARAM0 + PARAM2;
        uorreg_t value = PARAM1;
      
        if (cpu_state.sprs[SPR_SR] & SPR_SR_SM)
          mtspr(regno, value);
        else {
          PRINTF("WARNING: trying to write SPR while SR[SUPV] is cleared.\n");
          sim_done("WARNING: trying to write SPR while SR[SUPV] is cleared.\n");
        }
      }
      #undef SET_PARAM
      #undef PARAM0
      #undef PARAM1
      #undef PARAM2

      if (do_stats) {
        current->insn_index = 139;   /* "l.mtspr" */
        analysis(current);
      }
    }
    break;
  case 0x31:
    switch((insn >> 0) & 0xf) {
    case 0x0:
      /* Invalid instruction(s) */
      break;
    case 0x1:
      /* Instruction: l.mac */
      {
        uorreg_t a, b;
        /* Number of operands: 2 */
        a = (insn >> 16) & 0x1f;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        b = (insn >> 11) & 0x1f;
        #define PARAM1 cpu_state.reg[b]
        {           /* "l_mac" */
          uorreg_t lo, hi;
          LONGEST l;
          orreg_t x, y;
        
          lo = cpu_state.sprs[SPR_MACLO];
          hi = cpu_state.sprs[SPR_MACHI];
          x = PARAM0;
          y = PARAM1;
        /*   PRINTF ("[%"PRIxREG",%"PRIxREG"]\t", x, y); */
          l = (ULONGEST)lo | ((LONGEST)hi << 32);
          l += (LONGEST) x * (LONGEST) y;
        
          /* This implementation is very fast - it needs only one cycle for mac.  */
          lo = ((ULONGEST)l) & 0xFFFFFFFF;
          hi = ((LONGEST)l) >> 32;
          cpu_state.sprs[SPR_MACLO] = lo;
          cpu_state.sprs[SPR_MACHI] = hi;
        /*   PRINTF ("(%"PRIxREG",%"PRIxREG"\n", hi, lo); */
        }
        #undef SET_PARAM
        #undef PARAM0
        #undef PARAM1

        if (do_stats) {
          current->insn_index = 140;   /* "l.mac" */
          analysis(current);
        }
      }
      break;
    case 0x2:
      /* Instruction: l.msb */
      {
        uorreg_t a, b;
        /* Number of operands: 2 */
        a = (insn >> 16) & 0x1f;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        b = (insn >> 11) & 0x1f;
        #define PARAM1 cpu_state.reg[b]
        {           /* "l_msb" */
          uorreg_t lo, hi;  
          LONGEST l;
          orreg_t x, y;
        
          lo = cpu_state.sprs[SPR_MACLO];
          hi = cpu_state.sprs[SPR_MACHI];
          x = PARAM0;
          y = PARAM1;
        
        /*   PRINTF ("[%"PRIxREG",%"PRIxREG"]\t", x, y); */
        
          l = (ULONGEST)lo | ((LONGEST)hi << 32);
          l -= x * y;
        
          /* This implementation is very fast - it needs only one cycle for msb.  */
          lo = ((ULONGEST)l) & 0xFFFFFFFF;
          hi = ((LONGEST)l) >> 32;
          cpu_state.sprs[SPR_MACLO] = lo;
          cpu_state.sprs[SPR_MACHI] = hi;
        /*   PRINTF ("(%"PRIxREG",%"PRIxREG")\n", hi, lo); */
        }
        #undef SET_PARAM
        #undef PARAM0
        #undef PARAM1

        if (do_stats) {
          current->insn_index = 141;   /* "l.msb" */
          analysis(current);
        }
      }
      break;
    case 0x3:
    case 0x4:
    case 0x5:
    case 0x6:
    case 0x7:
    case 0x8:
    case 0x9:
    case 0xa:
    case 0xb:
    case 0xc:
    case 0xd:
    case 0xe:
    case 0xf:
      /* Invalid instruction(s) */
      break;
    }
    break;
  case 0x32:
    switch((insn >> 4) & 0xf) {
    case 0x0:
      switch((insn >> 0) & 0xf) {
      case 0x0:
        /* Instruction: lf.add.s */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          {             /* "lf_add_s" */
            SET_PARAM0((float)PARAM1 + (float)PARAM2);
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 142;   /* "lf.add.s" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x1:
        /* Instruction: lf.sub.s */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          {             /* "lf_sub_s" */
            SET_PARAM0((float)PARAM1 - (float)PARAM2);
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 143;   /* "lf.sub.s" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x2:
        /* Instruction: lf.mul.s */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          {             /* "lf_mul_s" */
            SET_PARAM0((float)PARAM1 * (float)PARAM2);
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 144;   /* "lf.mul.s" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x3:
        /* Instruction: lf.div.s */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          {             /* "lf_div_s" */
            SET_PARAM0((float)PARAM1 / (float)PARAM2);
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 145;   /* "lf.div.s" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x4:
        /* Not unique: real mask fc00f8ff and current mask fc0000ff differ - do final check */
        if((insn & 0xfc00f8ff) == 0xc8000004) {
          /* Instruction: lf.itof.s */
          {
            uorreg_t a, b;
            /* Number of operands: 2 */
            a = (insn >> 21) & 0x1f;
            #define SET_PARAM0(val) cpu_state.reg[a] = val
            #define PARAM0 cpu_state.reg[a]
            b = (insn >> 16) & 0x1f;
            #define PARAM1 cpu_state.reg[b]
            {               /* "lf_itof_s" */
            //  freg[get_operand(0)] = eval_operand32(1, &breakpoint);
            }
            #undef SET_PARAM
            #undef PARAM0
            #undef PARAM1

            if (do_stats) {
              current->insn_index = 146;   /* "lf.itof.s" */
              analysis(current);
            }
            cpu_state.reg[0] = 0; /* Repair in case we changed it */
          }
        } else {
          /* Invalid insn */
          {
            l_invalid ();

            if (do_stats) {
              current->insn_index = -1;   /* "???" */
              analysis(current);
            }
            cpu_state.reg[0] = 0; /* Repair in case we changed it */
          }
        }
        break;
      case 0x5:
        /* Not unique: real mask fc00f8ff and current mask fc0000ff differ - do final check */
        if((insn & 0xfc00f8ff) == 0xc8000005) {
          /* Instruction: lf.ftoi.s */
          {
            uorreg_t a, b;
            /* Number of operands: 2 */
            a = (insn >> 21) & 0x1f;
            #define SET_PARAM0(val) cpu_state.reg[a] = val
            #define PARAM0 cpu_state.reg[a]
            b = (insn >> 16) & 0x1f;
            #define PARAM1 cpu_state.reg[b]
            {               /* "lf_ftoi_s" */
            //  set_operand32(0, freg[get_operand(1)], &breakpoint);
            }
            #undef SET_PARAM
            #undef PARAM0
            #undef PARAM1

            if (do_stats) {
              current->insn_index = 147;   /* "lf.ftoi.s" */
              analysis(current);
            }
            cpu_state.reg[0] = 0; /* Repair in case we changed it */
          }
        } else {
          /* Invalid insn */
          {
            l_invalid ();

            if (do_stats) {
              current->insn_index = -1;   /* "???" */
              analysis(current);
            }
            cpu_state.reg[0] = 0; /* Repair in case we changed it */
          }
        }
        break;
      case 0x6:
        /* Instruction: lf.rem.s */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          {             /* "lf_rem_s" */
            float temp = (float)PARAM1 / (float)PARAM2;
            SET_PARAM0(temp - (uint32_t)temp);
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 148;   /* "lf.rem.s" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x7:
        /* Instruction: lf.madd.s */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          {             /* "lf_madd_s" */
            SET_PARAM0((float)PARAM0 + (float)PARAM1 * (float)PARAM2);
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 149;   /* "lf.madd.s" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x8:
        /* Instruction: lf.sfeq.s */
        {
          uorreg_t a, b;
          /* Number of operands: 2 */
          a = (insn >> 16) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 11) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          {             /* "lf_sfeq_s" */
            if((float)PARAM0 == (float)PARAM1)
              cpu_state.sprs[SPR_SR] |= SPR_SR_F;
            else
              cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1

          if (do_stats) {
            current->insn_index = 150;   /* "lf.sfeq.s" */
            analysis(current);
          }
        }
        break;
      case 0x9:
        /* Instruction: lf.sfne.s */
        {
          uorreg_t a, b;
          /* Number of operands: 2 */
          a = (insn >> 16) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 11) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          {             /* "lf_sfne_s" */
            if((float)PARAM0 != (float)PARAM1)
              cpu_state.sprs[SPR_SR] |= SPR_SR_F;
            else
              cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1

          if (do_stats) {
            current->insn_index = 151;   /* "lf.sfne.s" */
            analysis(current);
          }
        }
        break;
      case 0xa:
        /* Instruction: lf.sfgt.s */
        {
          uorreg_t a, b;
          /* Number of operands: 2 */
          a = (insn >> 16) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 11) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          {             /* "lf_sfgt_s" */
            if((float)PARAM0 > (float)PARAM1)
              cpu_state.sprs[SPR_SR] |= SPR_SR_F;
            else
              cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1

          if (do_stats) {
            current->insn_index = 152;   /* "lf.sfgt.s" */
            analysis(current);
          }
        }
        break;
      case 0xb:
        /* Instruction: lf.sfge.s */
        {
          uorreg_t a, b;
          /* Number of operands: 2 */
          a = (insn >> 16) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 11) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          {             /* "lf_sfge_s" */
            if((float)PARAM0 >= (float)PARAM1)
              cpu_state.sprs[SPR_SR] |= SPR_SR_F;
            else
              cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1

          if (do_stats) {
            current->insn_index = 153;   /* "lf.sfge.s" */
            analysis(current);
          }
        }
        break;
      case 0xc:
        /* Instruction: lf.sflt.s */
        {
          uorreg_t a, b;
          /* Number of operands: 2 */
          a = (insn >> 16) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 11) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          {             /* "lf_sflt_s" */
            if((float)PARAM0 < (float)PARAM1)
              cpu_state.sprs[SPR_SR] |= SPR_SR_F;
            else
              cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1

          if (do_stats) {
            current->insn_index = 154;   /* "lf.sflt.s" */
            analysis(current);
          }
        }
        break;
      case 0xd:
        /* Instruction: lf.sfle.s */
        {
          uorreg_t a, b;
          /* Number of operands: 2 */
          a = (insn >> 16) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 11) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          {             /* "lf_sfle_s" */
            if((float)PARAM0 <= (float)PARAM1)
              cpu_state.sprs[SPR_SR] |= SPR_SR_F;
            else
              cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1

          if (do_stats) {
            current->insn_index = 155;   /* "lf.sfle.s" */
            analysis(current);
          }
        }
        break;
      case 0xe:
      case 0xf:
        /* Invalid instruction(s) */
        break;
      }
      break;
    case 0x1:
      switch((insn >> 0) & 0xf) {
      case 0x0:
        /* Instruction: lf.add.d */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 157;   /* "lf.add.d" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x1:
        /* Instruction: lf.sub.d */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 158;   /* "lf.sub.d" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x2:
        /* Instruction: lf.mul.d */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 159;   /* "lf.mul.d" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x3:
        /* Instruction: lf.div.d */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 160;   /* "lf.div.d" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x4:
        /* Not unique: real mask fc00f8ff and current mask fc0000ff differ - do final check */
        if((insn & 0xfc00f8ff) == 0xc8000014) {
          /* Instruction: lf.itof.d */
          {
            uorreg_t a, b;
            /* Number of operands: 2 */
            a = (insn >> 21) & 0x1f;
            #define SET_PARAM0(val) cpu_state.reg[a] = val
            #define PARAM0 cpu_state.reg[a]
            b = (insn >> 16) & 0x1f;
            #define PARAM1 cpu_state.reg[b]
            l_invalid ();
            #undef SET_PARAM
            #undef PARAM0
            #undef PARAM1

            if (do_stats) {
              current->insn_index = 161;   /* "lf.itof.d" */
              analysis(current);
            }
            cpu_state.reg[0] = 0; /* Repair in case we changed it */
          }
        } else {
          /* Invalid insn */
          {
            l_invalid ();

            if (do_stats) {
              current->insn_index = -1;   /* "???" */
              analysis(current);
            }
            cpu_state.reg[0] = 0; /* Repair in case we changed it */
          }
        }
        break;
      case 0x5:
        /* Not unique: real mask fc00f8ff and current mask fc0000ff differ - do final check */
        if((insn & 0xfc00f8ff) == 0xc8000015) {
          /* Instruction: lf.ftoi.d */
          {
            uorreg_t a, b;
            /* Number of operands: 2 */
            a = (insn >> 21) & 0x1f;
            #define SET_PARAM0(val) cpu_state.reg[a] = val
            #define PARAM0 cpu_state.reg[a]
            b = (insn >> 16) & 0x1f;
            #define PARAM1 cpu_state.reg[b]
            l_invalid ();
            #undef SET_PARAM
            #undef PARAM0
            #undef PARAM1

            if (do_stats) {
              current->insn_index = 162;   /* "lf.ftoi.d" */
              analysis(current);
            }
            cpu_state.reg[0] = 0; /* Repair in case we changed it */
          }
        } else {
          /* Invalid insn */
          {
            l_invalid ();

            if (do_stats) {
              current->insn_index = -1;   /* "???" */
              analysis(current);
            }
            cpu_state.reg[0] = 0; /* Repair in case we changed it */
          }
        }
        break;
      case 0x6:
        /* Instruction: lf.rem.d */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 163;   /* "lf.rem.d" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x7:
        /* Instruction: lf.madd.d */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 164;   /* "lf.madd.d" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x8:
        /* Instruction: lf.sfeq.d */
        {
          uorreg_t a, b;
          /* Number of operands: 2 */
          a = (insn >> 16) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 11) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1

          if (do_stats) {
            current->insn_index = 165;   /* "lf.sfeq.d" */
            analysis(current);
          }
        }
        break;
      case 0x9:
        /* Instruction: lf.sfne.d */
        {
          uorreg_t a, b;
          /* Number of operands: 2 */
          a = (insn >> 16) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 11) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1

          if (do_stats) {
            current->insn_index = 166;   /* "lf.sfne.d" */
            analysis(current);
          }
        }
        break;
      case 0xa:
        /* Instruction: lf.sfgt.d */
        {
          uorreg_t a, b;
          /* Number of operands: 2 */
          a = (insn >> 16) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 11) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1

          if (do_stats) {
            current->insn_index = 167;   /* "lf.sfgt.d" */
            analysis(current);
          }
        }
        break;
      case 0xb:
        /* Instruction: lf.sfge.d */
        {
          uorreg_t a, b;
          /* Number of operands: 2 */
          a = (insn >> 16) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 11) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1

          if (do_stats) {
            current->insn_index = 168;   /* "lf.sfge.d" */
            analysis(current);
          }
        }
        break;
      case 0xc:
        /* Instruction: lf.sflt.d */
        {
          uorreg_t a, b;
          /* Number of operands: 2 */
          a = (insn >> 16) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 11) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1

          if (do_stats) {
            current->insn_index = 169;   /* "lf.sflt.d" */
            analysis(current);
          }
        }
        break;
      case 0xd:
        /* Instruction: lf.sfle.d */
        {
          uorreg_t a, b;
          /* Number of operands: 2 */
          a = (insn >> 16) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 11) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1

          if (do_stats) {
            current->insn_index = 170;   /* "lf.sfle.d" */
            analysis(current);
          }
        }
        break;
      case 0xe:
      case 0xf:
        /* Invalid instruction(s) */
        break;
      }
      break;
    case 0x2:
    case 0x3:
    case 0x4:
    case 0x5:
    case 0x6:
    case 0x7:
    case 0x8:
    case 0x9:
    case 0xa:
    case 0xb:
    case 0xc:
      /* Invalid instruction(s) */
      break;
    case 0xd:
      /* Instruction: lf.cust1.s */
      {
        uorreg_t a, b;
        /* Number of operands: 2 */
        a = (insn >> 16) & 0x1f;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        b = (insn >> 11) & 0x1f;
        #define PARAM1 cpu_state.reg[b]
        l_invalid ();
        #undef SET_PARAM
        #undef PARAM0
        #undef PARAM1

        if (do_stats) {
          current->insn_index = 156;   /* "lf.cust1.s" */
          analysis(current);
        }
      }
      break;
    case 0xe:
      /* Instruction: lf.cust1.d */
      {
        uorreg_t a, b;
        /* Number of operands: 2 */
        a = (insn >> 16) & 0x1f;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        b = (insn >> 11) & 0x1f;
        #define PARAM1 cpu_state.reg[b]
        l_invalid ();
        #undef SET_PARAM
        #undef PARAM0
        #undef PARAM1

        if (do_stats) {
          current->insn_index = 171;   /* "lf.cust1.d" */
          analysis(current);
        }
      }
      break;
    case 0xf:
      /* Invalid instruction(s) */
      break;
    }
    break;
  case 0x33:
    /* Invalid instruction(s) */
    break;
  case 0x34:
    /* Instruction: l.sd */
    {
      uorreg_t a, b;
      /* Number of operands: 2 */
      a = (insn >> 0) & 0x7ff;
      a |= ((insn >> 21) & 0x1f) << 11;
      if(a & 0x00008000) a |= 0xffff8000;
      *(orreg_t *)&a += (orreg_t)cpu_state.reg[(insn >> 16) & 0x1f];
      #define PARAM0 a
      b = (insn >> 11) & 0x1f;
      #define PARAM1 cpu_state.reg[b]
      l_invalid ();
      #undef PARAM0
      #undef PARAM1

      if (do_stats) {
        cpu_state.insn_ea = a;
        current->insn_index = 172;   /* "l.sd" */
        analysis(current);
      }
    }
    break;
  case 0x35:
    /* Instruction: l.sw */
    {
      uorreg_t a, b;
      /* Number of operands: 2 */
      a = (insn >> 0) & 0x7ff;
      a |= ((insn >> 21) & 0x1f) << 11;
      if(a & 0x00008000) a |= 0xffff8000;
      *(orreg_t *)&a += (orreg_t)cpu_state.reg[(insn >> 16) & 0x1f];
      #define PARAM0 a
      b = (insn >> 11) & 0x1f;
      #define PARAM1 cpu_state.reg[b]
      {         /* "l_sw" */
        int old_cyc = 0;
        if (config.cpu.sbuf_len) old_cyc = runtime.sim.mem_cycles;
        set_mem32(PARAM0, PARAM1, &breakpoint);
        if (config.cpu.sbuf_len) {
          int t = runtime.sim.mem_cycles;
          runtime.sim.mem_cycles = old_cyc;
          sbuf_store (t - old_cyc);
        }
      }
      #undef PARAM0
      #undef PARAM1

      if (do_stats) {
        cpu_state.insn_ea = a;
        current->insn_index = 173;   /* "l.sw" */
        analysis(current);
      }
    }
    break;
  case 0x36:
    /* Instruction: l.sb */
    {
      uorreg_t a, b;
      /* Number of operands: 2 */
      a = (insn >> 0) & 0x7ff;
      a |= ((insn >> 21) & 0x1f) << 11;
      if(a & 0x00008000) a |= 0xffff8000;
      *(orreg_t *)&a += (orreg_t)cpu_state.reg[(insn >> 16) & 0x1f];
      #define PARAM0 a
      b = (insn >> 11) & 0x1f;
      #define PARAM1 cpu_state.reg[b]
      {         /* "l_sb" */
        int old_cyc = 0;
        if (config.cpu.sbuf_len) old_cyc = runtime.sim.mem_cycles;
        set_mem8(PARAM0, PARAM1, &breakpoint);
        if (config.cpu.sbuf_len) {
          int t = runtime.sim.mem_cycles;
          runtime.sim.mem_cycles = old_cyc;
          sbuf_store (t- old_cyc);
        }
      }
      #undef PARAM0
      #undef PARAM1

      if (do_stats) {
        cpu_state.insn_ea = a;
        current->insn_index = 174;   /* "l.sb" */
        analysis(current);
      }
    }
    break;
  case 0x37:
    /* Instruction: l.sh */
    {
      uorreg_t a, b;
      /* Number of operands: 2 */
      a = (insn >> 0) & 0x7ff;
      a |= ((insn >> 21) & 0x1f) << 11;
      if(a & 0x00008000) a |= 0xffff8000;
      *(orreg_t *)&a += (orreg_t)cpu_state.reg[(insn >> 16) & 0x1f];
      #define PARAM0 a
      b = (insn >> 11) & 0x1f;
      #define PARAM1 cpu_state.reg[b]
      {         /* "l_sh" */
        int old_cyc = 0;
        if (config.cpu.sbuf_len) old_cyc = runtime.sim.mem_cycles;
        set_mem16(PARAM0, PARAM1, &breakpoint);
        if (config.cpu.sbuf_len) {
          int t = runtime.sim.mem_cycles;
          runtime.sim.mem_cycles = old_cyc;
          sbuf_store (t - old_cyc);
        }
      }
      #undef PARAM0
      #undef PARAM1

      if (do_stats) {
        cpu_state.insn_ea = a;
        current->insn_index = 175;   /* "l.sh" */
        analysis(current);
      }
    }
    break;
  case 0x38:
    switch((insn >> 0) & 0xf) {
    case 0x0:
      /* Not unique: real mask fc00030f and current mask fc00000f differ - do final check */
      if((insn & 0xfc00030f) == 0xe0000000) {
        /* Instruction: l.add */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          {             /* "l_add" */
            orreg_t temp1, temp2, temp3;
            int8_t temp4;
            
            temp2 = (orreg_t)PARAM2;
            temp3 = (orreg_t)PARAM1;
            temp1 = temp2 + temp3;
            SET_PARAM0(temp1);
            SET_OV_FLAG_FN (temp1);
            if (ARITH_SET_FLAG) {
              if(!temp1)
                cpu_state.sprs[SPR_SR] |= SPR_SR_F;
              else
                cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
            }
            if ((uorreg_t) temp1 < (uorreg_t) temp2)
              cpu_state.sprs[SPR_SR] |= SPR_SR_CY;
            else
              cpu_state.sprs[SPR_SR] &= ~SPR_SR_CY;
          
            temp4 = temp1;
            if (temp4 == temp1)
              or1k_mstats.byteadd++;
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 176;   /* "l.add" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
      } else {
        /* Invalid insn */
        {
          l_invalid ();

          if (do_stats) {
            current->insn_index = -1;   /* "???" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
      }
      break;
    case 0x1:
      /* Not unique: real mask fc00030f and current mask fc00000f differ - do final check */
      if((insn & 0xfc00030f) == 0xe0000001) {
        /* Instruction: l.addc */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          {             /* "l_addc" */
            orreg_t temp1, temp2, temp3;
            int8_t temp4;
            
            temp2 = (orreg_t)PARAM2;
            temp3 = (orreg_t)PARAM1;
            temp1 = temp2 + temp3;
            if(cpu_state.sprs[SPR_SR] & SPR_SR_CY)
              temp1++;
            SET_PARAM0(temp1);
            SET_OV_FLAG_FN (temp1);
            if (ARITH_SET_FLAG) {
              if(!temp1)
                cpu_state.sprs[SPR_SR] |= SPR_SR_F;
              else
                cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
            }
            if ((uorreg_t) temp1 < (uorreg_t) temp2)
              cpu_state.sprs[SPR_SR] |= SPR_SR_CY;
            else
              cpu_state.sprs[SPR_SR] &= ~SPR_SR_CY;
          
            temp4 = temp1;
            if (temp4 == temp1)
              or1k_mstats.byteadd++;
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 177;   /* "l.addc" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
      } else {
        /* Invalid insn */
        {
          l_invalid ();

          if (do_stats) {
            current->insn_index = -1;   /* "???" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
      }
      break;
    case 0x2:
      /* Not unique: real mask fc00030f and current mask fc00000f differ - do final check */
      if((insn & 0xfc00030f) == 0xe0000002) {
        /* Instruction: l.sub */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          {             /* "l_sub" */
            orreg_t temp1;
            temp1 = (orreg_t)PARAM1 - (orreg_t)PARAM2;
            SET_OV_FLAG_FN (temp1);
            SET_PARAM0(temp1);
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 178;   /* "l.sub" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
      } else {
        /* Invalid insn */
        {
          l_invalid ();

          if (do_stats) {
            current->insn_index = -1;   /* "???" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
      }
      break;
    case 0x3:
      /* Not unique: real mask fc00030f and current mask fc00000f differ - do final check */
      if((insn & 0xfc00030f) == 0xe0000003) {
        /* Instruction: l.and */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          {             /* "l_and" */
            uorreg_t temp1;
            temp1 = PARAM1 & PARAM2;
            SET_OV_FLAG_FN (temp1);
            SET_PARAM0(temp1);
            if (ARITH_SET_FLAG) {
              if(!temp1)
                cpu_state.sprs[SPR_SR] |= SPR_SR_F;
              else
                cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
            }
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 179;   /* "l.and" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
      } else {
        /* Invalid insn */
        {
          l_invalid ();

          if (do_stats) {
            current->insn_index = -1;   /* "???" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
      }
      break;
    case 0x4:
      /* Not unique: real mask fc00030f and current mask fc00000f differ - do final check */
      if((insn & 0xfc00030f) == 0xe0000004) {
        /* Instruction: l.or */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          {             /* "l_or" */
            uorreg_t temp1;
            temp1 = PARAM1 | PARAM2;
            SET_OV_FLAG_FN (temp1);
            SET_PARAM0(temp1);
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 180;   /* "l.or" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
      } else {
        /* Invalid insn */
        {
          l_invalid ();

          if (do_stats) {
            current->insn_index = -1;   /* "???" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
      }
      break;
    case 0x5:
      /* Not unique: real mask fc00030f and current mask fc00000f differ - do final check */
      if((insn & 0xfc00030f) == 0xe0000005) {
        /* Instruction: l.xor */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          {             /* "l_xor" */
            uorreg_t temp1;
            temp1 = PARAM1 ^ PARAM2;
            SET_OV_FLAG_FN (temp1);
            SET_PARAM0(temp1);
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 181;   /* "l.xor" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
      } else {
        /* Invalid insn */
        {
          l_invalid ();

          if (do_stats) {
            current->insn_index = -1;   /* "???" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
      }
      break;
    case 0x6:
      /* Not unique: real mask fc00030f and current mask fc00000f differ - do final check */
      if((insn & 0xfc00030f) == 0xe0000306) {
        /* Instruction: l.mul */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          {             /* "l_mul" */
            orreg_t temp1;
            
            temp1 = (orreg_t)PARAM1 * (orreg_t)PARAM2;
            SET_OV_FLAG_FN (temp1);
            SET_PARAM0(temp1);
            /*if (!(mcount++ & 1023)) {
              PRINTF ("[%i]\n",mcount);
              }*/
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 182;   /* "l.mul" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
      } else {
        /* Invalid insn */
        {
          l_invalid ();

          if (do_stats) {
            current->insn_index = -1;   /* "???" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
      }
      break;
    case 0x7:
      /* Invalid instruction(s) */
      break;
    case 0x8:
      switch((insn >> 6) & 0xf) {
      case 0x0:
        /* Instruction: l.sll */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          {             /* "l_sll" */
            uorreg_t temp1;
          
            temp1 = PARAM1 << PARAM2;
            SET_OV_FLAG_FN (temp1);
            SET_PARAM0(temp1);
            /* runtime.sim.cycles += 2; */
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 183;   /* "l.sll" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x1:
        /* Instruction: l.srl */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          {             /* "l_srl" */
            uorreg_t temp1;
            temp1 = PARAM1 >> PARAM2;
            SET_OV_FLAG_FN (temp1);
            SET_PARAM0(temp1);
            /* runtime.sim.cycles += 2; */
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 184;   /* "l.srl" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x2:
        /* Instruction: l.sra */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          {             /* "l_sra" */
            orreg_t temp1;
            
            temp1 = (orreg_t)PARAM1 >> PARAM2;
            SET_OV_FLAG_FN (temp1);
            SET_PARAM0(temp1);
            /* runtime.sim.cycles += 2; */
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 185;   /* "l.sra" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x3:
        /* Instruction: l.ror */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 186;   /* "l.ror" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x4:
      case 0x5:
      case 0x6:
      case 0x7:
      case 0x8:
      case 0x9:
      case 0xa:
      case 0xb:
      case 0xc:
      case 0xd:
      case 0xe:
      case 0xf:
        /* Invalid instruction(s) */
        break;
      }
      break;
    case 0x9:
      /* Not unique: real mask fc00030f and current mask fc00000f differ - do final check */
      if((insn & 0xfc00030f) == 0xe0000309) {
        /* Instruction: l.div */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          {             /* "l_div" */
            orreg_t temp3, temp2, temp1;
            
            temp3 = PARAM2;
            temp2 = PARAM1;
            if (temp3)
              temp1 = temp2 / temp3;
            else {
              except_handle(EXCEPT_ILLEGAL, cpu_state.pc);
              return;
            }
            SET_OV_FLAG_FN (temp1);
            SET_PARAM0(temp1);
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 187;   /* "l.div" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
      } else {
        /* Invalid insn */
        {
          l_invalid ();

          if (do_stats) {
            current->insn_index = -1;   /* "???" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
      }
      break;
    case 0xa:
      /* Not unique: real mask fc00030f and current mask fc00000f differ - do final check */
      if((insn & 0xfc00030f) == 0xe000030a) {
        /* Instruction: l.divu */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          {             /* "l_divu" */
            uorreg_t temp3, temp2, temp1;
            
            temp3 = PARAM2;
            temp2 = PARAM1;
            if (temp3)
              temp1 = temp2 / temp3;
            else {
              except_handle(EXCEPT_ILLEGAL, cpu_state.pc);
              return;
            }
            SET_OV_FLAG_FN (temp1);
            SET_PARAM0(temp1);
            /* runtime.sim.cycles += 16; */
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 188;   /* "l.divu" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
      } else {
        /* Invalid insn */
        {
          l_invalid ();

          if (do_stats) {
            current->insn_index = -1;   /* "???" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
      }
      break;
    case 0xb:
      /* Not unique: real mask fc00030f and current mask fc00000f differ - do final check */
      if((insn & 0xfc00030f) == 0xe000030b) {
        /* Instruction: l.mulu */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 189;   /* "l.mulu" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
      } else {
        /* Invalid insn */
        {
          l_invalid ();

          if (do_stats) {
            current->insn_index = -1;   /* "???" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
      }
      break;
    case 0xc:
      switch((insn >> 6) & 0xf) {
      case 0x0:
        /* Instruction: l.exths */
        {
          uorreg_t a, b;
          /* Number of operands: 2 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          {             /* "l_exths" */
            int16_t x;
            x = PARAM1;
            SET_PARAM0((orreg_t)x);
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1

          if (do_stats) {
            current->insn_index = 191;   /* "l.exths" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x1:
        /* Instruction: l.extbs */
        {
          uorreg_t a, b;
          /* Number of operands: 2 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          {             /* "l_extbs" */
            int8_t x;
            x = PARAM1;
            SET_PARAM0((orreg_t)x);
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1

          if (do_stats) {
            current->insn_index = 190;   /* "l.extbs" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x2:
        /* Instruction: l.exthz */
        {
          uorreg_t a, b;
          /* Number of operands: 2 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          {             /* "l_exthz" */
            uint16_t x;
            x = PARAM1;
            SET_PARAM0((uorreg_t)x);
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1

          if (do_stats) {
            current->insn_index = 194;   /* "l.exthz" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x3:
        /* Instruction: l.extbz */
        {
          uorreg_t a, b;
          /* Number of operands: 2 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          {             /* "l_extbz" */
            uint8_t x;
            x = PARAM1;
            SET_PARAM0((uorreg_t)x);
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1

          if (do_stats) {
            current->insn_index = 193;   /* "l.extbz" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x4:
      case 0x5:
      case 0x6:
      case 0x7:
      case 0x8:
      case 0x9:
      case 0xa:
      case 0xb:
      case 0xc:
      case 0xd:
      case 0xe:
      case 0xf:
        /* Invalid instruction(s) */
        break;
      }
      break;
    case 0xd:
      switch((insn >> 6) & 0xf) {
      case 0x0:
        /* Instruction: l.extws */
        {
          uorreg_t a, b;
          /* Number of operands: 2 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          {             /* "l_extws" */
            int32_t x;
            x = PARAM1;
            SET_PARAM0((orreg_t)x);
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1

          if (do_stats) {
            current->insn_index = 192;   /* "l.extws" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x1:
        /* Instruction: l.extwz */
        {
          uorreg_t a, b;
          /* Number of operands: 2 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          {             /* "l_extwz" */
            uint32_t x;
            x = PARAM1;
            SET_PARAM0((uorreg_t)x);
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1

          if (do_stats) {
            current->insn_index = 195;   /* "l.extwz" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x2:
      case 0x3:
      case 0x4:
      case 0x5:
      case 0x6:
      case 0x7:
      case 0x8:
      case 0x9:
      case 0xa:
      case 0xb:
      case 0xc:
      case 0xd:
      case 0xe:
      case 0xf:
        /* Invalid instruction(s) */
        break;
      }
      break;
    case 0xe:
      /* Not unique: real mask fc00030f and current mask fc00000f differ - do final check */
      if((insn & 0xfc00030f) == 0xe000000e) {
        /* Instruction: l.cmov */
        {
          uorreg_t a, b, c;
          /* Number of operands: 3 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          c = (insn >> 11) & 0x1f;
          #define PARAM2 cpu_state.reg[c]
          {             /* "l_cmov" */
            SET_PARAM0(cpu_state.sprs[SPR_SR] & SPR_SR_F ? PARAM1 : PARAM2);
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1
          #undef PARAM2

          if (do_stats) {
            current->insn_index = 196;   /* "l.cmov" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
      } else {
        /* Invalid insn */
        {
          l_invalid ();

          if (do_stats) {
            current->insn_index = -1;   /* "???" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
      }
      break;
    case 0xf:
      switch((insn >> 8) & 0x3) {
      case 0x0:
        /* Instruction: l.ff1 */
        {
          uorreg_t a, b;
          /* Number of operands: 2 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          {             /* "l_ff1" */
            SET_PARAM0(ffs(PARAM1));
          }
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1

          if (do_stats) {
            current->insn_index = 197;   /* "l.ff1" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x1:
        /* Instruction: l.fl1 */
        {
          uorreg_t a, b;
          /* Number of operands: 2 */
          a = (insn >> 21) & 0x1f;
          #define SET_PARAM0(val) cpu_state.reg[a] = val
          #define PARAM0 cpu_state.reg[a]
          b = (insn >> 16) & 0x1f;
          #define PARAM1 cpu_state.reg[b]
          l_invalid ();
          #undef SET_PARAM
          #undef PARAM0
          #undef PARAM1

          if (do_stats) {
            current->insn_index = 198;   /* "l.fl1" */
            analysis(current);
          }
          cpu_state.reg[0] = 0; /* Repair in case we changed it */
        }
        break;
      case 0x2:
      case 0x3:
        /* Invalid instruction(s) */
        break;
      }
      break;
    }
    break;
  case 0x39:
    switch((insn >> 21) & 0x1f) {
    case 0x0:
      /* Instruction: l.sfeq */
      {
        uorreg_t a, b;
        /* Number of operands: 2 */
        a = (insn >> 16) & 0x1f;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        b = (insn >> 11) & 0x1f;
        #define PARAM1 cpu_state.reg[b]
        {           /* "l_sfeq" */
          if(PARAM0 == PARAM1)
            cpu_state.sprs[SPR_SR] |= SPR_SR_F;
          else
            cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
        }
        #undef SET_PARAM
        #undef PARAM0
        #undef PARAM1

        if (do_stats) {
          current->insn_index = 199;   /* "l.sfeq" */
          analysis(current);
        }
      }
      break;
    case 0x1:
      /* Instruction: l.sfne */
      {
        uorreg_t a, b;
        /* Number of operands: 2 */
        a = (insn >> 16) & 0x1f;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        b = (insn >> 11) & 0x1f;
        #define PARAM1 cpu_state.reg[b]
        {           /* "l_sfne" */
          if(PARAM0 != PARAM1)
            cpu_state.sprs[SPR_SR] |= SPR_SR_F;
          else
            cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
        }
        #undef SET_PARAM
        #undef PARAM0
        #undef PARAM1

        if (do_stats) {
          current->insn_index = 200;   /* "l.sfne" */
          analysis(current);
        }
      }
      break;
    case 0x2:
      /* Instruction: l.sfgtu */
      {
        uorreg_t a, b;
        /* Number of operands: 2 */
        a = (insn >> 16) & 0x1f;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        b = (insn >> 11) & 0x1f;
        #define PARAM1 cpu_state.reg[b]
        {           /* "l_sfgtu" */
          if(PARAM0 > PARAM1)
            cpu_state.sprs[SPR_SR] |= SPR_SR_F;
          else
            cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
        }
        #undef SET_PARAM
        #undef PARAM0
        #undef PARAM1

        if (do_stats) {
          current->insn_index = 201;   /* "l.sfgtu" */
          analysis(current);
        }
      }
      break;
    case 0x3:
      /* Instruction: l.sfgeu */
      {
        uorreg_t a, b;
        /* Number of operands: 2 */
        a = (insn >> 16) & 0x1f;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        b = (insn >> 11) & 0x1f;
        #define PARAM1 cpu_state.reg[b]
        {           /* "l_sfgeu" */
          if(PARAM0 >= PARAM1)
            cpu_state.sprs[SPR_SR] |= SPR_SR_F;
          else
            cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
        }
        #undef SET_PARAM
        #undef PARAM0
        #undef PARAM1

        if (do_stats) {
          current->insn_index = 202;   /* "l.sfgeu" */
          analysis(current);
        }
      }
      break;
    case 0x4:
      /* Instruction: l.sfltu */
      {
        uorreg_t a, b;
        /* Number of operands: 2 */
        a = (insn >> 16) & 0x1f;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        b = (insn >> 11) & 0x1f;
        #define PARAM1 cpu_state.reg[b]
        {           /* "l_sfltu" */
          if(PARAM0 < PARAM1)
            cpu_state.sprs[SPR_SR] |= SPR_SR_F;
          else
            cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
        }
        #undef SET_PARAM
        #undef PARAM0
        #undef PARAM1

        if (do_stats) {
          current->insn_index = 203;   /* "l.sfltu" */
          analysis(current);
        }
      }
      break;
    case 0x5:
      /* Instruction: l.sfleu */
      {
        uorreg_t a, b;
        /* Number of operands: 2 */
        a = (insn >> 16) & 0x1f;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        b = (insn >> 11) & 0x1f;
        #define PARAM1 cpu_state.reg[b]
        {           /* "l_sfleu" */
          if(PARAM0 <= PARAM1)
            cpu_state.sprs[SPR_SR] |= SPR_SR_F;
          else
            cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
        }
        #undef SET_PARAM
        #undef PARAM0
        #undef PARAM1

        if (do_stats) {
          current->insn_index = 204;   /* "l.sfleu" */
          analysis(current);
        }
      }
      break;
    case 0x6:
    case 0x7:
    case 0x8:
    case 0x9:
      /* Invalid instruction(s) */
      break;
    case 0xa:
      /* Instruction: l.sfgts */
      {
        uorreg_t a, b;
        /* Number of operands: 2 */
        a = (insn >> 16) & 0x1f;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        b = (insn >> 11) & 0x1f;
        #define PARAM1 cpu_state.reg[b]
        {           /* "l_sfgts" */
          if((orreg_t)PARAM0 > (orreg_t)PARAM1)
            cpu_state.sprs[SPR_SR] |= SPR_SR_F;
          else
            cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
        }
        #undef SET_PARAM
        #undef PARAM0
        #undef PARAM1

        if (do_stats) {
          current->insn_index = 205;   /* "l.sfgts" */
          analysis(current);
        }
      }
      break;
    case 0xb:
      /* Instruction: l.sfges */
      {
        uorreg_t a, b;
        /* Number of operands: 2 */
        a = (insn >> 16) & 0x1f;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        b = (insn >> 11) & 0x1f;
        #define PARAM1 cpu_state.reg[b]
        {           /* "l_sfges" */
          if((orreg_t)PARAM0 >= (orreg_t)PARAM1)
            cpu_state.sprs[SPR_SR] |= SPR_SR_F;
          else
            cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
        }
        #undef SET_PARAM
        #undef PARAM0
        #undef PARAM1

        if (do_stats) {
          current->insn_index = 206;   /* "l.sfges" */
          analysis(current);
        }
      }
      break;
    case 0xc:
      /* Instruction: l.sflts */
      {
        uorreg_t a, b;
        /* Number of operands: 2 */
        a = (insn >> 16) & 0x1f;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        b = (insn >> 11) & 0x1f;
        #define PARAM1 cpu_state.reg[b]
        {           /* "l_sflts" */
          if((orreg_t)PARAM0 < (orreg_t)PARAM1)
            cpu_state.sprs[SPR_SR] |= SPR_SR_F;
          else
            cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
        }
        #undef SET_PARAM
        #undef PARAM0
        #undef PARAM1

        if (do_stats) {
          current->insn_index = 207;   /* "l.sflts" */
          analysis(current);
        }
      }
      break;
    case 0xd:
      /* Instruction: l.sfles */
      {
        uorreg_t a, b;
        /* Number of operands: 2 */
        a = (insn >> 16) & 0x1f;
        #define SET_PARAM0(val) cpu_state.reg[a] = val
        #define PARAM0 cpu_state.reg[a]
        b = (insn >> 11) & 0x1f;
        #define PARAM1 cpu_state.reg[b]
        {           /* "l_sfles" */
          if((orreg_t)PARAM0 <= (orreg_t)PARAM1)
            cpu_state.sprs[SPR_SR] |= SPR_SR_F;
          else
            cpu_state.sprs[SPR_SR] &= ~SPR_SR_F;
        }
        #undef SET_PARAM
        #undef PARAM0
        #undef PARAM1

        if (do_stats) {
          current->insn_index = 208;   /* "l.sfles" */
          analysis(current);
        }
      }
      break;
    case 0xe:
    case 0xf:
    case 0x10:
    case 0x11:
    case 0x12:
    case 0x13:
    case 0x14:
    case 0x15:
    case 0x16:
    case 0x17:
    case 0x18:
    case 0x19:
    case 0x1a:
    case 0x1b:
    case 0x1c:
    case 0x1d:
    case 0x1e:
    case 0x1f:
      /* Invalid instruction(s) */
      break;
    }
    break;
  case 0x3a:
  case 0x3b:
    /* Invalid instruction(s) */
    break;
  case 0x3c:
    /* Instruction: l.cust5 */
    {
      uorreg_t a, b, c, d, e;
      /* Number of operands: 5 */
      a = (insn >> 21) & 0x1f;
      #define SET_PARAM0(val) cpu_state.reg[a] = val
      #define PARAM0 cpu_state.reg[a]
      b = (insn >> 16) & 0x1f;
      #define PARAM1 cpu_state.reg[b]
      c = (insn >> 11) & 0x1f;
      #define PARAM2 cpu_state.reg[c]
      d = (insn >> 5) & 0x3f;
      #define PARAM3 d
      e = (insn >> 0) & 0x1f;
      #define PARAM4 e
      l_invalid ();
      #undef SET_PARAM
      #undef PARAM0
      #undef PARAM1
      #undef PARAM2
      #undef PARAM3
      #undef PARAM4

      if (do_stats) {
        current->insn_index = 209;   /* "l.cust5" */
        analysis(current);
      }
      cpu_state.reg[0] = 0; /* Repair in case we changed it */
    }
    break;
  case 0x3d:
    /* Instruction: l.cust6 */
    {
      uorreg_t a;
      /* Number of operands: 1 */
      a = (insn >> 0) & 0x0;
      #define SET_PARAM0(val) cpu_state.reg[a] = val
      #define PARAM0 cpu_state.reg[a]
      l_invalid ();
      #undef SET_PARAM
      #undef PARAM0

      if (do_stats) {
        current->insn_index = 210;   /* "l.cust6" */
        analysis(current);
      }
    }
    break;
  case 0x3e:
    /* Instruction: l.cust7 */
    {
      uorreg_t a;
      /* Number of operands: 1 */
      a = (insn >> 0) & 0x0;
      #define SET_PARAM0(val) cpu_state.reg[a] = val
      #define PARAM0 cpu_state.reg[a]
      l_invalid ();
      #undef SET_PARAM
      #undef PARAM0

      if (do_stats) {
        current->insn_index = 211;   /* "l.cust7" */
        analysis(current);
      }
    }
    break;
  case 0x3f:
    /* Instruction: l.cust8 */
    {
      uorreg_t a;
      /* Number of operands: 1 */
      a = (insn >> 0) & 0x0;
      #define SET_PARAM0(val) cpu_state.reg[a] = val
      #define PARAM0 cpu_state.reg[a]
      l_invalid ();
      #undef SET_PARAM
      #undef PARAM0

      if (do_stats) {
        current->insn_index = 212;   /* "l.cust8" */
        analysis(current);
      }
    }
    break;
  }
}
