
#include <stdio.h>
#include <stdint.h>
 
// Test application: canned Ethernet test data.
uint8_t test_data[] = 
{
    0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 
    0x00, 0x20, 0xaf, 0xb7, 0x80, 0xB8, 
    0x08, 0x06, 

    0x00, 0x01, 0x08, 0x00, 
    0x06, 0x04, 0x00, 0x01, 
    0x00, 0x20, 0xaf, 0xb7, 
    0x80,  0xB8, 0x80, 0xE8, 
    0x0f, 0x94, 0x00, 0x00, 
    0x00,  0x00, 0x00, 0x00, 
    0x80,  0xE8, 0x0f, 0xDe, 

    0xde, 0xde, 0xde, 0xde, 
    0xde, 0xde, 0xde, 0xde, 
    0xde, 0xde, 0xde, 0xde, 
    0xde, 0xde, 0xde, 0xde, 
    0xde, 0xde,

    0x9e, 0xd2,  0xc2, 0xaf 
};


const uint32_t ethernet_polynomial_le = 0xedb88320U;

//bit-oriented implementation.

unsigned ether_crc_le(int length0, uint8_t *data0, int foxes)
{
    unsigned int crc = (foxes) ? 0xffffffff: 0;	/* Initial value. */
    int repeat;
    for (repeat=0;repeat<1000;repeat++)
      {
	uint8_t *data = data0;
	int length = length0;
	
	while(--length >= 0) 
	  {
	    unsigned char current_octet = *data++;
	    int bit;
	    //printf("%02X, %08X,  inv %08X\n", current_octet, crc, ~crc);
	    for (bit = 8; --bit >= 0; current_octet >>= 1) {
	      if ((crc ^ current_octet) & 1) {
		crc >>= 1;
	    crc ^= ethernet_polynomial_le;
	      } else
		crc >>= 1;
	    }
	  }
      }
    printf("crc final %x\n", crc);
    /*  if (crc != 0xdebb20e3) printf("crc is wrong");*/
    return crc;
  }


int main()
{

  ether_crc_le(64, test_data, 1);
  return 0;
}

void _isr_routine()
{

}

// eof
