/* 
 * $Id: ethercrc_tlm.cpp,v 1.2 2011/03/22 09:46:33 djg11 Exp $
 * (C) 2009-10 DJ Greaves - Ethernet CRC coprocessor example.
 */

#define TRC(X) 


#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include "ethercrc_memmap.h"
#include "ethercrc_tlm.h"


//
//
//
void ethercrc_tlm::b_access(PW_TLM_PAYTYPE &trans, sc_time &delay)
{
  tlm::tlm_command cmd = trans.get_command();
  u64_t    adr = trans.get_address();
  uint8_t*	ptr = trans.get_data_ptr();
  uint32_t    len = trans.get_data_length();
  uint8_t*	lanes = trans.get_byte_enable_ptr();
  uint32_t    wid = trans.get_streaming_width();

  printf("%s %s " PFX64 "    crc=%08X\n", name(), kind(), adr, bevcore.read_crc());

  POWER3(PW_TLM3(trans.pw_log_hop(this,  (cmd==tlm::TLM_READ_COMMAND ? PW_TGP_DATA: PW_TGP_NOFIELDS) | PW_TGP_ACCT_CKP,  &read_bus_tracker)));

  delay += latency;
    
  // Obliged to check address range and check for unsupported features,
  //   i.e. byte enables, streaming, and bursts
  // Can ignore DMI hint and extensions
  // Using the SystemC report handler is an acceptable way of signalling an error
  

  if (cmd == tlm::TLM_READ_COMMAND)
    {
      u32_t r = 0;
      switch ((u32_t)(adr & 0xFFF))
	{
	case CRC_RESET_REG:
	  break;
	case CRC_DATA_8_PROCESS_REG:
	  break;

	case CRC_READ_REG:
	  r = bevcore.read_crc();
	  break;
	case CRC_CONTROL_REG:
	  r = bevcore.read_control();
	  break;
	}
      ((u64_t *)ptr)[0] = r;

      if (traceregions && traceregions->check(adr, TENOS_TRACE_IO_READ))
	    printf("%s: %s: Read  addr=" PFX64 " data=%08X\n", name(), kind(), adr, r);

    }
  else if (cmd == tlm::TLM_WRITE_COMMAND)
    {
      u64_t d64 = ((u64_t *)ptr)[0];
      switch ((u32_t)(adr & 0xFFF))
	{
	case CRC_RESET_REG:
	  bevcore.reset_operation();
	  break;

	case CRC_DATA_8_PROCESS_REG:
	  bevcore.process_byte(d64 & 0xFF);
	  break;

	case CRC_DATA_32_PROCESS_LE_REG:
	  bevcore.process_word32_le(d64 & 0xFFFFffff);
	  break;
	case CRC_DATA_32_PROCESS_BE_REG:
	  bevcore.process_word32_be(d64 & 0xFFFFffff);
	  break;
	case CRC_READ_REG:
	  break;
	case CRC_CONTROL_REG:
	  bevcore.write_control(d64 & 0xFFFFffff);
	  break;
	}
      if (traceregions && traceregions->check(adr, TENOS_TRACE_IO_WRITE))
	    printf("%s: %s: Write addr=" PFX64 " data=" PFX64 "\n", name(), kind(), adr, d64);
    }
  trans.set_response_status(tlm::TLM_OK_RESPONSE);
}



// Constructor
ethercrc_tlm::ethercrc_tlm(sc_module_name name): 
  sc_module(name), 
#ifdef TLM_POWER3
    read_bus_tracker(this),
#endif
  latency(5, SC_NS)
{
  
  // Register callback for incoming b_transport interface method call
  port0.register_b_transport(this, &ethercrc_tlm::b_access);
}


// eof


