// TLM_POWER3: Energy-based for loosely-timed TLM.
// (C) 2011 DJ Greaves & MM Yasin, University of Cambridge Computer Laboratory.
// $Id: $
/*****************************************************************************
 *                       Copyright (c) 2010, CEA-LETI
 * 
 * TLM POWER2 is free software; you can redistribute it and/or modify it under 
 * the terms of the GNU Lesser General Public License as published by the Free 
 * Software Foundation; either version 2 of the License, or (at your option) 
 * any later version.
 *
 * TLM POWER2 has been developped in the framework of the MINALOGIC OpenTLM 
 * project.  For more information see http://www.opentlm.org
 *
 * For further information, questions or feedback on the delivery, please 
 * contact <pascal.vivet@cea.fr>
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public 
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License 
 * along with this library; if not, write to the Free Software Foundation, 
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 ****************************************************************************/

// $Id: pw_kernel_ids.cpp,v 1.2 2011/07/25 15:32:45 my294 Exp $

/** @file pw_kernel_ids.cpp
 * @brief Define error messages for the pwr library
 * @author Cedric Koch-Hofer <cedric.koch-hofer@cea.fr>
 *
 * Reports ids in the range 0-99
 *
 */



// ===========================================================================
namespace sc_pwr
{


// ---------------------------------------------------------------------------
// POWER ERROR CODES

const char* PW_POWER_UNIT_OVERFLOW_TYPE_ =
    "/cea/pwr/kernel/0";
const char* PW_POWER_UNIT_OVERFLOW_MSG_ =
    "Overflow with pw_power_unit data.";

const char* PW_POWER_OVERFLOW_TYPE_ =
    "/cea/pwr/kernel/1";
const char* PW_POWER_OVERFLOW_MSG_ =
    "Overflow with pw_power data.";

const char* PW_POWER_UNDERFLOW_TYPE_ =
    "/cea/pwr/kernel/34";
const char* PW_POWER_UNDERFLOW_MSG_ =
    "Underflow with pw_power data.";

const char* PW_POWER_DIVISION_BY_ZERO_TYPE_ =
    "/cea/pwr/kernel/2";
const char* PW_POWER_DIVISION_BY_ZERO_MSG_ =
    "Division by zero not allowed with pw_power.";

const char* PW_POWER_RESOLUTION_ELABORATION_TYPE_ =
    "/cea/pwr/kernel/3";
const char* PW_POWER_RESOLUTION_ELABORATION_MSG_ =
    "Power resolution can only be set during elaboration phase.";

const char* PW_POWER_RESOLUTION_FIXED_TYPE_ =
    "/cea/pwr/kernel/4";
const char* PW_POWER_RESOLUTION_FIXED_MSG_ =
    "Power resolution already fixed.";

const char* PW_POWER_RESOLUTION_POW10_TYPE_ =
    "/cea/pwr/kernel/5";
const char* PW_POWER_RESOLUTION_POW10_MSG_ =
    "Power resolution value must be a power of 10.";

const char* PW_POWER_NEGATIVE_TYPE_ =
    "/cea/pwr/kernel/6";
const char* PW_POWER_NEGATIVE_MSG_ =
    "Power value must be positive.";

const char* PW_POWER_RESOLUTION_ZERO_TYPE_ =
    "/cea/pwr/kernel/7";
const char* PW_POWER_RESOLUTION_ZERO_MSG_ =
    "Power resolution value must be greater than zero.";

const char* PW_POWER_RESOLUTION_NEGATIVE_TYPE_ =
    "/cea/pwr/kernel/8";
const char* PW_POWER_RESOLUTION_NEGATIVE_MSG_ =
    "Power resolution value must be a positive.";

const char* PW_POWER_RESOLUTION_OVERFLOW_TYPE_ =
    "/cea/pwr/kernel/9";
const char* PW_POWER_RESOLUTION_OVERFLOW_MSG_ =
    "Overflow with power resolution value.";

const char* PW_POWER_UNIT_OSTREAM_ERROR_TYPE_ =
    "/cea/pwr/kernel/21";
const char* PW_POWER_UNIT_OSTREAM_ERROR_MSG_ =
    "Failed to initialize input stream.";

const char* PW_POWER_OSTREAM_ERROR_TYPE_ =
    "/cea/pwr/kernel/22";
const char* PW_POWER_OSTREAM_ERROR_MSG_ =
    "Failed to initialize output stream.";

const char* PW_POWER_ISTREAM_ERROR_TYPE_ =
    "/cea/pwr/kernel/28";
const char* PW_POWER_ISTREAM_ERROR_MSG_ =
    "Failed to extract power value from input stream.";

const char* PW_POWER_UNIT_ISTREAM_ERROR_TYPE_ =
    "/cea/pwr/kernel/29";
const char* PW_POWER_UNIT_ISTREAM_ERROR_MSG_ =
    "Failed to extract power unit from input stream.";
// ---------------------------------------------------------------------------
// LENGTH ERROR CODES

const char* PW_LENGTH_UNIT_OVERFLOW_TYPE_ = "/cea/pwr/kernel/55";
const char* PW_LENGTH_UNIT_OVERFLOW_MSG_ = "Overflow with pw_length_unit data.";

const char* PW_LENGTH_OVERFLOW_TYPE_ =  "/cea/pwr/kernel/56";
const char* PW_LENGTH_OVERFLOW_MSG_ = " Overflow with pw_length data.";

const char* PW_LENGTH_UNDERFLOW_TYPE_ = "/cea/pwr/kernel/57";
const char* PW_LENGTH_UNDERFLOW_MSG_ = "Underflow with pw_length data.";

const char* PW_LENGTH_DIVISION_BY_ZERO_TYPE_ = "/cea/pwr/kernel/58";
const char* PW_LENGTH_DIVISION_BY_ZERO_MSG_ = "Division by zero not allowed with pw_length.";

const char* PW_LENGTH_RESOLUTION_ELABORATION_TYPE_ = "/cea/pwr/kernel/59";
const char* PW_LENGTH_RESOLUTION_ELABORATION_MSG_ = "length resolution can only be set during elaboration phase.";

const char* PW_LENGTH_RESOLUTION_FIXED_TYPE_ = "/cea/pwr/kernel/60";
const char* PW_LENGTH_RESOLUTION_FIXED_MSG_ = "length resolution already fixed.";

const char* PW_LENGTH_RESOLUTION_POW10_TYPE_ = "/cea/pwr/kernel/61";
const char* PW_LENGTH_RESOLUTION_POW10_MSG_ = "Length resolution value must be a power of 10.";

const char* PW_LENGTH_NEGATIVE_TYPE_ = "/cea/pwr/kernel/62";
const char* PW_LENGTH_NEGATIVE_MSG_ = "length value must be positive.";

const char* PW_LENGTH_RESOLUTION_ZERO_TYPE_ = "/cea/pwr/kernel/63";
const char* PW_LENGTH_RESOLUTION_ZERO_MSG_ = "length resolution value must be greater than zero.";

const char* PW_LENGTH_RESOLUTION_NEGATIVE_TYPE_ = "/cea/pwr/kernel/64";
const char* PW_LENGTH_RESOLUTION_NEGATIVE_MSG_ = "length resolution value must be a positive.";

const char* PW_LENGTH_RESOLUTION_OVERFLOW_TYPE_ = "/cea/pwr/kernel/65";
const char* PW_LENGTH_RESOLUTION_OVERFLOW_MSG_ = "Overflow with length resolution value.";

const char* PW_LENGTH_UNIT_OSTREAM_ERROR_TYPE_ = "/cea/pwr/kernel/66";
const char* PW_LENGTH_UNIT_OSTREAM_ERROR_MSG_ = "Failed to initialize input stream.";

const char* PW_LENGTH_OSTREAM_ERROR_TYPE_ = "/cea/pwr/kernel/67";
const char* PW_LENGTH_OSTREAM_ERROR_MSG_ = "Failed to initialize output stream.";

const char* PW_LENGTH_ISTREAM_ERROR_TYPE_ = "/cea/pwr/kernel/68";
const char* PW_LENGTH_ISTREAM_ERROR_MSG_ = "Failed to extract length value from input stream.";

const char* PW_LENGTH_UNIT_ISTREAM_ERROR_TYPE_ = "/cea/pwr/kernel/69";
const char* PW_LENGTH_UNIT_ISTREAM_ERROR_MSG_ = "Failed to extract length unit from input stream.";


// ---------------------------------------------------------------------------
// AREA ERROR CODES

const char* PW_AREA_UNIT_OVERFLOW_TYPE_ = "/cea/pwr/kernel/78";
const char* PW_AREA_UNIT_OVERFLOW_MSG_ = "Overflow with pw_area_unit data.";

const char* PW_AREA_OVERFLOW_TYPE_ =  "/cea/pwr/kernel/79";
const char* PW_AREA_OVERFLOW_MSG_ = " Overflow with pw_area data.";

const char* PW_AREA_UNDERFLOW_TYPE_ = "/cea/pwr/kernel/80";
const char* PW_AREA_UNDERFLOW_MSG_ = "Underflow with pw_area data.";

const char* PW_AREA_DIVISION_BY_ZERO_TYPE_ = "/cea/pwr/kernel/81";
const char* PW_AREA_DIVISION_BY_ZERO_MSG_ = "Division by zero not allowed with pw_area.";

const char* PW_AREA_RESOLUTION_ELABORATION_TYPE_ = "/cea/pwr/kernel/82";
const char* PW_AREA_RESOLUTION_ELABORATION_MSG_ = "area resolution can only be set during elaboration phase.";

const char* PW_AREA_RESOLUTION_FIXED_TYPE_ = "/cea/pwr/kernel/83";
const char* PW_AREA_RESOLUTION_FIXED_MSG_ = "area resolution already fixed.";

const char* PW_AREA_RESOLUTION_POW10_TYPE_ = "/cea/pwr/kernel/84";
const char* PW_AREA_RESOLUTION_POW10_MSG_ = "Area resolution value must be a power of 10.";

const char* PW_AREA_NEGATIVE_TYPE_ = "/cea/pwr/kernel/85";
const char* PW_AREA_NEGATIVE_MSG_ = "area value must be positive.";

const char* PW_AREA_RESOLUTION_ZERO_TYPE_ = "/cea/pwr/kernel/86";
const char* PW_AREA_RESOLUTION_ZERO_MSG_ = "area resolution value must be greater than zero.";

const char* PW_AREA_RESOLUTION_NEGATIVE_TYPE_ = "/cea/pwr/kernel/87";
const char* PW_AREA_RESOLUTION_NEGATIVE_MSG_ = "area resolution value must be a positive.";

const char* PW_AREA_RESOLUTION_OVERFLOW_TYPE_ = "/cea/pwr/kernel/88";
const char* PW_AREA_RESOLUTION_OVERFLOW_MSG_ = "Overflow with area resolution value.";

const char* PW_AREA_UNIT_OSTREAM_ERROR_TYPE_ = "/cea/pwr/kernel/89";
const char* PW_AREA_UNIT_OSTREAM_ERROR_MSG_ = "Failed to initialize input stream.";

const char* PW_AREA_OSTREAM_ERROR_TYPE_ = "/cea/pwr/kernel/90";
const char* PW_AREA_OSTREAM_ERROR_MSG_ = "Failed to initialize output stream.";

const char* PW_AREA_ISTREAM_ERROR_TYPE_ = "/cea/pwr/kernel/91";
const char* PW_AREA_ISTREAM_ERROR_MSG_ = "Failed to extract area value from input stream.";

const char* PW_AREA_UNIT_ISTREAM_ERROR_TYPE_ = "/cea/pwr/kernel/92";
const char* PW_AREA_UNIT_ISTREAM_ERROR_MSG_ = "Failed to extract area unit from input stream.";




// ---------------------------------------------------------------------------
// Voltage ERROR CODES

//! /cea/pwr/kernel/40
const char* PW_VOLTAGE_UNIT_OVERFLOW_TYPE_ = "/cea/pwr/kernel/40";

const char* PW_VOLTAGE_UNIT_OVERFLOW_MSG_ = "//! Overflow with pw_voltage_unit data.";

//! /cea/pwr/kernel/41
const char* PW_VOLTAGE_OVERFLOW_TYPE_ = "/cea/pwr/kernel/40";

const char* PW_VOLTAGE_OVERFLOW_MSG_ = "//! Overflow with pw_voltage data.";

//! /cea/pwr/kernel/50
const char* PW_VOLTAGE_UNDERFLOW_TYPE_ = "/cea/pwr/kernel/40";

const char* PW_VOLTAGE_UNDERFLOW_MSG_ = "//! Underflow with pw_voltage data.";

//! /cea/pwr/kernel/42
const char* PW_VOLTAGE_DIVISION_BY_ZERO_TYPE_ = "/cea/pwr/kernel/40";

const char* PW_VOLTAGE_DIVISION_BY_ZERO_MSG_ = "//! Division by zero not allowed with pw_voltage.";

//! /cea/pwr/kernel/43
const char* PW_VOLTAGE_RESOLUTION_ELABORATION_TYPE_ = "/cea/pwr/kernel/40";

const char* PW_VOLTAGE_RESOLUTION_ELABORATION_MSG_ = "//! voltage resolution can only be set during elaboration phase.";

//! /cea/pwr/kernel/44
const char* PW_VOLTAGE_RESOLUTION_FIXED_TYPE_ = "/cea/pwr/kernel/44";

const char* PW_VOLTAGE_RESOLUTION_FIXED_MSG_ = "//! voltage resolution already fixed.";

//! /cea/pwr/kernel/45
const char* PW_VOLTAGE_RESOLUTION_POW10_TYPE_ = "/cea/pwr/kernel/45";

const char* PW_VOLTAGE_RESOLUTION_POW10_MSG_ = "//! Power resolution value must be a power of 10.";

//! /cea/pwr/kernel/46
const char* PW_VOLTAGE_NEGATIVE_TYPE_ = "/cea/pwr/kernel/46";

const char* PW_VOLTAGE_NEGATIVE_MSG_ = "//! voltage value must be positive.";

//! /cea/pwr/kernel/47
const char* PW_VOLTAGE_RESOLUTION_ZERO_TYPE_ = "/cea/pwr/kernel/47";

const char* PW_VOLTAGE_RESOLUTION_ZERO_MSG_ = "//! voltage resolution value must be greater than zero.";

//! /cea/pwr/kernel/48
const char* PW_VOLTAGE_RESOLUTION_NEGATIVE_TYPE_ = "/cea/pwr/kernel/48";

const char* PW_VOLTAGE_RESOLUTION_NEGATIVE_MSG_ = "//! voltage resolution value must be a positive.";

//! /cea/pwr/kernel/49
const char* PW_VOLTAGE_RESOLUTION_OVERFLOW_TYPE_ = "/cea/pwr/kernel/49";

const char* PW_VOLTAGE_RESOLUTION_OVERFLOW_MSG_ = "//! Overflow with voltage resolution value.";

//! /cea/pwr/kernel/51
const char* PW_VOLTAGE_UNIT_OSTREAM_ERROR_TYPE_ = "/cea/pwr/kernel/51";

const char* PW_VOLTAGE_UNIT_OSTREAM_ERROR_MSG_ = "//! Failed to initialize input stream.";

//! /cea/pwr/kernel/52
const char* PW_VOLTAGE_OSTREAM_ERROR_TYPE_ = "/cea/pwr/kernel/52";

const char* PW_VOLTAGE_OSTREAM_ERROR_MSG_ = "//! Failed to initialize output stream.";

//! /cea/pwr/kernel/53
const char* PW_VOLTAGE_ISTREAM_ERROR_TYPE_ = "/cea/pwr/kernel/53";

const char* PW_VOLTAGE_ISTREAM_ERROR_MSG_ = "//! Failed to extract voltage value from input stream.";

//! /cea/pwr/kernel/54
const char* PW_VOLTAGE_UNIT_ISTREAM_ERROR_TYPE_ = "/cea/pwr/kernel/54";

const char* PW_VOLTAGE_UNIT_ISTREAM_ERROR_MSG_ = "//! Failed to extract voltage unit from input stream.";



// ---------------------------------------------------------------------------
// ENERGY ERROR CODES

const char* PW_ENERGY_UNIT_OVERFLOW_TYPE_ =
    "/cea/pwr/kernel/10";
const char* PW_ENERGY_UNIT_OVERFLOW_MSG_ =
    "Overflow with pw_energy_unit data.";

const char* PW_ENERGY_UNIT_UNDERFLOW_TYPE_ =
    "/cea/pwr/kernel/93";
const char* PW_ENERGY_UNIT_UNDERFLOW_MSG_ =
    "Underflow with pw_energy_unit data.";

const char* PW_ENERGY_OVERFLOW_TYPE_ =
    "/cea/pwr/kernel/11";
const char* PW_ENERGY_OVERFLOW_MSG_ =
    "Overflow with pw_energy data.";

const char* PW_ENERGY_UNDERFLOW_TYPE_ =
    "/cea/pwr/kernel/35";
const char* PW_ENERGY_UNDERFLOW_MSG_ =
    "Underflow with pw_energy data.";

const char* PW_ENERGY_DIVISION_BY_ZERO_TYPE_ =
    "/cea/pwr/kernel/12";
const char* PW_ENERGY_DIVISION_BY_ZERO_MSG_ =
    "Division by zero not allowed with pw_energy.";

const char* PW_ENERGY_RESOLUTION_ELABORATION_TYPE_ =
    "/cea/pwr/kernel/13";
const char* PW_ENERGY_RESOLUTION_ELABORATION_MSG_ =
    "Energy resolution can only be set during elaboration phase.";

const char* PW_ENERGY_RESOLUTION_FIXED_TYPE_ =
    "/cea/pwr/kernel/14";
const char* PW_ENERGY_RESOLUTION_FIXED_MSG_ =
    "Energy resolution already fixed.";

const char* PW_ENERGY_RESOLUTION_POW10_TYPE_ =
    "/cea/pwr/kernel/15";
const char* PW_ENERGY_RESOLUTION_POW10_MSG_ =
    "Energy resolution value must be a energy of 10.";

const char* PW_ENERGY_NEGATIVE_TYPE_ =
    "/cea/pwr/kernel/16";
const char* PW_ENERGY_NEGATIVE_MSG_ =
    "Energy value must be positive.";

const char* PW_ENERGY_RESOLUTION_ZERO_TYPE_ =
    "/cea/pwr/kernel/17";
const char* PW_ENERGY_RESOLUTION_ZERO_MSG_ =
    "Energy resolution value must be greater than zero.";

const char* PW_ENERGY_RESOLUTION_NEGATIVE_TYPE_ =
    "/cea/pwr/kernel/18";
const char* PW_ENERGY_RESOLUTION_NEGATIVE_MSG_ =
    "Energy resolution value must be a positive.";

const char* PW_ENERGY_RESOLUTION_OVERFLOW_TYPE_ =
    "/cea/pwr/kernel/19";
const char* PW_ENERGY_RESOLUTION_OVERFLOW_MSG_ =
    "Overflow with energy resolution value.";

const char* PW_ENERGY_UNIT_OSTREAM_ERROR_TYPE_ =
    "/cea/pwr/kernel/23";
const char* PW_ENERGY_UNIT_OSTREAM_ERROR_MSG_ =
    "Failed to initialize output stream.";

const char* PW_ENERGY_OSTREAM_ERROR_TYPE_ =
    "/cea/pwr/kernel/24";
const char* PW_ENERGY_OSTREAM_ERROR_MSG_ =
    "Failed to initialize output stream.";

const char* PW_ENERGY_ISTREAM_ERROR_TYPE_ =
    "/cea/pwr/kernel/30";
const char* PW_ENERGY_ISTREAM_ERROR_MSG_ =
    "Failed to extract energy value from input stream.";

const char* PW_ENERGY_UNIT_ISTREAM_ERROR_TYPE_ =
    "/cea/pwr/kernel/31";
const char* PW_ENERGY_UNIT_ISTREAM_ERROR_MSG_ =
    "Failed to extract energy unit from input stream.";


// ---------------------------------------------------------------------------
// PHYSICAL OPERATORS ERROR CODES

const char* PW_PHYS_DIVISION_BY_ZERO_TYPE_ =
    "/cea/pwr/kernel/20";
const char* PW_PHYS_DIVISION_BY_ZERO_MSG_ =
    "Division by zero not allowed.";


// ---------------------------------------------------------------------------
// POWER MODULES ERROR CODES

const char* PW_MODULE_ATTRIBUTE_ID_OVERFLOW_TYPE_ =
    "/cea/pwr/kernel/26";
const char* PW_MODULE_ATTRIBUTE_ID_OVERFLOW_MSG_ =
    "Overflow with pw_module_base::attribute_id data.";

const char* PW_MODULE_DYNAMIC_CAST_FAILURE_TYPE_ =
    "/cea/pwr/kernel/27";
const char* PW_MODULE_DYNAMIC_CAST_FAILURE_MSG_ =
    "Power module must be an sc_object.";

const char* PW_UNDEF_MODE_PHASE_TYPE_ =
    "/cea/pwr/kernel/32";
const char* PW_UNDEF_MODE_PHASE_MSG_ =
    "Unknown power mode: failed to switch from ";


// ---------------------------------------------------------------------------
// BASE OBSERVER ERROR CODES

const char* PW_UNRECORDED_OBSERVER_TYPE_ =
    "/cea/pwr/kernel/33";
const char* PW_UNRECORDED_OBSERVER_MSG_ =
    "Try to destroy unrecorded statisitic observer ";


// ---------------------------------------------------------------------------
// MISCELLEANOUS ERROR CODES

const char* PW_KERNEL_OSTREAM_ERROR_TYPE_ =
    "/cea/pwr/kernel/25";
const char* PW_KERNEL_OSTREAM_ERROR_MSG_ =
    "Failed to initialize output stream.";


} // namespace sc_pwr
