open AST_vsm_assembler; 
open AST_vsm_bytecode; 

fun mk_vsm_code_loc_map prog = 
    let fun aux string_to_code_loc m [] = 
               (m, string_to_code_loc)
          | aux string_to_code_loc m ((VSM_Code _)::rest) = 
               aux string_to_code_loc (m+1) rest
          | aux string_to_code_loc m ((VSM_Labelled(l, _))::rest) = 
               aux (Library.update(string_to_code_loc, l, Word8.fromInt m)) (m+1) rest
    in aux Library.empty_env 0 prog end 


val next = Library.new_counter(); 

fun new_word () = Word8.fromInt (next ()); 

val find = Library.lookup; 

(* 
fun visit_vsm_data_loc dlm dl = 
    (let val _ = find(dlm, dl) in dlm end) 
     handle (Library.Missing _) => Library.update(dlm, dl, new_word()) 

fun update_vsm_data_loc_map dlm (VSM_Load (dl,_))  = visit_vsm_data_loc dlm dl 
  | update_vsm_data_loc_map dlm (VSM_Store (dl,_)) = visit_vsm_data_loc dlm dl 
  | update_vsm_data_loc_map dlm  _                 = dlm

fun mk_vsm_data_loc_map prog = 
    let fun aux dlm [] = dlm 
          | aux dlm ((VSM_Code c)::rest) = aux (update_vsm_data_loc_map dlm c) rest
          | aux dlm ((VSM_Labelled(_, c))::rest) = aux (update_vsm_data_loc_map dlm c) rest
    in aux Library.empty_env prog end 
*) 

fun vsm_assemble_op clm (VSM_Hlt _)         = VSM_B_Hlt 
  | vsm_assemble_op clm (VSM_Nop _)         = VSM_B_Nop
  | vsm_assemble_op clm (VSM_Add _)         = VSM_B_Add
  | vsm_assemble_op clm (VSM_Sub _)         = VSM_B_Sub
  | vsm_assemble_op clm (VSM_Mul _)         = VSM_B_Mul
  | vsm_assemble_op clm (VSM_Pop _)         = VSM_B_Pop
  | vsm_assemble_op clm (VSM_Pri _)         = VSM_B_Pri
  | vsm_assemble_op clm (VSM_Prb _)         = VSM_B_Prb
  | vsm_assemble_op clm (VSM_Jmp (cl, _))   = VSM_B_Jmp(find(clm, cl))
  | vsm_assemble_op clm (VSM_Ifz (cl, _))   = VSM_B_Ifz(find(clm, cl))
  | vsm_assemble_op clm (VSM_Ifp (cl, _))   = VSM_B_Ifp(find(clm, cl))
  | vsm_assemble_op clm (VSM_Ifn (cl, _))   = VSM_B_Ifn(find(clm, cl))
  | vsm_assemble_op clm (VSM_Push (c, _))   = VSM_B_Push(Word8.fromInt c)
  | vsm_assemble_op clm (VSM_Load (offset, _))  = VSM_B_Load(Word8.fromInt offset)
  | vsm_assemble_op clm (VSM_Store (offset, _)) = VSM_B_Store(Word8.fromInt offset)

fun vsm_assemble_list clm m [] = [] 
  | vsm_assemble_list clm m ((VSM_Code opr)::rest) = (Word8.fromInt m, vsm_assemble_op clm opr) :: (vsm_assemble_list clm (m+1) rest)
  | vsm_assemble_list clm m ((VSM_Labelled(_, opr))::rest) = (Word8.fromInt m, vsm_assemble_op clm opr) :: (vsm_assemble_list clm (m+1) rest)

fun vsm_assemble prog = 
    let val (inst_count, clm) = mk_vsm_code_loc_map prog 
        val code = vsm_assemble_list clm 0 prog 
    in (inst_count, code) end 
