package uk.ac.cam.rkh23.DesignPatterns.Decorator;

public class WrappedProduct extends Product {
	private static float sWrapPrice = 1.50f; // wrapping price
	private String mMessage; // gift tag message
	
	// This is-a Product AND has-a Product
	private Product mContents;
	
	public WrappedProduct(Product p,String message) {
		super(p.getPrice());
		mContents=p;
		mMessage=message;
	}
	
	// Override the default getPrice to return the 
	// price plus the wrapping cost (say £1.50).
	public float getPrice() {
		return mContents.getPrice()+sWrapPrice;
	}
}
