#include <stdio.h>
#include <system.h>
#include <io.h>
#include <string.h>
#include <sys/alt_irq.h>
#include <limits.h>
#include "alt_video_display/alt_video_display.h"
#include "alt_video_display/simple_graphics.h"
#include "alt_touchscreen/alt_touchscreen.h"

#define square(x) ((x) * (x))
#define WIDTH 800
#define HEIGHT 600
#define MAX_ITER 100

alt_video_display* display;
alt_touchscreen touchscreen;
unsigned int framebuffer[WIDTH * HEIGHT];

void draw_mandlebrot() {
	int i, j;
	for (j = 0; j < HEIGHT; j++) {
		for (i = 0; i < WIDTH; i++) {
			int x_0 = ((-2) << 28) + (((3 << 20) * i / WIDTH) << 8);
			int y_0 = ((-1) << 28) + (((2 << 20) * j / HEIGHT) << 8);
			int x = 0;
			int y = 0;
			int xtemp;
			int iter;

			for (iter = 0; (((square((long long)x) >> 28) + (square((long long)y) >> 28)) <= (square(2LL << 28)) >> 28) && (iter
					< MAX_ITER); iter++) {
				xtemp = (square((long long)x) >> 28LL) - (square((long long)y) >> 28LL) + x_0;
				y = (((long long)x * (long long)y) >> 27LL) + y_0; // 2 * x * y
				x = xtemp;
			}

			vid_set_pixel(i, j, iter >= MAX_ITER ? BLACK_24 : WHITE_24, display);
		}
	}
}

void init_drivers() {
	int err;

	printf("Initialising LCD display controller\n");
	display = alt_video_display_init(VIDEO_0_VIDEO_DMA_NAME, // Name of the Video-DMA controller
			WIDTH, // Width of display
			HEIGHT, // Height of display
			32, // Colour depth
			(int) framebuffer, // Where we want Frame buffer location
			VIDEO_0_DMA_DESCRIPTOR_MEM_BASE, // Where we want Descriptor location
			1);
	if (display)
		printf(" - LCD Initialisation OK\n");
	else
		printf(" - LCD FAILED %d\n", (int) display);

	printf("Initialising touchscreen controller\n");
	err = alt_touchscreen_init(&touchscreen, TOUCHPAD_0_SPI_BASE,
			TOUCHPAD_0_SPI_IRQ, TOUCHPAD_0_PEN_IRQ_N_BASE, 100, // 100 samples/sec
			ALT_TOUCHSCREEN_SWAP_XY);
	if (err == 0)
		printf(" - Touchscreen Initialisation OK\n");
	else
		printf(" - Touchscreen FAILED %d\n", err);

	// Calibrate the touch panel
	alt_touchscreen_calibrate_upper_right(&touchscreen, 3946, 3849, // ADC readings
			799, 0); // pixel coords
	alt_touchscreen_calibrate_lower_left(&touchscreen, 132, 148, // ADC readings
			0, 599); // pixel coords
}

int main() {
	init_drivers();
	unsigned int before = alt_nticks();
	draw_mandlebrot();
	unsigned int after = alt_nticks();
	printf("Finished in %i ms\n", ((after - before) * 1000) / alt_ticks_per_second());
	return 0;
}
