// $Id: $

// RTL-style bus multiplexor for read data: combinational block: multiplex two bus target results back towards an initiator.
// Typically use in a balanced tree...

#ifndef BUSMUX_H
#define BUSMUX_H

SC_MODULE(busmux)
{
  uint32 threshold;
  sc_in <uint32> in0, in1;
  sc_out <uint32> y;
  sc_in <uint32> addr;
  sc_in <bool> opack0, opack1;
  sc_out <bool> opack;
  void runme()
  {
    //    printf("opack %i %i \n", opack1.read(), opack0.read());
    y = (addr.read() >= threshold) ? in1.read(): in0.read();
    opack = (opack.read() >= threshold) ? opack1.read(): opack0.read();
  } 

  SC_CTOR(busmux)
  {
    // Combinational logic: react to all inputs.
    SC_METHOD(runme); sensitive << in0 << in1 << addr;

  }
};


#endif

// eof
