// $Id: $
// Two-away bus_monitor: demultiplex part of the address space to give two separate request signals.
// Typically use in a balanced tree.

#ifndef BUS_MONITOR_H
#define BUS_MONITOR_H

SC_MODULE(bus_monitor)
{

  // All connections are inputs on a bus monitor.
  sc_in <bool> hwen, hren, opack;
  sc_in <uint32> addr, wdata, rdata;

  enum busState_t { idle, read, readack, write, writeack, idlewait } state;

  int reads, writes;

  void viol(const char *errMsg)
  {
    printf("%s: bus protocol violation: %s\n", name(), errMsg);
  }


  void print_stats()
  {
    printf("%s: reads=%i, writes=%i\n", name(), reads, writes);
  }

  void runme()
  {
    switch (state)
      {
      case idle:
	if (opack.read()) viol("ack before req");
	if (hren.read() && hwen.read()) viol("both read and write at once");
	if (hren.read()) state = read;
	if (hwen.read()) state = write;
	break;

      case read:
	reads += 1;
	if (hwen.read()) viol("write before read ended");
	if (!hren.read()) viol("runt read");
	if (opack.read()) state = readack;
	break;

      case write:
	writes += 1;
	if (hren.read()) viol("read before write ended");
	if (!hwen.read()) viol("runt write");
	if (opack.read()) state = writeack;
	break;

      case readack:
	if (!opack.read()) viol ("opack deasserted before hren");
	if (!hren.read()) state = idlewait;
	break;

      case writeack:
	if (!opack.read()) viol ("opack deasserted before hwen");
	if (!hwen.read()) state = idlewait;
	break;

      case idlewait:
	if (!opack.read()) state = idle;
	break;



      }

    //printf("%s  Thresh=0x%X  gr=%i rw=%i A=0x%X\n", name(), threshold, gr.read(), gw.read(), addr.read()); 
  }

  SC_CTOR(bus_monitor)
  {
    state = idle;
    reads = 0;
    writes = 0;
    // Combinational logic: react to all inputs.
    SC_METHOD(runme); sensitive << hwen << hren << opack;

  }
};

// eof
#endif
