// $Id: $
// Two-away addr_decode: demultiplex part of the address space to give two separate request signals.
// Typically use in a balanced tree.

#ifndef ADDR_DECODE_H
#define ADDR_DECODE_H

SC_MODULE(addr_decode)
{
  uint32 threshold;
  sc_in <bool> gr, gw;
  sc_out <bool> yr0, yr1, yw0, yw1;
  sc_in <uint32> addr;

  void runme()
  {
    if (addr.read() < threshold)
      {
	yr0 = gr.read();
	yw0 = gw.read();
	yr1 = 0; 
	yw1 = 0;
      }
    else
      {
	yr1 = gr.read();
	yw1 = gw.read();
	yr0 = 0; 
	yw0 = 0;
      }

    //printf("%s  Thresh=0x%X  gr=%i rw=%i A=0x%X\n", name(), threshold, gr.read(), gw.read(), addr.read()); 
  }

  SC_CTOR(addr_decode)
  {
    // Combinational logic: react to all inputs.
    SC_METHOD(runme); sensitive << gr << gw << addr;

  }
};

// eof
#endif
