// $Id: $
// The nominal processor core wrapped up as a SystemC TLM model (but not using TLM2.0 library). 
//

#ifndef NOMINALPROC_RTL_H
#define NOMINALPROC_RTL_H

#include "djip/nominalproc_iss.h"
#include "djip/nominal_tlm.h"




// This component inherits the nominal processor ISS (instruction set simulator).
// 
class nominalproc_tlm : public nominalproc_iss, public sc_module
{
public:
  sc_time delay; 
  sc_port <memport_if> port0;
  sc_in <bool> rst, clk, irq;

#define Q(X, Y) printf("%s: %s %X\n", name(), X, Y)

  int codefetch(int a)  // Perform ESL remote read
  {
    Q("fetch code from ", a);
    MEMPAYLOAD pkt;
    pkt.rwbar = 1; pkt.addr = a;
    port0->b_transact(&pkt, delay);
    return pkt.data;
  }

  int datafetch(int a)
  {
    // Map code and data spaces to one. No separate I-cahce or Harvard-like features! 
    return codefetch(a);
  }


  void datawrite(int a, int d)  // Perform ESL remote write
  {
    printf("%s Datawrite A=0x%08X  D=0x%08x\n", name(), a, d);
    MEMPAYLOAD pkt;
    pkt.rwbar = 0; pkt.addr = a; pkt.data = d;
    port0->b_transact(&pkt, delay);
  }


  void runme()
  {
    // In a grander system, granularity is global and user settable, held in the quantum keeper class...
    sc_time quantum_granularity = sc_time(100, SC_NS);


    while(1)
      {
#ifdef SHOW_LOOSE_TIMING_OPERATION
	cout << name() << " runstep eds=" << sc_time_stamp() << " delay=" << delay << " total=" << delay+sc_time_stamp() << "\n";
#endif
	if (rst.read()) reset();
	else if (irq.read() && !interrupted) 
	  {
	    interrupt();
	    printf("iss: %s IRQ\n", name());
	  }
	else if (runhaltb) step();


	delay += sc_time(2500, SC_PS); // Account for my clock period.

	// Here we could instead call out to a shared quantum keeper or the one from
	// the TLM 2.0 reference implementation, if we were using it ...
	if (delay > quantum_granularity) // Does quantum keeper need_sync() ? 
	  {
	    wait(delay + sc_time_stamp()); // Then perform sync()
	    delay = SC_ZERO_TIME;
	  }
      }
  }

  SC_CTOR(nominalproc_tlm)
  {
    delay = SC_ZERO_TIME;
    SC_THREAD(runme);
  }
};

#endif
// eof
