// $Id: $
// 
// A much cut-down generic payload for demo purposes.

#ifndef NOMINAL_TLM_H
#define NOMINAL_TLM_H

// Our own version of the generic payload.
// TLM2.0 version supports variable length bursts, byte lanes and a return code.
typedef struct mempayload_s
{
  bool rwbar;
  uint32 data, addr;
} MEMPAYLOAD;




class memport_if : public sc_interface
{
  public:  virtual void b_transact(MEMPAYLOAD *p, sc_time &delta) = 0;
};


#ifdef TAGGED_TLM
// We have to add a tag of some sort, TLM1.0 style, for multiple instances of same interface.
template <class T> class tagged_memport_if : public memport_if
{
  virtual void tag(T*) = 0;
};

#endif
#endif
// eof
