// $Id: $
// djip: bus combiner - RTL style coding.
//
#ifndef BUS_COMBINER 
#define BUS_COMBINER 

// Two target ports and one initiator port are combined with static priority to the zeroth port.


SC_MODULE(bus_combiner)
{
  sc_in <bool> rst, clk;

  // LHS port0 : target
  sc_in <uint32> addr_l0, wdata_l0;
  sc_out <uint32> rdata_l0;
  sc_in <bool> hwen_l0, hren_l0;
  sc_out <bool> opack_l0;
  // LHS port1 : target
  sc_in <uint32> addr_l1, wdata_l1;
  sc_out <uint32> rdata_l1;
  sc_in <bool> hwen_l1, hren_l1;
  sc_out <bool> opack_l1;

  // RHS port : initiator
  sc_out <uint32> addr_r, wdata_r;
  sc_in <uint32> rdata_r;
  sc_out <bool> hwen_r, hren_r;
  sc_in <bool> opack_r;

  void process()
  {
    hwen_r = 0;
    while (1)
      {
	wait(clk.posedge_event());
	if (hwen_l0.read() || hren_l0.read())
	  {
	    addr_r = addr_l0.read();
	    hren_r = hren_l0.read();
	    hwen_r = hwen_l0.read();
	    wdata_r = wdata_l0.read();
	    do { wait(clk.posedge_event()); } while (!opack_r.read());
	    rdata_l0 = rdata_r.read();
	    hwen_r = 0;
	    hren_r = 0;
	    opack_l0 = 1;
	    do { wait(clk.posedge_event()); } while (opack_r.read());
	    opack_l0 = 0;
	  }
	else if (hwen_l1.read() || hren_l1.read())
	  {
	    addr_r = addr_l1.read();
	    hren_r = hren_l1.read();
	    hwen_r = hwen_l1.read();
	    wdata_r = wdata_l1.read();
	    do { wait(clk.posedge_event()); } while (!opack_r.read());
	    rdata_l0 = rdata_r.read();
	    hwen_r = 0;
	    hren_r = 0;
	    opack_l1 = 1;
	    do { wait(clk.posedge_event()); } while (opack_r.read());
	    opack_l1 = 0;
	  }

      }
  }

  SC_CTOR(bus_combiner)
  {
    SC_THREAD(process);
  }

};

#endif
// eof
