// SoC D&M Course Toy Classes Nominal Processor:   (C) DJ Greaves, 2009-11.  
// $Id: $
// 
//  
//
// This file contains a SystemC testbench for a single TLM-style CPU and two RAM banks.


#define uint32 unsigned int
// Perhaps instead defined as sc_uint<32> ?


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "systemc.h"
#include "djip/nominalproc_tlm.h"
#include "djip/clock100.h"
#include "djip/ram32.h"
#include "djip/tlmram32.h"
#include "djip/busmux.h"
#include "djip/tlm_busmux.h"
#include "djip/addr_decode.h"


sc_trace_file *g_tf = 0;

#define SRAM_SIZE_WORDS 1024

ASM test_program[] = 
  {
    { "start", ORG,  0, 0, "Reset to here" },
    { "io_base", EQU,  0x20000, 0, "Output device" },
    { 0,      JMP,  L(enter), 0, "" },
    { "unity", DEFW,  1, 0, "" },


    { "enter", LOAD,  R1, L(unity), "" },
    { "loop",  ADD,  R1, R1, "Double until wraps to zero" },
    { "",      STORE,  R1, L(io_base), "" },
    { "",      BNZ,  R1, L(loop), "" },
    { "",      HALT, 0, 0, "" },
    { "",      END,  0, 0, "" } // Terminate end of program

  }
;

 
SC_MODULE(testsys)
{
#define ONE_RAM 1 // Experiments: set this to zero or one
  sc_in <bool> rst, clk;
  sc_signal <bool> irq;

  // TLM processor core instance:
  nominalproc_tlm nominal_0;

#if !ONE_RAM
  // Bus components:
  tlm_busmux tlm_busmux_0;

  // TLM static RAM instances:
  tlmram32 data_memory_0;
#endif
  tlmram32 code_memory_0;

  SC_CTOR(testsys) :
    nominal_0("nominal_0"),
#if !ONE_RAM
    tlm_busmux_0("tlm_busmux_0"),
    data_memory_0("data_memory_0", SRAM_SIZE_WORDS),
#endif
    code_memory_0("code_memory_0", SRAM_SIZE_WORDS)
  {
    nominal_0.rst(rst);
    nominal_0.clk(clk);
    nominal_0.irq(irq);
    irq = 0;

#if ONE_RAM // Two possible wiring configurations
    // Direct connection for processor to RAM
    nominal_0.port0(code_memory_0);

#else
    // Connection to two memories using a buxmux

    tlm_busmux_0.threshold = 0x10000;
    nominal_0.port0(tlm_busmux_0);
    tlm_busmux_0.port0(code_memory_0);
    tlm_busmux_0.port1(data_memory_0);
#endif


  }

}; // end of class testsys


//
//
//

int main()
{
  assembler *A;
  uint32 *code = (uint32 *) malloc(SRAM_SIZE_WORDS * sizeof(uint32));
  A = new assembler(code, SRAM_SIZE_WORDS); 
  A->assemble("test_program", test_program);


  g_tf = sc_create_vcd_trace_file("trace");
  g_tf->set_time_unit(1, SC_NS);

  // Some residual RTL exosystem.
  // Still generate RTL-style clock, in case some TLM components do not ignore it.
  sc_signal <bool> rst, clk;
  clock100 u_clkgen("u_clkgen");
  u_clkgen.clk(clk);


  testsys *testsys0 = new testsys("testsys0");
  testsys0->clk(clk);
  testsys0->rst(rst);
  testsys0->code_memory_0.add_contents(code); // Initial program load


  // Test stimulus now follows
  rst = 1;
  sc_start(100, SC_NS);
  rst = 0;
  printf("End of reset\n");
  sc_start(10, SC_US);

  cout << "Single CPU SystemC nominal proc finished at " << sc_time_stamp() << "\n";
  if (g_tf) sc_close_vcd_trace_file(g_tf);
  return 0;
}


// eof
