// $Id: $
// djip: DRAM controller.
//


#ifndef dram_controller_H
#define dram_controller_H

#define TRC(X) X



SC_MODULE(dram_controller)
{
 public:
  sc_in <bool> rst, clk;

  // Slave/target net-level port (e.g. for CPU or cache backside to connect to)
  sc_in <uint32> addr, wdata;
  sc_out <uint32> rdata;
  sc_in <bool> hren, hwen;
  sc_out <bool> opack;


  // DRAM control outputs
  sc_out <bool> dr_ras_n;        // Row address strobe (active low)
  sc_out <bool> dr_cas_n;        // Column address strobe (active low)
  sc_out <bool> dr_we_n;         // Write enable (active low)

  sc_out <sc_uint<10> > dr_ma;    // Multiplexed address
  sc_out <uint32>  dr_wdata;      // Write Data
  sc_in <uint32> dr_rdata;        // Read Data
  
  uint32 current_row;


  void behaviour()
  {
    dr_ras_n = 1; dr_cas_n = 1; dr_we_n = 1;
    current_row = -1;
    while (1)
      {
	wait(clk.posedge_event());
	if (hren.read() || hwen.read()) 
	  {
	    uint32 row = (addr.read() >> 12) & 1023;
	    if (row != current_row && !dr_ras_n.read())
	      {
		dr_ras_n = 1; // Terminate current row and wait precharge time.
		wait(clk.posedge_event());
		wait(clk.posedge_event());
		dr_ma = row; current_row = row;
		dr_ras_n = 0;
		wait(clk.posedge_event());
	      }
	    dr_ma = (addr.read()>>2) & 1023;
	    dr_cas_n = 0;
	    if (hwen.read()) { dr_we_n = 0; dr_wdata = wdata.read(); }
	    wait(clk.posedge_event());
	    if (hren.read()) rdata = dr_rdata.read();
	    dr_cas_n = 1;  dr_we_n = 1; opack = 1;
	    do { wait(clk.posedge_event()); } while (hren.read() || hwen.read());
	    opack = 0;
	  }
      }
  }





 SC_CTOR(dram_controller)
  {
    SC_THREAD(behaviour);
  }

};

#endif
// eof
