/* 
 * $Id: ethercrc_tlm.cpp,v 1.2 2011/03/22 09:46:33 djg11 Exp $
 * (C) 2009-10 DJ Greaves - Ethernet CRC coprocessor example
 */

#define TRC(X) 


#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include "ethercrc_memmap.h"
#include "ethercrc_tlm.h"



void ethercrc_tlm::b_access(tlm::tlm_generic_payload &trans, sc_time &delay)
{
  tlm::tlm_command cmd = trans.get_command();
  uint32_t    adr = ((uint32_t)trans.get_address() & 0x1Ffffffc);
  uint8_t*	ptr = trans.get_data_ptr();
  uint32_t    len = trans.get_data_length();
  uint8_t*	lanes = trans.get_byte_enable_ptr();
  uint32_t    wid = trans.get_streaming_width();

  delay += latency;
    
  // Obliged to check address range and check for unsupported features,
  //   i.e. byte enables, streaming, and bursts
  // Can ignore DMI hint and extensions
  // Using the SystemC report handler is an acceptable way of signalling an error
  

   
  if (len > 4 || wid < len) 
      {
	trans.set_response_status( tlm::TLM_BURST_ERROR_RESPONSE );
	return;
      }

  // Obliged to implement read and write commands
  if (cmd == tlm::TLM_READ_COMMAND)
    {
      u32_t r = 0;
      switch (adr)
	{
	case CRC_RESET_REG:
	  break;
	case CRC_DATA_8_PROCESS_REG:
	  break;

	case CRC_READ_REG:
	  r = bevcore.read_crc();
	  break;
	case CRC_CONTROL_REG:
	  r = bevcore.read_control();
	  break;
	}
      ((u32_t *)ptr)[0] = r;
    }
  else if (cmd == tlm::TLM_WRITE_COMMAND)
    {
      u32_t d32 = ((u32_t *)ptr)[0];
      switch (adr)
	{
	case CRC_RESET_REG:
	  bevcore.reset_operation();
	  break;

	case CRC_DATA_8_PROCESS_REG:
	  bevcore.process_byte(d32 & 0xFF);
	  break;

	case CRC_DATA_32_PROCESS_LE_REG:
	  bevcore.process_word32_le(d32);
	  break;
	case CRC_DATA_32_PROCESS_BE_REG:
	  bevcore.process_word32_be(d32);
	  break;
	case CRC_READ_REG:
	  break;
	case CRC_CONTROL_REG:
	  bevcore.write_control(d32);
	  break;
	}
    }
  
  trans.set_response_status( tlm::TLM_OK_RESPONSE);
}


// eof


