#ifndef ETHERCRC_BEV_CORE_H
#define ETHERCRC_BEV_CORE_H

// Ethernet CRC Processor - behavioural model
// $Id: ethercrc_bev_core.h,v 1.1 2011/03/22 07:30:34 djg11 Exp $


#include "tenos.h"

const u32_t ethernet_polynomial_le = 0xedb88320U;

class ethercrc_bev_core
{
  u32_t crc_reg;
  u32_t control_reg;

public:
  u32_t read_crc();
  u32_t read_control();
  void write_control(u32_t);
  void reset_operation();
  void process_byte(u8_t dd);
  void process_word32_be(u32_t dd);
  void process_word32_le(u32_t dd);
};



#endif
