//
// (C) 2009-10 DJ Greaves (TLM 2.0 Version Arturs Prieditis) 
// Blocking TLM wrapper for the verilated or fast versions of the OR1200 core.
// $Id: $
//

#include "systemc.h"
#include "tlm.h"
#include "tlm_utils/simple_initiator_socket.h"
#include "tlm_utils/tlm_quantumkeeper.h"

#if 1
#include "Vor1200_top.h"
#include "OrpsocAccess.h"
#else
#include "../orsim/orsim.h"
#endif

#include "../sw/support/socdam.h"
#include "../sw/support/spr_defs.h"

#define BENCH_RESET_TIME 10

class OR1200 : public sc_core::sc_module 
{
 public:
  OR1200(sc_core::sc_module_name name, uint8_t pID);
  tlm_utils::simple_initiator_socket<OR1200> initiator_socket;

  uint32_t counter_ticks;
  uint32_t tracing;
#if 1
  Vor1200_top  or1200;
  OrpsocAccess accessor; 
 
  // Net-level connections to Verilated processor core.
  bool		dcyc_o;
  bool		dstb_o;
  bool		dcab_o;
  uint32_t	dadr_o;
  uint32_t	dsel_o;
  bool		dwe_o;
  uint32_t	ddat_o;
  uint32_t	ddat_i;
  bool		dack_i;
  bool		derr_i;
  bool		drty_i;

  //instruction
  bool		icyc_o;
  bool		istb_o;
  bool		icab_o;
  uint32_t	iadr_o;
  uint32_t	isel_o;
  bool		iwe_o;
  uint32_t	idat_o;
  uint32_t	idat_i;
  bool		iack_i;
  bool		ierr_i;
  bool		irty_i;


#else
  orsim or1200;
#endif

  bool over;
  bool clk;
 protected:
  virtual void  doInitiatorTrans( tlm::tlm_generic_payload &trans,sc_time& delay  );

 private:
  tlm_utils::tlm_quantumkeeper m_qk; // Quantum keeper for temporal decoupling 
  uint8_t procID;
  void run();
  void update(bool c);
  void decode();
  uint32_t mem_read(uint32_t addr, sc_time &delay);
  void mem_write(uint32_t  addr,  uint8_t mask, uint32_t wdata, sc_time &delay);
  void corepause(int us);  // Pause CPU for this time interval
  virtual void dummy ( ) { };
};


// eof
