//
// (C) 2009-10 DJ Greaves (TLM 2.0 Version Arturs Prieditis) 
// Blocking TLM wrapper for the verilated version of the OR1200 core.
// $Id: $
//
#include "OR1200.h"

#define GLOBAL_QNT	sc_time(4, SC_US)
#define LOCAL_INC 	sc_time(1, SC_NS)

class argv_backdoor_setup *argv_backdoor = 0;

#include <iostream>

SC_HAS_PROCESS(OR1200::OR1200);

// Constructor
OR1200::OR1200(sc_core::sc_module_name name, uint8_t pID):	 
  sc_module(name),
  initiator_socket("initiator_socket"),
  or1200("or1k2"),
  accessor(&or1200),
  over(false)
  
{
  procID=pID;
  SC_THREAD(run);
  char txt[20];
  sprintf(txt, "OR1200_CORE_%d", procID);
  tracing = 0;
  counter_ticks = 0;
//or1200.............................................................//

  or1200.rst_i  	= 1;
  or1200.dwb_rst_i	= 1;
  or1200.iwb_rst_i      = 1;
 
  or1200.clmode_i = 0;
 // Debug i/f
  or1200.dbg_ewt_i = 0;
  or1200.dbg_stall_i = 0;

// Interrupts: tied off to zero in this version.
  or1200.pic_ints_i =  0;  

  
  update(0);
  // *************************************************************************
  // All initiators use a quantum of 1us, that is, they synchronize themselves
  // to simulation time every 1us using the quantum keeper
  // *************************************************************************

  m_qk.set_global_quantum(GLOBAL_QNT);
  m_qk.reset();
}



void OR1200::update(bool c)
{
  or1200.clk_i 		= c;
  or1200.dwb_clk_i	= c;
  or1200.iwb_clk_i   	= c;  
  
//updates input signals
  or1200.dwb_ack_i	= dack_i ;  
  or1200.dwb_dat_i	= ddat_i;
  or1200.dwb_err_i	= derr_i;
  or1200.dwb_rty_i	= drty_i;
  
  or1200.iwb_ack_i      = iack_i; 
  or1200.iwb_dat_i	= idat_i;
  or1200.iwb_err_i      = ierr_i;
  or1200.iwb_rty_i      = irty_i;
  
// evaluate the model
  or1200.eval();
 
//updates output signals
  dadr_o		= or1200.dwb_adr_o;
  dcab_o		= or1200.dwb_cab_o;
  dcyc_o		= or1200.dwb_cyc_o;
  ddat_o		= or1200.dwb_dat_o;
  dsel_o		= or1200.dwb_sel_o;
  dstb_o		= or1200.dwb_stb_o;
  dwe_o		= or1200.dwb_we_o;
  
  iadr_o		= or1200.iwb_adr_o;
  icab_o		= or1200.iwb_cab_o;
  icyc_o		= or1200.iwb_cyc_o;
  idat_o		= or1200.iwb_dat_o;
  isel_o		= or1200.iwb_sel_o;
  istb_o		= or1200.iwb_stb_o;
  iwe_o		= or1200.iwb_we_o;
}

// Process for the core.
void OR1200::run()
{
  sc_time delay;

  or1200.rst_i 	 	= 0;
  or1200.dwb_rst_i	= 0 ;
  or1200.iwb_rst_i	= 0;

  while(!over)
    {
      counter_ticks += 1;
      delay = m_qk.get_local_time();
      decode(); if (over) break;
      update(1);
      
      // This interface blocks the processor core while I/O operations are blocked.
      // It would be much better to keep the core clocking...

      //Service instruction fetch port
      if (icyc_o && istb_o)
	{
	  idat_i = mem_read(iadr_o, delay);
	  iack_i = true; 
	}
      else iack_i = false; //clear previous ack
      
      //Service data read/write port
      if (dcyc_o && dstb_o)
	{
	  if (!dwe_o) ddat_i = mem_read(dadr_o, delay); 
	  else mem_write(dadr_o, dsel_o, ddat_o, delay);
	  dack_i = true; 
	}
      else dack_i = false; //clear previous ack

      update(0);
      
      // Accumulate local time and synchronize when quantum is reached
      m_qk.set( delay ); // fixed quantum: should be set once outside main loop!
      m_qk.inc( LOCAL_INC  );// Model time used for additional processing
      if (m_qk.need_sync()) m_qk.sync();
    } 
}



void OR1200::decode()
{
  uint32_t  r3;
  uint32_t instr;
  // Check the instruction when the freeze signal is low.
  if (!accessor.getWbFreeze())
   {
     instr=accessor.getWbInsn();

     #include "backdoor_nops.C"
    }
}


uint32_t OR1200::mem_read(uint32_t memaddr, sc_time &delay)
{
  #include "backdoor_reads.C"

  // Set up the payload fields. Assume everything is 4 bytes.
  uint32_t rdata;
  tlm::tlm_generic_payload trans;


  trans.set_read();
  trans.set_address((sc_dt::uint64)addr);

  trans.set_data_length( 4 );
  trans.set_data_ptr((unsigned char *)&rdata);

  trans.set_byte_enable_length( 4 );
  unsigned char mask = 15;
  trans.set_byte_enable_ptr(&mask);

  trans.set_streaming_width( 4 );
  trans.set_dmi_allowed( false );

  trans.set_response_status( tlm::TLM_INCOMPLETE_RESPONSE );

  doInitiatorTrans(trans,delay);
  if (tracing > 0) { printf("[Reading %i %x %x]\n", procID, addr, rdata); tracing -= 1; }

  if (!(counter_ticks & 0x7FFFF))printf("[Reading %i %x %x]\n", procID, addr, rdata); 
  return rdata;
}



void OR1200::mem_write(uint32_t memaddr, uint8_t mask, uint32_t wdata, sc_time &delay)
{
  #include "backdoor_writes.C"

  tlm::tlm_generic_payload  trans;

  trans.set_write();
  trans.set_address( (sc_dt::uint64)memaddr );

  trans.set_data_length(4);
  trans.set_data_ptr( (unsigned char *)&wdata );

  trans.set_byte_enable_length(4);
  trans.set_byte_enable_ptr(&mask);

  trans.set_streaming_width( 4 );
  trans.set_dmi_allowed( false );

  trans.set_response_status( tlm::TLM_INCOMPLETE_RESPONSE );
 
  doInitiatorTrans(trans, delay);
}


void OR1200::doInitiatorTrans( tlm::tlm_generic_payload &trans, sc_time& delay  )
{
  initiator_socket->b_transport(trans, delay);
  if (trans.is_response_error())
    {
      char txt[100];
      sprintf(txt, "Error from b_mem_access, response status = %s", trans.get_response_string().c_str());
      SC_REPORT_ERROR("TLM-2", txt);
    } 
}


void OR1200::corepause(int us)  // Pause CPU for this time interval
{
  // We need to implement the halt and interrupt material as well...
  sc_time delay(us, SC_US);
  m_qk.inc( delay  );
}

#if TRACE
     sprintf(txt, "clk_%d", i);
     sc_trace(Tf, processor[i]->clk,txt );
     //or1200 instructions
     
     sprintf(txt, "icyc_o_%d", i);
     sc_trace(Tf, processor[i]->icyc_o,txt ); 
     sprintf(txt, "istb_o_%d", i);
     sc_trace(Tf, processor[i]->istb_o,txt );  
     sprintf(txt, "icab_o_%d", i);
     sc_trace(Tf, processor[i]->icab_o,txt);
     sprintf(txt, "iadr_o_%d", i);
     sc_trace(Tf, processor[i]->iadr_o,txt);
     sprintf(txt, "iack_i_%d", i);
     sc_trace(Tf, processor[i]->iack_i,txt);
     sprintf(txt, "idat_i_%d", i);
     sc_trace(Tf, processor[i]->idat_i,txt);
     sprintf(txt, "ierr_i_%d", i);
     sc_trace(Tf, processor[i]->ierr_i,txt);
     sprintf(txt, "idat_o_%d", i);
     sc_trace(Tf, processor[i]->idat_o,txt);
     sprintf(txt, "iwe_o_%d", i);
     sc_trace(Tf, processor[i]->iwe_o,txt);
     sprintf(txt, "irty_i_%d", i);
     sc_trace(Tf, processor[i]->irty_i,txt);
     sprintf(txt, "isel_o_%d", i);
     sc_trace(Tf, processor[i]->isel_o,txt);
     
     //or1200 data
     sprintf(txt, "dcyc_o_%d", i);
     sc_trace(Tf, processor[i]->dcyc_o,txt); 
     sprintf(txt, "dstb_o_%d", i);
     sc_trace(Tf, processor[i]->dstb_o, txt );  
     sprintf(txt, "dcab_o_%d", i);
     sc_trace(Tf, processor[i]->dcab_o,txt);
     sprintf(txt, "dadr_o_%d", i);
     sc_trace(Tf, processor[i]->dadr_o,txt);
     sprintf(txt, "dack_i_%d", i);
     sc_trace(Tf, processor[i]->dack_i,txt);
     sprintf(txt, "ddat_i_%d", i);
     sc_trace(Tf, processor[i]->ddat_i,txt);
     sprintf(txt, "derr_i_%d", i);
     sc_trace(Tf, processor[i]->derr_i,txt);
     sprintf(txt, "ddat_o_%d", i);
     sc_trace(Tf, processor[i]->ddat_o,txt);
     sprintf(txt, "dwe_o_%d", i);
     sc_trace(Tf, processor[i]->dwe_o,txt);
     sprintf(txt, "drty_i_%d", i);
     sc_trace(Tf, processor[i]->drty_i,txt);
     sprintf(txt, "dsel_o_%d", i);
     sc_trace(Tf, processor[i]->dsel_o, txt);
#endif

// eof
