/*
 * $ProjectName$
 * $ProjectRevision$
 * -----------------------------------------------------------
 * $Id: PlayerApplet.java,v 1.3 2003/04/10 19:48:40 jarnbjo Exp $
 * -----------------------------------------------------------
 *
 * $Author: jarnbjo $
 *
 * Description:
 *
 * Copyright 2002-2003 Tor-Einar Jarnbjo
 * -----------------------------------------------------------
 *
 * Change History
 * -----------------------------------------------------------
 * $Log: PlayerApplet.java,v $
 * Revision 1.3  2003/04/10 19:48:40  jarnbjo
 * no message
 *
 * Revision 1.2  2003/03/31 00:22:29  jarnbjo
 * no message
 *
 * Revision 1.1  2003/03/16 01:10:45  jarnbjo
 * no message
 *
 */

package de.jarnbjo.oggtools;

import java.applet.Applet;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.net.*;
import java.text.*;
import java.util.*;
import javax.sound.sampled.*;

import netscape.javascript.JSObject;

import de.jarnbjo.ogg.*;
import de.jarnbjo.vorbis.*;

public class PlayerApplet extends Applet implements Runnable {

   private boolean running=false;
   private boolean initialized=false;
   private VorbisStream vStream;
   private LogicalOggStream loStream;
   private JSObject jsObject=null;

   private boolean jsEnabled=false;

   //TextField tfArtist, tfTitle;
   //Label labArtist, labTitle;

   private String artist="", title="", time="", currentBitRate="", status="";
   private long streamTime;
   private DateFormat streamTimeFormat=new SimpleDateFormat("H:mm:ss");
   private int trackIndex=0;

   public void init() {
      try {
         jsObject=JSObject.getWindow(this);
      }
      catch(Exception e) {
      }
      streamTimeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
   }

   public void start() {
      try {
         jsObject=JSObject.getWindow(this);
      }
      catch(Exception e) {
      }
      streamTimeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
      artist="";
      title="";
      running=true;
      new Thread(this).start();
   }

   public void stop() {
      running=false;
   }

   public void paint(Graphics g) {
      g.drawString(currentBitRate, 20, 30);
      g.drawString(time, 120, 30);
      g.drawString(artist, 20, 60);
      g.drawString(title, 20, 80);
   }

   public void waitForInitialization() {
      while(!initialized) {
         try {
            Thread.sleep(100);
         }
         catch (InterruptedException ex) {
         }
      }
   }

   public String getCurrentBitRate() {
      return vStream==null?"-":""+vStream.getCurrentBitRate();
   }

   public String getTitle() {
      return vStream==null?"-":""+vStream.getCommentHeader().getTitle();
   }

   public String getArtist() {
      return vStream==null?"-":""+vStream.getCommentHeader().getArtist();
   }

   public void rewind(int milliseconds) throws IOException {
      long cgp=loStream.getTime();
      long diff=milliseconds*vStream.getIdentificationHeader().getSampleRate()/1000;
      cgp-=diff;
      if(cgp<0L) cgp=0L;
      loStream.setTime(cgp);
   }

   public void forward(int milliseconds) throws IOException {
      long cgp=loStream.getTime();
      long diff=milliseconds*vStream.getIdentificationHeader().getSampleRate()/1000;
      cgp+=diff;
      if(cgp>loStream.getMaximumGranulePosition()) cgp=loStream.getMaximumGranulePosition();
      loStream.setTime(cgp);
   }

   public void setTrackNumber(String index) {
      setTrackNumber(Integer.parseInt(index));
   }

   public void setTrackNumber(int index) {
      trackIndex=index-1;
      running=false;
   }


   public String getStreamTime() {
      Date d=new Date();
      d.setTime(streamTime);
      String s=streamTimeFormat.format(d);
      return s;
   }

   public void callJavascript(String command) {
      if(!jsEnabled) {
         return;
      }
      try {
         getAppletContext().showDocument(
            new java.net.URL("javascript:"+command));
      }
      catch (Exception ex) {
         ex.printStackTrace();
      }
   }

   public void setHtmlTitle(String title) {
      if(!jsEnabled) {
         return;
      }
      if(jsObject==null) {
         callJavascript("setTitle('"+title+"');");
         callJavascript("setEscapedTitle('"+escapeString(title)+"');");
      }
      else {
         jsObject.call("setTitle", new Object[]{title});
         jsObject.call("setEscapedTitle", new Object[]{escapeString(title)});
      }
   }

   public void setHtmlArtist(String artist) {
      if(!jsEnabled) {
         return;
      }
      if(jsObject==null) {
         callJavascript("setArtist('"+artist+"');");
         callJavascript("setEscapedArtist('"+escapeString(artist)+"');");
      }
      else {
         jsObject.call("setArtist", new Object[]{artist});
         jsObject.call("setEscapedArtist", new Object[]{escapeString(artist)});
      }
   }

   public void setHtmlStatus(String status) {
      if(!jsEnabled) {
         return;
      }
      if(jsObject==null) {
         callJavascript("setStatus('"+status+"');");
      }
      else {
         jsObject.call("setStatus", new Object[]{status});
      }
   }

   public void setHtmlBps(int bps) {
      if(!jsEnabled) {
         return;
      }
      if(jsObject==null) {
         callJavascript("setBps("+bps+");");
      }
      else {
         jsObject.call("setBps", new Object[]{new Integer(bps)});
      }
   }

   public void setHtmlTrackNumber(int trackNo) {
      if(!jsEnabled) {
         return;
      }
      if(jsObject==null) {
         callJavascript("setTrackNumber("+trackNo+");");
      }
      else {
         jsObject.call("setTrackNumber", new Object[]{new Integer(trackNo)});
      }
   }

   public void setHtmlStreamTime(String streamTime) {
      if(!jsEnabled) {
         return;
      }
      if(jsObject==null) {
         callJavascript("setStreamTime('"+streamTime+"');");
      }
      else {
         jsObject.call("setStreamTime", new Object[]{streamTime});
      }
   }

   public void run() {
      jsEnabled=getParameter("javascriptEnabled")!=null && getParameter("javascriptEnabled").equalsIgnoreCase("true");
      String urlList=getParameter("url");
      StringTokenizer stok=new StringTokenizer(urlList, ",");
      String[] urls=new String[stok.countTokens()];
      for(int i=0; i<urls.length; i++) {
         urls[i]=stok.nextToken();
      }

      try {
         while(true) {
            if(trackIndex>=urls.length) {
               trackIndex=0;
            }
            String url=urls[trackIndex++];

            try {
               running=true;
               setHtmlStatus("Buffering...");

               final CachedUrlStream os=new CachedUrlStream(new URL(getCodeBase(), url));
               final LogicalOggStream los=(LogicalOggStream)os.getLogicalStreams().iterator().next();
               final VorbisStream vs=new VorbisStream(los);
               vStream=vs;
               loStream=los;

               initialized=true;

               setHtmlTitle(vs.getCommentHeader().getTitle());
               setHtmlArtist(vs.getCommentHeader().getArtist());
               setHtmlTrackNumber(Integer.parseInt(vs.getCommentHeader().getTrackNumber()));

               setHtmlStatus("Playing...");

               /*
               try {
                  getAppletContext().showDocument(
                     new java.net.URL(getCodeBase(), "applet-update.jsp?update=title_artist_clock"),
                     "scriptFrame");
               }
               catch (Exception ex) {
                  ex.printStackTrace();
               }
               */

               AudioFormat audioFormat=new AudioFormat(
                  (float)vs.getIdentificationHeader().getSampleRate(),
                  16,
                  vs.getIdentificationHeader().getChannels(),
                  true, true);

               DataLine.Info dataLineInfo=new DataLine.Info(SourceDataLine.class, audioFormat);

               SourceDataLine sourceDataLine=(SourceDataLine)AudioSystem.getLine(dataLineInfo);

               sourceDataLine.open(audioFormat);
               sourceDataLine.start();

               VorbisInputStream vis=new VorbisInputStream(vs);
               AudioInputStream ais=new AudioInputStream(vis, audioFormat, -1);

               byte[] buffer=new byte[4096];
               int cnt=0, offset=0;
               int total=0;
               long sampleRate=vs.getIdentificationHeader().getSampleRate();
               long oldLt=0;
               Date date=new Date();
               DateFormat df=new SimpleDateFormat("H:mm:ss");
               df.setTimeZone(TimeZone.getTimeZone("GMT"));

               while(running) {
                  offset=0;
                  while(offset<buffer.length && (cnt = ais.read(buffer, offset, buffer.length-offset))>0) {
                     offset+=cnt;
                  }
                  if(cnt==-1) {
                     running=false;
                  }
                  if(offset > 0){
                     sourceDataLine.write(buffer, 0, offset);
                     total+=offset;
                     long lt=los.getTime();
                     lt*=1000L;
                     lt/=sampleRate;
                     //lt/=4;

                     streamTime=lt;

                     //System.out.println(lt);

                     if(lt/1000>oldLt/1000) {
                        date.setTime(lt);
                        time=df.format(date);
                        setHtmlStreamTime(time);
                        setHtmlBps(vs.getCurrentBitRate());
                     }
                     oldLt=lt;

                  }
                  offset=0;
                  cnt=0;
               }

               sourceDataLine.drain();
               sourceDataLine.close();
            }
            catch(Exception e) {
               e.printStackTrace();
            }
         }
      }
      catch(Exception e) {
         e.printStackTrace();
      }
   }

   private static String escapeString(String in) {
      try {
         StringBuffer res=new StringBuffer();
         byte[] data=in.getBytes("UTF-8");
         for(int i=0; i<data.length; i++) {
            byte b=data[i];
            if(b>=48 && b<=57 ||
               b>=65 && b<=91 ||
               b>=93 && b<=119) {
               res.append((char)b);
            }
            else if(b==32) {
               res.append('+');
            }
            else {
               int ii=b;
               ii&=0xff;
               String is=Integer.toHexString(ii);
               while(is.length()<2) is="0"+is;
               res.append('_').append(is);
            }
         }
         return res.toString();
      }
      catch(Exception e) {
         return null;
      }
   }

   public static class VorbisInputStream extends InputStream {

      private VorbisStream source;

      public VorbisInputStream(VorbisStream source) {
         this.source=source;
      }

      public int read() throws IOException {
         return 0;
      }

      public int read(byte[] buffer) throws IOException {
         return read(buffer, 0, buffer.length);
      }

      private static int cnt=0;

      public int read(byte[] buffer, int offset, int length) throws IOException {
         try {
            return source.readPcm(buffer, offset, length);
         }
         catch(EndOfOggStreamException e) {
            return -1;
         }
      }
   }

}