#!/usr/bin/perl
# vim:set shiftwidth=2 softtabstop=2 expandtab:

#
# Test the throughput of a router
#

use Getopt::Long;

my @sizes = (64, 70, 80, 90, 100, 150, 200, 300, 400, 500, 700, 900, 1100, 1300, 1518);
my %rates;

my $pktgen = 'packet_generator.pl';
my $iter = 1000000;
my $bitfile = 'packet_generator.bit';

$ENV{'NF2_ROOT'} = '/usr/local/NF2';
$ENV{'NF2_DESIGN_DIR'} = '/usr/local/NF2/projects/reference_router';
$ENV{'PERL5LIB'} = '/usr/local/NF2/lib/Perl5';

my $NUM_IFACE = 4;

# Process the command line arguments
my $iface;
unless ( GetOptions ( "iface=i" => \$iface,
		      "help" => \$help,
		     )
	 and ($help eq '')

       ) { usage(); exit 1 }

# Verify that the iface is valid
if (defined($iface)) {
  if ($iface < 0 || $iface >= $NUM_IFACE) {
    print STDERR "$0: Error: the interface must be between 0 and " . ($NUM_IFACE - 1) . "\n\n";
    usage();
    exit 1;
  }
}


# Do the download
system("nf2_download $bitfile");
sleep(5);

print "\n\n\n";
print "Packet Size (bytes) : Rate (Mbps)\n";

foreach $size (@sizes) {
  my $args = getArgs($size);
  my $rates = `./$pktgen $args | grep Rate:`;

  my @portRates = split("\n", $rates);
  my $rate = 0;
  foreach my $portRate (@portRates) {
    if ($portRate =~ /Rate: (\d+\.\d+)/) {
      $portRate = $1;
      $rate += $portRate;
    }
  }
  $rates[$size] = $rate;

  print "$size : $rate\n";
}

exit 0;

#####################################################################
#  Functions
#####################################################################

sub getArgs {
  my ($size) = @_;

  my @ports;
  if (defined($iface)) {
    @ports = ($iface);
  }
  else {
    @ports = (0 .. $NUM_IFACE - 1);
  }
  
  my $args = '';
  foreach my $port (@ports) {
    $args .= sprintf("-q%d pkt-%d-%04d.pcap -d%d 0 -i%d %d ", $port, $port, $size, $port, $port, $iter);
  }

  return $args;
}


sub usage {
  (my $cmd = $0) =~ s/.*\///;
  print <<"HERE1";
NAME
   $cmd - run the router performance tests

SYNOPSIS
   $cmd [--iface <iface_num>]

   $cmd --help  - show detailed help

HERE1

  return unless ($help);
  print <<"HERE";

ARGUMENTS

  --iface <iface_num>   Which interface to run the test on. If not specified then run on *all* ports.

HERE
}
