package uk.ac.cam.rkh23.Algorithms.Sorting;

public class HeapSort implements Sorter {

	@Override
	public String GetID() {
		return "Heap";
	}

	@Override
	public void Sort(int[] array) {
		// First we need to make the array into a valid heap
		for( int i = array.length / 2 - 1; i >= 0; i-- )
			siftDown(array, i, array.length-1);
		
		// Put the biggest element to the end and then
		// sift again on the sub array to put the next biggest
		// element in position zero
		for( int i = array.length-1; i > 1; i--) {
			swap(array, i, 0);
			siftDown(array, 0, i-1);
		}

	}
	
	private static void siftDown(int[] a, int i, int j) {
		int root = i;

		while( 2*root + 1 <= j ) {
			
			int bigchild = 2*root + 1;

			// If the second child is valid we need to 
			// select the bigger of the two children
			if( bigchild < j && a[bigchild] < a[bigchild + 1] ) {
				bigchild = bigchild+1;
			}

			// Now swap if the child is bigger than the root
			// and update the root
			if( a[root] < a[bigchild] ) {
				swap(a, root, bigchild);
				root = bigchild;
			} 
			else return;
			
		}
	}
	
	private static void swap(int[] array, int i, int j) {
		int tmp = array[i];
		array[i]=array[j];
		array[j]=tmp;
	}

}
