(*
 *  The definitions of the byte codes arguments 
 *
 *)

val BCODES_Access = 
    let (* the abstract -> datatypes database *)

(*
 *   The Array that holds the list of fam defs 
 *)


    val {arrayoflist,sub,assign} = ESML_Array;

    val NCCODE = arrayoflist (map (fn _ => INSERT) (0--256));
    fun reset () =
	let
	    fun clear(n) = 
		if n < 257 
		    then (assign(NCCODE,n,INSERT);clear(n+1))
		else ()
	in
	    clear(1)
	end;
				     
    val Error = Comp_ncg "Byte-Code already defined";

    (*
     *  The way to add things to the database
     *) 

   fun define n h d = 
	case NCCODE sub (n+1) of
	    INSERT 	=> assign(NCCODE,n+1,BCDEF (d,h))
	  | BCDEF _	=> raise 
		(Comp_ncg ("Byte-Code already defined"^($ n)));

    (*
     *  The way to access this information
     *
     *)

    fun Access n =  NCCODE sub (n+1);
    
    val _ = reset ();  (* a clean database please *)

in


(*
 *  The actual Database, and its modifiers
 *  This allows us to work with concrete text
 *  yet have an easily retargetable compiler
 *
 *  
 *)

(*	Byte	Class 	argument	*)
(*	~~~~	~~~~~	~~~~~~~~	*)

define	171    	70	(CONST 0);	(* OpReturn0 *)
define	94     	70	(CONST 1);	(* OpReturn1 *)
define  70  	70 	BYTE;        	(* OpReturn *)

define  97  	97      WORD2P;        	(* OpTailApplyW *)
define	74  	97	(BY_CON 1);	(* OpTailApplyn1 *)
define  95  	97	(CONST2 (1,1));	(* OpTailApply11 *)
define  96      97	(CONST2 (0,0));	(* OpTailApply0n *) (*??*)
define 	203     97      (WD_CON 0);	(* OpTailApplyn0 *)
define 	214     97      BYTE2P;		(* OpTailApplyB *)
define 	241 	97	WORD2P;		(* NCTailApply *)

define 	218 	218     BYTE;		(* BCDestTailApply *)
define 	242 	218     BYTE;		(* NCDestTailApply *)

define 	56       56     JWORD;		(* OpJumpW *)
define 	215      56     JBYTE;		(* OpJumpB *)
define 	58       58     JWORD;          (* OpFalseJumpB *)
define 	216      58     JBYTE;          (* OpFalseJumpB *)
define 	57       57     JWORD;          (* OpTrueJumpB *)
define	217      57     JBYTE;          (* OpTrueJumpB *)

define	139 	139	LIST;		(* OpNewHandle *)
define  29	29	LIST;		(* OpCase *)

define  63  	63	WORD;		(* OpGetLocalW *)
define 	207 	63	BYTE;		(* OpGetLocalB *)
define 	124 	63	(CONST 0);	(* OpGetLoc0 *)
define 	125 	63	(CONST 1);	(* OpGetLoc1 *)

define  175     175     WORD2P;		(* OpSlideW (down,amount) *)
define  213     175     BYTE2P;		(* OpSlideB *)

define 	64  	64	WORD;		(* OpPopW *)

define 	66  	66	WORD;		(* OpSqueezeW *)
define 	212  	66	BYTE;		(* OpSqueezeB *)
define  93  	66	(CONST 1);	(* OpSqueeze1 *)

define	1   	1	WORD;		(* OpGetFreeW *)
define 	210	1	BYTE;		(* OpGetFreeB *)
define 	211	1	(CONST 1);	(* OpGetFree1 *)

define	99   	99	WORD;		(* OpGetLitW *)
define 	208	99	BYTE;		(* OpGetLitB *)
define 	209	99      (CONST 1);	(* OpGetLit1 *)

define	183	183	BYTE;		(* OpByteNum *)
define	3	183	(CONST 1);	(* OpTrue *)
define	4	183	(CONST 0);	(* OpFalse *)

define  24	24	WORD;		(* OpQuaDot *)
define  15      24 	(CONST 0);	(* OpFst *)
define  16      24 	(CONST 1);	(* OpSnd *)


define  12	12	WORD;		(* OpTuple *)
define  83	12	(CONST 2);	(* OpTuple *)
define  172     172     WORD2;		(* OpDestTuple *)
define  173     172     (WD_CON 0);	(* OpDestTuplen0 *)
define  181     172     (CONST2 (2,0));	(* OpDestTuplen0 *)

define  68 	68	WORD;		(* OpDestNil *)
define  174 	174	WORD;		(* OpDestQCons *)
define  200 	200	WORD;		(* OpDestInt *)

define  60      60      WORD;		(* OpClosure *)
define  146     60 	(CONST 2);	(* OpClosure1 *)
define  61      61      WORD;		(* OpDumClosure *)
define  147	61      (CONST 2);	(* OpDumClosure1 *)
define  62      62      WORD2;		(* OpRecClosure *)

define  204	204 	WORD;		(* OpDestString *)

define 	140 	140	BYTE;		(* OpBind *)

define  5       5       WORD2;		(* OpInt *)
define  28      28      WORD2;		(* OpDestVariant *)
define  13	13	WORD;		(* OpVarient *)
define  26	26	WORD;		(* OpQuaIs *)
define  27      27	WORD;		(* OpQuaAs *)
define  79      79      JWORD;		(* OpUnTrap *)
define  137     137	WORD;		(* OpDestBigVar *)

(* The following bytes are 'linked' in some way *)

define  72      72      PRIM;		(* OpApplFrame *)
define  240     72      PRIM;		(* NCApplFrame *)
define  42      42      (CONST 42);	(* OpEqInt *)
define  44      42      (CONST 44);	(* OpGreater *)
define  45      42      (CONST 45);	(* OpLess *)
define  46      42      (CONST 46);	(* OpGreatEq *)
define  47      42      (CONST 47);	(* OpLessEq *)

Access (* export the Access function *)

end;
