datatype 'a opt = Absent | Present of 'a 
local
nonfix forgettype 6 1
fun forgettype (x: 'a): 'b = forgettype x
in
abstype object = Object
with
fun mkobj(x:'a) :object = forgettype x
and castobj(x: object) :'a = forgettype x
end (* abstype *)
end (* local *)

type atom' = string

type arity' = int;
val (niladic,monadic,diadic) = (0,1,2);


datatype pseudoOpSort = PSEUDOEqual | PSEUDONotEq | PSEUDOWrite
datatype SMorUser' = SMUNonPrimitive
                   | SMUOverLoaded
		   | SMUPseudoOp of pseudoOpSort

datatype InlineCode' = INLINEabsent
                     | INLINEusedasclosure
		     | INLINEpresent of (int * int * object (*SMCode'*) list)

datatype stkPos' = STKLocal of int | STKGlobal of object
datatype  constructorSort' = CONSortVariant
                          | CONSortPointer
			  | CONSortZero
			  | CONSortRef
	                  | CONSortXcon of int ref
datatype constructorYN' = CYNno 
                        | CYNyes of (constructorSort' * int * int * bool) ref
	
type abSynPatIde' (* SynBindIde' *) =
  {Ide: atom', References: int ref,
   StkPosn: stkPos' ref,
   Constructor: constructorYN',
   Inline: InlineCode' ref,  NativeCoded: bool ref,
   MinFunArity: int ref, SMorUser: SMorUser', UserArity: int ref };
  

datatype abSynConst' = SYNConstInt of int
                   | SYNConstReal of real
		   | SYNConstString of string 

datatype asExpTagTypePur' = ETTPrint | ETTDynamic | ETTCast

datatype syntyptagsort = SYNTAGRecord | SYNTAGVariant

datatype  abSynTypTerm' = 
     SYNTYPVar of  {VarIde: atom'}
   | SYNTYPAppl of {OperIde: atom', 
		    Args: (*SynTypArgs'*) abSynTypTerm' list }
   | SYNTYPTagAppl of {TagSort: syntyptagsort,
		       Args: {Tag:atom', Arg:abSynTypTerm' } list }

type abSynTypArgs' = abSynTypTerm' list


type abSynTypParams' = atom' list;

(**** SML datatypes start here *)

datatype  
abSynExp' (* SynTerm' - abstract syntax expression *) =
  EXPApply (* SynAppl *) of   {Fun: abSynExp',
			       Arg: abSynExp',
			       HowRead: arity' }
| EXPCaseold (* SynCase *) of   {Select: abSynExp',
				 Cases: (* abSynExpCase' *) 
           {Tag: atom', Bind: abSynPat', Body: abSynExp' } list }
| EXPCond  (* SynCond *) of   {CondIf:abSynExp',
			       CondThen:abSynExp',
			       CondElse: abSynExp' }
| EXPConst (* SynConst *) of  abSynConst'
| EXPForcetype (* SynForce *) of  {ForceTerm: abSynExp',
				   ForceType: abSynTypTerm' }
| EXPHandle (* SynHandle *) of {HandLft: abSynExp',
			Match: (*abSynRule'*) (abSynPat' * abSynExp') list }
| EXPIde (* SynIde *) of  {Ide: atom',
			   LastUse: bool ref,
			   Binder: (unit -> abSynPatIde') ref,
			   MonoType: typTerm' ref }
| EXPLambda (* SynLamb *) of  {
                        Match: (*abSynRule'*) (abSynPat' * abSynExp') list,
		        LastUseFreeVar: abSynPatIde' list ref }
| EXPLet (* SynLet *) of      {Decl: abSynDecl', Scope: abSynExp' }
| EXPList  (* SynList *) of   abSynExp' list
| EXPNewCase (* SynNewCase *) of {
                        Match: (*abSynRule'*) (abSynPat' * abSynExp') list,
				  Select: abSynExp' }
| EXPQuaOp (* SynQuaOp *) of  object
| EXPRaise (* SynRaise *) of  {ExcIde: atom',
			       ExcBinder: abSynPatIde' ref,
			       ExcArg: abSynExp' }
| EXPRecord (* SynRecord *) of { RecKey: atom', RecField: abSynExp' } list
| EXPSequence (* SynSequence *) of {SeqLft: abSynExp',
				    SeqRht: abSynExp' }
| EXPTagType (* SynTagType *) of {Arg: abSynExp',
                                  Type: typTerm' ref,
				  Purpose: asExpTagTypePur'}
| EXPTrap (* SynTrap *) of  object
| EXPTuple (* SynTuple *) of  abSynExp' list
| EXPVariant (* SynVariant *) of {VarKey: atom',
				  VarField: abSynExp',
				  VarPos: (atom' -> int * int) ref }
| EXPWhile (* SynWhile *) of  {WhileCond:abSynExp',
			       WhileBody:abSynExp' }

and asDeclDefTypeSort' = DDTShorthand of {SynBinding: abSynTypTerm',
					       TypBinding: typTerm' ref}
			    | DDTIsomorphism of (* abSynDataDef' list *)  
			      {Term: abSynTypTerm',
			       ConstrArgType: typTerm' ref,
			       AbsBinder: abSynPatIde' } list
and abSynDecl' =
  DECLAnd of (* SynDeclAnd *) {Lft: abSynDecl', Rht: abSynDecl' }
| DECLConstrCopy of (* SynDeclDefExcon *)
        {AbsBinder: abSynPatIde',
         Binder: (unit -> abSynPatIde') ref,
         ConstrArgType: typTerm' ref,
         CopyIde: atom' }
| DECLDefType of (* SynDeclDefTyp *)
        {Bind: atom',
         Params: abSynTypParams',
         TypParams: typTerm' list ref,
         TypVarEnv: (*typVarEnv'*) {VarIde: atom', TypVar: typTerm' } list ref,
         DefSort: asDeclDefTypeSort' }
| DECLDefVal of (* SynDeclDefVal *) {Bind: abSynPat',
				    BindType: typTerm' ref,
				    Term: abSynExp' }
| DECLEnc of (* SynDeclEnc *) {Ext: abSynDecl', Int: abSynDecl' }
| DECLIns of (* SynDeclIns *) {Outs: abSynDecl', Ins: abSynDecl' }
| DECLWith of (* SynDeclWith *) {WithExt: abSynDecl', WithInt: abSynDecl' }
| DECLRec of (* SynDeclRec *) {Rec: abSynDecl' }

and asPatRecordType' = PATRTSolid 
                          | PATRTFlexi of (unit -> 
     (* abSynPatRecord' *) {RecKey: atom', RecField: abSynPat' }  list) ref

and abSynPat' (* SynBind' *) =
  PATIde (* SynBindIde *) of {Ide: atom',
			      Binder: abSynPatIde',
			      PreBinder: (abSynPatIde' opt ref) }
| PATAny (* SynBindAny *) 
| PATBoth (* SynBindBoth *) of abSynPat' * abSynPat'
| PATTuple (* SynBindTuple *) of abSynPat' list
| PATConst (* SynBindConst *) of   abSynConst'
| PATAppl (* SynBindAppl *) of  {Ide: atom',
				 Binder: abSynPatIde' ref,
				 Arg: abSynPat',
				 HowRead: arity' }
| PATRecord (* SynBindRecord *) of  
    (* abSynPatRecord' *) {RecKey: atom', RecField: abSynPat' } list * 
       asPatRecordType'
| PATVariant (* SynBindVariant *) of  {VarKey: atom',
				       VarField: abSynPat',
				       VarPos: (atom' -> int * int) ref }
| PATForce (* SynBindForce *) of  {ForceBind: abSynPat',
				   ForceType: abSynTypTerm' }

(*%{AM: the real ANAL stuff starts here}%*)

and loopCheck' = LCUnknown | LCYes | LCNo 

and typTerm' =
  TYPVar (* TypVar *) of object
	(*%RH: here are what the fields are for:			%
	  % VarStamp: timestamp, used to test equality.			%
	  % Instance: binding of this type variable (if any).		%
	  % Generic: make a new copy when taking generic instance.	%
	  % Weak: not generic unless OccurLevel > AnalysisLevel.	%
	  % OccurLevel: minimum binding depth of lambda--bound variables%
	  % whose type involves this variable; used to determine when a %
	  % weak type variable can become generic; has no meaning for	%
	  % generic type variables; if infinite, then is not in type of %
	  % any lambda--bound variable (and hence can be made generic). %
	  % Instantiable: has meaning only for non--generics; determines%
	  % whether or not a type variable may be instantiated; set to	%
	  % false when explicit type variable is encountered, and is	%
	  % effectively true for generics.				%
          % Ety: true if the variable is used in a context where an     %
          %      equality function is assumed.                          %
	  % TopLevel:							%
	  % TypVarCopy:							%
	  % CopyCounter:						%
          (| VarStamp: int; Instance: [| None:unit; Yes:TypTerm' |] ref;
             Generic: bool ref; Weak: bool ref; OccurLevel: int ref;
	     Instantiable: bool ref; Ety: bool ref;
             Toplevel: bool;
             TypVarCopy: TypTerm' ref; CopyCounter: int ref |);*)
| TYPConVar (* TypConVar *) of object
(*	  (| ConVarHandle: Handle';
	     ConVarArgs: TypTerm' List;
	     Instance: TypTerm' opt ref |);*)
| TYPDefOper (* TypDefOper *) of object
(*          (| Guarded: loopCheck' ref;
             DefHandle: Handle';
	     DefBody: TypTerm';
             DefArgs: TypTerm' List |);*)
| TYPAbsOper (* TypAbsOper *) of object
(*          (| AbsArgs: TypTerm' List;
             AbsInfo: AbsInfo' |);*)
| TYPTagOper (* TypTagOper *) of object
(*          (| TagSort: [|Record; Variant|];
             TagList:
                [| TagInstance:  TypTerm';
		   Solid:  TagTypTerm' list;
		   Flexi:  TagTypTerm' dlist |] ref
          |)*)
