
#include <stdio.h>

/* Signature: 3143774e 14-Nov-2000 */

int main(int argc, char *argv[])
{
    FILE *in, *out;
    int c, i, lines = 1, depth = 0;
    if (argc < 3)
    {   fprintf(stderr, "Usage: paren <source> <destination>\n");
        return 1;
    }
    in = fopen(argv[1], "r");
    out = fopen(argv[2], "w");
    if (in == NULL)
    {   fprintf(stderr, "Input %s could not be accessed\n", argv[1]);
        return 1;
    }
    if ( out == NULL)
    {   fprintf(stderr, "Output %s cound not be accessed\n", argv[2]);
        return 1;
    }
    i = 0;
    fprintf(out, "%4d: ", depth);
    while ((c = getc(in)) != EOF)
    {   putc(c, out);
        if (c == '\n') fprintf(out, "%4d: ", depth), lines++;
        else if (c == '{') depth++;
        else if (c == '}') depth--;
    }
    fclose(in);
    fclose(out);
    fprintf(stderr, "%d lines, final depth = %d\n",
                    lines, depth);
    return 0;
}


