(*$Header: /a/rathlin/disk/src/master/edml/EDML4/EdinburghML/UPTODATE/RCS/ncgtype.sml,v 2.1 91/09/06 14:21:11 edml Exp $
 *$Log:	ncgtype.sml,v $
Revision 2.1  91/09/06  14:21:11  edml
Incremental Garbage Collector/Sun3 Native code
build sml.exp head from phase2.exp

Revision 2.0  91/06/09  17:08:38  ajg
*** empty log message ***
 *)

(*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*)
exception Comp_ncg of string;                        (* for internal errors *)
(*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*)

val NCinfo = { 	ByteCodeSize = ref 0,	NativeCodeSize = ref 0 };

val Ncopt = {

	     PrintDebug = ref false,
	     PrintByte = ref false,	 (* print the input (byte code) *)
	     PrintMsgs = ref true,       (* small msgs, like [castling foo] *)
	     PHStack = ref true,         (* Peephole stack usage *)
	     PHCommon = ref true,        (* Peephole common sequences *)
	     Regression = ref false,     (* use Unix assembler *)
	     castling = ref false,	 (* use the castling techneque *)
	     castlelimit = ref 20	 (* when castling comes into force *)
	     }


(*
 *  Portable Word Code, used for the very back end of the compiler
 *
 * Jump = label, placement; Word = list , placement
 *)

datatype 'a Wordcode = Word of (int list * int) | Jump of ('a * int);

(*
 *  The types that can be applied to the Fam Defintions
 *
 *)

datatype 'a FAMARGS = NON 
		 | INT of int 
                 | INT2 of int * int
		 | INTLIST of (int list)
		 | RESULT of 'a;
		   
(* 
 * The type of the array of fam functions:
 *)


datatype Arguments = PRIM
    		   | BYTE 
    		   | WORD
	           | CONST of int
		   | LIST
		   | BYTE2P
		   | WORD2
		   | WORD2P
		   | BY_CON of int
		   | CON_BY of int
		   | WD_CON of int
		   | CON_WD of int
		   | CONST2 of int * int
		   | JBYTE
		   | JWORD;

datatype 'a NativeCodeGen = INSERT | BCDEF of Arguments * int;

datatype NCFuns = NON 
  | INT of int 
  | JINT of int   (* a 'jumping' integer *)
  | INT2 of int * int
  | INTLIST of (int list);

datatype 'a Mapping = FN of (NCFuns -> 'a) 
		    | FNL of ((NCFuns list)-> 'a) 
		    | BCI 
		    | ANSWER of 'a;
