(*$Header: /a/rathlin/disk/src/master/edml/EDML4/EdinburghML/UPTODATE/RCS/ncg.sml,v 2.1 91/09/06 14:20:55 edml Exp $
 *$Log:	ncg.sml,v $
Revision 2.1  91/09/06  14:20:55  edml
Incremental Garbage Collector/Sun3 Native code
build sml.exp head from phase2.exp

Revision 2.0  91/06/09  17:08:34  ajg

 *)
(************************************************************************)
(*									*)
(*   A Four Pass, Portable, Optimizing Code Generator for Edinburgh ML	*)
(*									*)
(*   	  written for Final Year BSc Thesis, 1990-91, Andrew Gill 	*)
(*									*)
(************************************************************************)

(* also trying to create a edlib, to compliment flatlib *)


(* the hacks (tmp) *)

 use ["flatlib.sml"];
fun native _ = ();  (* AJG: One day this compiler will bootstrap itself *)
fun prefix _ = ();

native(prefix "native_");

 use "ncgtype.sml";		     	(* Internal types         *)
 use "ncglib.sml";                 	(* Local stuff            *)
 use "dynamic.sml";			(* dynamic database       *)
 use "bcodes.sml";	    		(* byte code database     *)
 use (Arch^"nc.sml");			(* the native code itself *)
 use "cgen.sml";			(* 3 out of 4 passes      *)

(*
 *  The hooks into the compiler  (NCG = the compiler itself)
 *)

NCGen := NCG; (* the master hook *)

local
    val {nametext,...} = Text;
    val inNC = ref(fn _ => false);
in
    val InportList = ref [];
    fun native f = (inNC := f);
    local
	fun optionalnative txt =
	    if nametext txt = "<Top Level>"
		then txt
	    else if (!inNC) (nametext txt)    	(* optional native code *)
		     then NCG txt		(* make it native code  *)
		 else (InportList := txt::(!InportList);txt)
    in
	val _ = BCText := optionalnative
    end
end;

local
    fun before ([],_) = true
      | before (_,[]) = false
      | before (a::b,c::d) = a = c andalso before(b,d);
	
in
    fun prefix n m = before(explode n,explode m)
end;

(*
 *  Now the late code generation stuff 
 *
 *)

    local
	nonfix profilehook 246 1;
	fun profilehook (a : unit):(text list) ref = profilehook(a)
    in
	val profhook = profilehook ();  (* save the bacon *)
    end;


(*
 * This Castle's the most used function(s) 
 *)

local
    nonfix replace 245 2;
    fun replace (a:text,b:text):unit = replace(a,b);
    val {VetText,nametext,...} = Text;
    val GClist = ref [];
    fun best'(a,b) = if VetText a > VetText b then a else b;
    val ctc = ref 100;
    fun sat a = VetText a > 3 andalso nametext a <> "<Top Level>";
    fun tot (a,b) = if sat a
			then VetText a+b 
		    else b;
    fun strsz (a,b) = 
	let 
	    val x = size(nametext a)
	in 
	    if x > b andalso sat a
		then x
	    else b
	end;

    val Possibles = ref [];

local
nonfix EQPTR 127 2; (* an ESML secret *)
fun EQPTR(x: 'a,y: 'a) : bool = EQPTR(x,y);

fun isinit(x,[]) = false
  | isinit (x,y::t) = ((EQPTR(x,y))) orelse isinit(x,t);


fun add([],y) = y
  | add (x::t,y) = if isinit(x,y) 
		       then add(t,y)
		   else if sat x 
			   then add(t,x::y) 
		       else add(t,y);
		       
in
    infix @@;
    fun x @@ y = add(x,y);
end;

    fun Castle () = 
	let
	    (* 
	     * add news to goods , profhook holds data cause is cleared ...
	     *)
(*@@*)	    val _ = profhook := ((!InportList)@(!profhook));
	    val ipl = (!profhook);  
	    val _ = InportList := [];
	in
	    ()
		
(*
(* One Day this Compiler will Castle in a incramental Env *)
		if null ipl orelse (not (!(#castling Ncopt)))
		    then ()
		else
		    let
			val bcurr = fold best' (tl ipl) (hd ipl);
			val outstring' = if !(#PrintMsgs Ncopt)
			    then outstring else (fn _ => ());
		    in	
			if sat bcurr andalso 
			       VetText bcurr > (!(#castlelimit Ncopt))
			    then 
				(outstring' ("[castling "^(nametext bcurr));
				 replace(bcurr,NCG bcurr);
				 outstring' "]\n")
			else 
			    () 
		    end
*)
	end;

    val _ = CastlePrompt := Castle;

    fun dots (n,c) = if n <= 0 then "" else c^dots(n-1,c);

    fun prettyprint x x' y =   (* x = number of total of 2+, y = text *)
	if sat y
	    then 
		let
		    val v = VetText y
		    val t = dots(floor(((real(v)/x))*100.0+0.5) div 2,".")
    		in
		   if t <> "" 
		       then outstring 
		    ((dots(2+x'-size(nametext y)," "))^
		      (nametext y)^"  "^t^"\n")
		   else()
		end
	else ();

in 

    fun profile n = 
	let
	    val ipl = (!profhook);
(*	    val banner = "*********************************************************************\n";*)
	    val banner = "\n";
	    val _ = outstring banner;
	    val _ = map 
		(prettyprint (real(fold tot ipl 0)) (fold strsz ipl 0)) ipl;
	    val _ = outstring banner;
	in
	    ()
	end;
    val profhook = profhook;
	

end;

fun True _ = true;
fun False _ = false;

(* back to normal (fix again later) ? *)

local 
    val old_use = use
in
    fun use s = old_use (hd s)
end;
