package uk.ac.cam.cl.rkh23.blobtracker;

import java.util.LinkedList;
import java.util.List;

public class SimpleBackgroundSubtractor implements BackgroundSubtractor {
	
	private int[] mBackground = null;
	private static int mThreshold = 20;
	private final int mImageWidth;
	
	public SimpleBackgroundSubtractor(int image_x, int image_y) {
		mImageWidth=image_x;
	}

	@Override
	public List<Pixel> Subtract(int[] pixels) {
		if (mBackground==null) {
			mBackground = pixels.clone();
			return new LinkedList<Pixel>();
		}
	
		
		LinkedList<Pixel> foregroundlist = new LinkedList<Pixel>();
		for (int i=0; i<pixels.length; i++) {
			// Figure out RGB values for pixel index i from the supplied image
			int r = ((pixels[i]>>16) & 0x000000FF);
			int g = ((pixels[i]>>8) & 0x000000FF);
			int b = ((pixels[i]) & 0x000000FF);
			
			// Figure out RGB values for pixel index i from the saved background image
			int br = ((mBackground[i]>>16) & 0x000000FF);
			int bg = ((mBackground[i]>>8) & 0x000000FF);
			int bb = ((mBackground[i]) & 0x000000FF);
		
			// Compute the distance apart for the two RGB values
			// Q. Why don't I square root this to get a true distance?
			int distsq = (r-br)*(r-br) + (b-bb)*(b-bb) + (g-bg)*(g-bg);
			
			// If the distance is bigger than some threshold then
			// we assume that it's not the background!
			if (distsq>mThreshold*mThreshold) {
				foregroundlist.add(new Pixel(i, mImageWidth));
			}
			
		}
		// Return the list of foreground pixels that we've found
		return foregroundlist;
	}

}
