package uk.ac.cam.cl.rkh23.blobtracker;

import java.util.*;

public class RecursiveRegionExtractor implements RegionExtractor {

	private final int[] mRegionMap;
	private int   mRegionID = 1;
	private final int mWidth;
	private final int mHeight;
	
	
	public RecursiveRegionExtractor(int image_width, int image_height) {
		mRegionMap = new int[image_width*image_height];
		mWidth = image_width;
		mHeight = image_height;
	}
	
	
	
	@Override
	public List<Region> extractRegions(List<Pixel> pixels) {
		
		List< Region > regionlist = new LinkedList< Region >();
		
		// First we set everything to be background
		for (int i=0; i<mWidth*mHeight; i++) mRegionMap[i]=-1;
		
		// Now mark up all of the pixels that are fg
		for (Pixel p : pixels) {
			mRegionMap[p.getArrayIndex()] = 0;
		}
		
		// Now we search for an unlabelled pixel to start off a new region
		int label = 1;
		for (Pixel p : pixels) {
			if (mRegionMap[p.getArrayIndex()]==0) {
				Region region = new Region();
				extractRegion(p,label,region);
				regionlist.add(region);
				label++;
			}
		}
		
		return regionlist;
	}
	
	
	private void extractRegion(Pixel p, int label, List<Pixel> plist) {
		
		if (mRegionMap[p.getArrayIndex()]!=0) return;
		else {
			mRegionMap[p.getArrayIndex()]=label;
			plist.add(p);
		}
	
			if ( (p.getX()<mWidth-1)) extractRegion(new Pixel(p.getArrayIndex()+1, mWidth),label,plist);
		
		if ( (p.getX()>0)) extractRegion(new Pixel(p.getArrayIndex()-1, mWidth),label,plist);
		
		if ( (p.getY()<mHeight-1)) extractRegion(new Pixel(p.getArrayIndex()+mWidth, mWidth),label,plist);
		
		if ( (p.getY()>0)) extractRegion(new Pixel(p.getArrayIndex()-mWidth, mWidth),label,plist);
	}

}
