package uk.ac.cam.cl.rkh23.blobtracker;

import java.awt.BorderLayout;
import java.awt.Image;
import java.awt.Transparency;
import java.awt.color.ColorSpace;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import javax.imageio.ImageIO;
import javax.media.format.VideoFormat;
import javax.media.util.BufferToImage;
import javax.swing.JFrame;


public class BlobTracker extends JFrame {
	
	private BackgroundSubtractor mBackgroundSubtractor = null;
	private RegionExtractor      mRegionExtractor = null;
	
	private DisplayPanel mPanel = new DisplayPanel();
	private FrameInterface mFrames;
	
	private int mWidth;
	private int mHeight;
	
	public BlobTracker(
					   int w,
					   int h,
					   FrameInterface f,
					   BackgroundSubtractor b,
					   RegionExtractor r) {
		super("Blob Tracker");
		
		mWidth=w;
		mHeight=h;
		mBackgroundSubtractor = b;
		mRegionExtractor = r;
		
		addWindowListener( new WindowAdapter() {
		      public void windowClosing(WindowEvent e)
		      { mFrames.close();    // stop snapping pics
		        System.exit(0);
		      }
		    });
		
		mFrames = f;
		this.setSize(mWidth+10,mHeight+40);
		this.getContentPane().setLayout(new BorderLayout());
		this.getContentPane().add(mPanel, BorderLayout.CENTER);
		this.setVisible(true);
	}
	
	public void run() {
		int[] pixels = new int[mWidth*mHeight];
		
		while (true) {
			BufferedImage image = mFrames.getNextFrame();
			
			if (image!=null) {
				long starttime = System.nanoTime();
				
				// Get a pixel buffer
				pixels = image.getRGB(0, 0, mWidth, mHeight, pixels, 0, mWidth);
				
				// Extract the pixels that don't match the background
				List<Pixel> fgpixels = mBackgroundSubtractor.Subtract(pixels);
				
				List< Region > regionlist = mRegionExtractor.extractRegions(fgpixels);
				
				// Clean up the list by removing small regions
				Iterator< Region > it = regionlist.iterator();
				while (it.hasNext()) {
					Region r = it.next();
					if (r.size()<30) it.remove();
				}
				
				Collections.sort(regionlist);
			
				//LinkedList<Region> llr= new LinkedList<Region>();
				//if (regionlist.size()>0) llr.add(regionlist.get(0));
				// Update the screen
				//mPanel.setHighlightPixels(fgpixels);
				mPanel.setHighlightRegions(regionlist);
				mPanel.setImage(image);
				mPanel.repaint();
				
			
				long duration = System.nanoTime() - starttime;
				System.out.println("Processing Time was " + (double)(duration/1.0E6) + "ms");
			}
		}
	}
	
	
	
	public static void main(String[] args) {
		
		final int width = 320;//160;
		final int height = 240;//120;
		
		JMFFrameSource framesource = new JMFFrameSource(width, height);
		
		BlobTracker bt = new BlobTracker(width, height, framesource,
					new SimpleBackgroundSubtractor(width,height),
					new ScanningRegionExtractor(width,height)
					);
		
		
		bt.run();
	}

}
