package uk.ac.cam.cl.rkh23.webserver;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

/**
 * This class represents a really basic web server
 * @author rkh23
 *
 */
public class WebServer {
	
	/**
	* Time delay to add to each request (in lectures
	* this was set to 2000 to simulate a slow server
	* and demonstrate that threading is needed
	*/
	private static int delay = 0;

	/**
	 * The connection to a client (if anY)
	 */
	private HTTPConnection mConnection = null;
	
	/**
	 * The server port
	 */
	private int mPort;
	
	/**
	 * Constructor stores the web server's port
	 * @param port
	 */
	public WebServer(int port) {
		mPort = port;
	}
	
	/**
	 * This method simply listens for a new connection
	 * on the specified listening port
	 */
	private void listenForNewConnection() {
		ServerSocket serversocket = null;
		while (true) {
			try {
				// First we create a server socket that will be able to sit and listen
				serversocket = new ServerSocket(mPort);
				
				// Now we wait for a connection. When it gets one,
				// it creates a Socket object for it
				Socket connection = serversocket.accept();
				
				// Create our HTTPConnection using this new connection
				mConnection = new HTTPConnection(connection);
				
				// The job of this method is done
				return;
			}
			catch(IOException ioe) {
				// Something went wrong
			}
			finally {
				try {serversocket.close();}
				catch(Exception e){}	
			}
		}
	}
	
	/**
	 * This is the actual server loop. It constantly looks for a new connection
	 * If it find one, it turns over control to the HTTPConnection object
	 * which handles the connection.  When the connection closes for some reason
	 * the process() method returns and we repeat
	 */
	public void runServer() {
		
		while (true) {
			System.out.println("Waiting for connection");
			
			// Wait until we are contacted
			listenForNewConnection();
			System.out.println("Got a new connection");
			
			// If we get here we have a connection
			// so let that connection do its thing
			mConnection.process(delay);
			
			// The connection will have disconnected
			mConnection=null;
			
			System.out.println("Closed connection");
		}
		
	}
	
	/**
	 * The standard entry point
	 * @param args
	 */
	public static void main(String[] args) {
		// Check we have the correct number of argument
		if (args.length!=1) {
			System.out.println("Usage: java WebServer <port number to listen on>");
			System.exit(0);
		}
		
		// Read in the port number from the command line
		int port=0;
		try {
			port = Integer.parseInt(args[0]);
		}
		catch (NumberFormatException nfe) {
			// Hmmm - we failed to convert the input port to a number
			// The user must have given us garbage!!
			System.out.println("Invalid port specification!");
			System.out.println("Usage: java WebServer <port number to listen on>");
			System.exit(0);
		}
		
		// Now we can create a server object and set it going
		WebServer server = new WebServer(port);
		server.runServer();
	}
	
	
}
