package uk.ac.cam.cl.rkh23.threadedwebserver;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashSet;
import java.util.Set;

import uk.ac.cam.cl.rkh23.webserver.HTTPConnection;
import uk.ac.cam.cl.rkh23.webserver.WebServer;

public class ThreadedWebServer {
	
	
	/**
	 * The server port
	 */
	private int mPort;
	
	/**
	 * Constructor stores the web server's port
	 * @param port
	 */
	public ThreadedWebServer(int port) {
		mPort = port;
	}
	
	/**
	 * This method simply listens for a new connection
	 * on the specified listening port
	 */
	private void listenForNewConnection() {
		ServerSocket serversocket = null;
		while (true) {
			try {
				// First we create a server socket that will be able to sit and listen
				if (serversocket==null) serversocket = new ServerSocket(mPort);
				
				// Now we wait for a connection. When it gets one,
				// it creates a Socket object for it
				Socket connection = serversocket.accept();
				
				// Create our HTTPConnection using this new connection
				ThreadedHTTPConnection conn = new ThreadedHTTPConnection(connection);
				conn.start();
			}
			catch(IOException ioe) {
				// Something went wrong
				try {
					serversocket.close();
				} catch (IOException e) {}
				serversocket=null;
			}
		}
	}
	
	/**
	 * This is the actual server loop. It constantly looks for a new connection
	 * If it find one, it turns over control to the HTTPConnection object
	 * which handles the connection.  When the connection closes for some reason
	 * the process() method returns and we repeat
	 */
	public void runServer() {
		while (true) {
			// Wait until we are contacted
			// This never returns now
			listenForNewConnection();
		}
	}
	
	/**
	 * The standard entry point
	 * @param args Command line arguments
	 */
	public static void main(String[] args) {
		// Check we have the correct number of argument
		if (args.length!=1) {
			System.out.println("Usage: java WebServer <port number to listen on>");
			System.exit(0);
		}
		
		// Read in the port number from the command line
		int port=0;
		try {
			port = Integer.parseInt(args[0]);
		}
		catch (NumberFormatException nfe) {
			// Hmmm - we failed to convert the input port to a number
			// The user must have given us garbage!!
			System.out.println("Invalid port specification!");
			System.out.println("Usage: java WebServer <port number to listen on>");
			System.exit(0);
		}
		
		// Now we can create a server object and set it going
		ThreadedWebServer server = new ThreadedWebServer(port);
		server.runServer();
	}
}
