package uk.ac.cam.cl.rkh23.threadedwebserver;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.StringTokenizer;

public class ThreadedHTTPConnection extends Thread {

	/**
	* Time delay to add to each request (in lectures
	* this was set to 2000 to simulate a slow server
	* and demonstrate that threading is needed
	*/
	private static int delay = 0;
	
	
	/**
	 * The underlying connection
	 */
	private final Socket mSocket;
	
	
	/**
	 * Basic constructor
	 * @param s The connected socket
	 */
	public ThreadedHTTPConnection(Socket s) {
		mSocket = s;
	}
	
	/**
	 * This is the entry point for a new thread
	 * i.e. it's like having another main() method
	 * but this gets called when the thread is started not the
	 * program
	 */
	public void run() {
		this.process(delay);
	}
	
	
	/**
	 * This function runs until we have processed a single
	 * request from the connecting browser
	 */
	private void process(int delay) {
		
		try {
			// This just gets us something we can read from
			BufferedReader input = new BufferedReader(new InputStreamReader(mSocket.getInputStream()));
		
			// Wait for a message to come in
			String line = input.readLine();
			
			// Insert a manual delay
			try {
	 			Thread.sleep(delay);
	 		} catch (InterruptedException e1) {
	 			// TODO Auto-generated catch block
	 			e1.printStackTrace();
	 		}
			
			// handle the request
			handleRequest(line);
			
		}
		catch (IOException ioe) {
			// Something went wrong but it doesn't matter
			// since we will be closing the connection whatever happens
		}
		
		finally {
			// We're done here
			try {   mSocket.close();   }
			catch(IOException ioe) {} // Ignore failure - the object will be destroyed anyway
		}
		
	}
	
	
	/**
	 * Handle a single request from a browser
	 * @param line the GET or HEAD request
	 */
	private void handleRequest(String line) {
		boolean is_get_request=false;
		
		// Check what type of request it is
		if (line.startsWith("GET")) is_get_request=true;
		else if (line.startsWith("HEAD")) is_get_request=false;
		else {
			// It's not a GET or a HEAD so tell the browser
			// that we can't help
			sendHeader(501);
			return;
		}
		
		// Extract the filename (second bit of text in line)
		StringTokenizer st = new StringTokenizer(line);
		st.nextToken(); // That's the first token, either "GET" or "HEAD"
		String file = st.nextToken();
		
		// Whether it is a GET or a HEAD we need to find out about the file
		file = "."+file;
		System.out.println("Received request for file: "+file);
		
		FileInputStream requestedfile = null;

	    try {
	      requestedfile = new FileInputStream(file);
	    }
	    catch (Exception e) {
	    	// We failed to find the file so send an error
	    	System.out.println("Unable to find "+file+" so sending 404 error");
	    	sendHeader(404);
	    	return;
	    }
	    
	    
	    // OK if we are here, the file exists!
	    System.out.println("Found "+file+" so sending 200 header");
	    if (!sendHeader(200)) return;
	    
	    // If this is a GET request, we need to send the file too!
	    if (is_get_request) {
	    	
	    	try {
	    		DataOutputStream output =
	    			new DataOutputStream(mSocket.getOutputStream());
	    		while (true) {
	    			int b = requestedfile.read();
	    			if (b == -1) {
	    				break; //end of file
	    			}
	    			output.write(b);
	    		}
	    		System.out.println("Sent "+file+" in response to GET");
	    		
	    	}
	    	catch(Exception e) {
	    		System.out.println("Error sending file "+file);
	    	}
	    }

	}
	
	
	
	/**
	 * This method sends the header of a response
	 * to a GET or HEAD request
	 * @param result_code What type of message to send
	 */
	private boolean sendHeader(int result_code) {
		 String s = "HTTP/1.0 ";
		 
		 // You may be familiar with these codes, especially
		 // the 404 Not Found one.
		 switch (result_code) {
		 case 200:
			 s = s + "200 OK";
			 break;
		 case 404:
			 s = s + "404 Not Found";
			 break;
		 case 501:
			 s = s + "501 Not Implemented";
			 break;
		 }			

		 s = s + "\r\n"; // Add new lines
		 s = s + "Connection: close\r\n"; // We will close the connection after
		 s = s + "Server: WebServer\r\n"; //server name
		 s = s + "Content-Type: text/html\r\n"; // We only do html files
		 s = s + "\r\n"; // This marks the end of the header
		 
	
		 // Now send all of that over
		 try {
	    		DataOutputStream output = new DataOutputStream(mSocket.getOutputStream());
	    		output.writeBytes(s);
		 }
		 catch(Exception e) {
			 System.out.println("Failed to send header to browser");
			 return false;
		 }
		 return true;
	}
	
	
}
