package uk.ac.cam.cl.rkh23.view2;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Set;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import uk.ac.cam.cl.rkh23.photo.ModelInterface;
import uk.ac.cam.cl.rkh23.photo.ViewInterface;
import uk.ac.cam.cl.rkh23.photo.model.Photo;
import uk.ac.cam.cl.rkh23.photo.view.PhotoTile;

public class ThumbnailWindow extends JFrame implements ViewInterface {
	
	private ModelInterface mModel=null;

	private JPanel mThumbPanel = new JPanel();
	private JScrollPane mThumbPanelScroller = new JScrollPane(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
	
	public ThumbnailWindow(ModelInterface model) {
		// Set the title bar. This goes up the
		// inheritance tree and calls the JFrame(String) 
		// constructor
		super("Live Thumbnail Viewer");
		
		mModel = model;
		mModel.register(this);
		
		// This just causes the whole application to quit
		// when the window is closed.
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent we) {
				System.exit(0);
			 }	
		});

		// Store the model so we can access it
		mModel=model;
		
		getContentPane().setLayout(new BorderLayout());
		getContentPane().add(mThumbPanelScroller);
		mThumbPanelScroller.getViewport().add(mThumbPanel);
		mThumbPanel.setLayout(new FlowLayout());
		mThumbPanel.setPreferredSize(new Dimension(240,100));
		
		setSize(250,700);
		update();
		setVisible(true);
	}

	@Override
	public void update() {
		mThumbPanel.removeAll();
		// Get the albums
		Set<String> albums = mModel.getAlbums();
		// The Set is sorted because we used a TreeMap in the model
		int n=0;
		for (String s: albums) {
			Set<Photo> photos = mModel.getAlbumPhotos(s);
			for (Photo p : photos) {
				mThumbPanel.add(new PhotoTile(p));
				n++;
			}
		}
		int size = 100*n/2;
		size = (size<this.getHeight()) ? this.getHeight() : size;
		mThumbPanel.setPreferredSize(new Dimension(240,100*n/2));
		validate();
		repaint();
		
	}

}
