package uk.ac.cam.cl.rkh23.photo.view;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.*;

import uk.ac.cam.cl.rkh23.photo.model.Photo;

/**
 * This class is a modified JPanel that displays an image
 * @author rkh23
 *
 */
public class PhotoTile extends JPanel {

	/**
	 * The photo itself
	 */
	private Photo mPhoto = null;
	
	/**
	 * Basic constructor
	 * @param p
	 */
	public PhotoTile(Photo p) {
		mPhoto=p;
		setSize(200,200);
		setMinimumSize(new Dimension(100,100));
		setPreferredSize(this.getMinimumSize());
		setMaximumSize(this.getPreferredSize());
	}
	
	/**
	 * Provide access to the photo this tile will display
	 */
	public Photo getPhoto() { return mPhoto; }
	
	/**
	 * Here we override the paint method for
	 * a JPanel so that, instead of drawing a 
	 * grey panel, it draws something else
	 * (our image);
	 */
	@Override
	public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (mPhoto!=null)     mPhoto.drawImage(g, 0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.black);
        g.drawRect(0, 0, getWidth()-1, getHeight()-1);
   }
	
}
