package uk.ac.cam.cl.rkh23.photo.model;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

/**
 * The photo objects contain everything there is to know about 
 * a photo.  Note that the class is immutable so once it has been 
 * created, it can't be modified. This stops the view from changing the
 * photo in any way except via the controller. 
 * @author rkh23
 *
 */
public final class Photo {
	
	private final String mPath;
	
	private BufferedImage mImage;
	
	/**
	 * Only the model can create Photo objects - this ensures they
	 * get filled in properly
	 */
	protected Photo(String path) {
		mPath = path;
		
		// load the photo into memory
		try {
		    mImage = ImageIO.read(new File(path));
		} catch (IOException e) {
			// We should handle errors but that's not the point of
			// this example program
		}
	}
	
	/**
	 * Accessor method for the image file path
	 * @return
	 */
	public String getPath() { return mPath; }

	/**
	 * We don't want to give external classes (such as the views)
	 * the ability to modify the image we have loaded in. We could 
	 * create a copy every time someone wants the image data, but that
	 * is not efficient and actually hard work (try making a completely
	 * distinct BufferedImage copy...)
	 * 
	 * Instead we provide a method that will paint the image onto a 
	 * provided canvas at a given position and size
	 */
	public void drawImage(Graphics g, int x, int y, int width, int height) {
		// Don't worry too much about this code - it's just
		// doing the painting and resizing
		Graphics2D g2 = (Graphics2D)g;
		int iw = mImage.getWidth();
		int ih = mImage.getHeight();
		
		if (width!=iw || height!=ih) {
			g2.drawImage(mImage.getScaledInstance(width,height,Image.SCALE_SMOOTH),0,0,width, height,null);
		}
		else g2.drawImage(mImage, null, x, y);
	}
	
	
}
