package uk.ac.cam.cl.rkh23.photo;

import java.util.Set;

import uk.ac.cam.cl.rkh23.photo.model.Photo;

/**
 * This defines everything that a View can do to a model
 * @author rkh23
 *
 */
public interface ModelViewInterface {
	
	/**
	 * New views must be able to register with models
	 * (observer pattern)
	 * @param vi
	 */
	public void register(ViewInterface vi);
	
	/**
	 * Old views must be able to deregister with models
	 * (observer pattern)
	 */
	public void deregister(ViewInterface vi);

	/**
	 * The view must be able to get at the sets of Photos
	 * that are associated with a given album
	 * @param album
	 * 	The album name
	 * @return
	 */
	public Set<Photo> getAlbumPhotos(String album);
	
	/**
	 * The view must be able to get a list of current albums
	 * @return
	 */
	public Set<String> getAlbums();
	
}
