package uk.ac.cam.cl.rkh23.photo;


import uk.ac.cam.cl.rkh23.photo.model.Photo;

/**
 * This interface specifies how a controller will
 * talk to a model
 * @author rkh23
 *
 */
public interface ModelControllerInterface {
	
	
	/**
	 * Create a new album
	 * @param a album name
	 */
	public void createAlbum(String name);
	
	/**
	 * Delete album
	 * @param a Name of album to delete
	 */
	public void deleteAlbum(String a);
	
	/**
	 * Add a photo to an album
	 * @param p photo path
	 * @param album album to add to
	 */
	public void addPhoto(String path, String album);
	
	/**
	 * Delete a photo from an album
	 * @param p photo 
	 * @param album album
	 */
	public void deletePhoto(Photo p, String album);
	
	
}
