package uk.ac.cam.cl.rkh23.bouncingball;

/**
 * Represents the state and properties of a ball
 * @author rkh23
 *
 */
public class Ball implements Cloneable {
	
	/**
	 * The ratio of the rebound speed to the
	 * incoming speed when it bounces from an object
	 * ("coefficient of restitution")
	 */
	private double mK = 0.0;
	/**
	 * Current position
	 */
	private Vector2D mPosition = null;
	/**
	 * Current velocity
	 */
	private Vector2D mVelocity = null;
	/**
	 * Current acceleration
	 */
	private Vector2D mAcceleration =null;
		
	/**
	 * Constructor initialises a ball
	 * @param k Coefficient of restitution
	 * @param x Starting position in x
	 * @param y Starting position in y
	 * @param vx Starting speed in x
	 * @param vy Starting speed in y
	 * @param ax Starting acceleration in x
	 * @param ay Starting acceleration in y
	 */
	public Ball (double k,
			    double x, double y,
				double vx, double vy,
			    double ax, double ay) {
		mK = k;
		mPosition = new Vector2D(x,y);
		mVelocity = new Vector2D(vx, vy);
		mAcceleration = new Vector2D(ax, ay);		
	}
	
	/**
	 * Get current position
	 * @return Current position
	 */
	public Vector2D getPosition() { return mPosition; }
	/**
	 * Get current velocity
	 * @return Current velocity
	 */
	public Vector2D getVelocity() { return mVelocity; }
	/**
	 * Gett acceleration
	 * @return Current acceleration
	 */
	public Vector2D getAcceleration() { return mAcceleration; }
	/**
	 * Get the coefficient of restitution
	 * @return Coeff. of restitution
	 */
	public double   getK() { return mK;}
	
	
	/**
	 * Set the position (mutator)
	 * @param p New position
	 */
	public void setPosition(Vector2D p) { mPosition=p; }
	/**
	 * Set the velocity (mutator)
	 * @param v New velocity
	 */
	public void setVelocity(Vector2D v) { mVelocity=v; }
	/**
	 * Set the acceleration (mutator)
	 * @param a New acceleration
	 */
	public void setAcceleration(Vector2D a) { mAcceleration=a; }
	
	/**
	 * Use the equations of motion to update the ball's state
	 * assuming delta seconds have elapsed since the last update
	 * @param delta Time delta since last update
	 */
	public void updateState(double delta) {
		// Update the position on the assumption that the
		// velocity was constant over the update period
		// (this is justifiable for small delta t)
		// s = ut + 1/2 at^2
		Vector2D ut = mVelocity.multiply(delta);
		Vector2D att = mAcceleration.multiply(delta*delta*0.5);
		mPosition = ut.add(att).add(mPosition);
		
		// Update the velocity
		// v = u+at
		mVelocity = mAcceleration.multiply(delta).add(mVelocity);
		//mVelocity = Vector2D.add(mVelocity, Vector2D.multiply(mAcceleration,delta));
	}
	
	public Object clone() throws CloneNotSupportedException {
	    Ball b = (Ball) super.clone();
	    b.mPosition = new Vector2D(mPosition.getX(), mPosition.getY());
	    b.mVelocity = new Vector2D(mVelocity.getX(), mVelocity.getY());
	    b.mAcceleration = new Vector2D(mAcceleration.getX(), 
	                                         mAcceleration.getY());
	    return b;
	}
	
}
