package framework;

import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.media.opengl.GLCanvas;

public class AppContainer implements Runnable {
  static Thread displayT;
  static Renderer toRender;
  static boolean bQuit = false;
  
  public static void go(Renderer renderMe) {
    toRender = renderMe;
    displayT = new Thread(new AppContainer());
    displayT.start();
  }
  
  public void run() {
    Frame frame = new Frame(toRender.getTitle());
    GLCanvas canvas = new GLCanvas();
    canvas.addGLEventListener(toRender);
    frame.add(canvas);
    frame.setSize(640, 480);
    frame.addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent e) {
        bQuit = true;
        System.exit(0);
      }
    });
    frame.setVisible(true);
    canvas.requestFocus();
    while( !bQuit ) {
      canvas.display();
    }
  }
}