package blobby;

import java.awt.event.KeyEvent;

import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;

import blobby.engine.ImplicitSurface;
import blobby.engine.ImplicitSurfaceRenderer;
import blobby.engine.MetaBall;
import framework.M3d;
import framework.Renderer;

public class BlobbyDemo extends Renderer {

  boolean paused = false;
  double d = 0;
  ImplicitSurface surface;
  ImplicitSurfaceRenderer surfaceRenderer;
  MetaBall mover;

  @Override
  public String getTitle() {
    return "Blobby Demo";
  }

  public void init(GLAutoDrawable glDrawable) {
    final GL gl = glDrawable.getGL();
    
    super.init(glDrawable);

    gl.glEnable(GL.GL_POLYGON_OFFSET_LINE);
    gl.glPolygonOffset(0, -100);

    showAxes = false;
    cameraDistance = 12;
    
    surface = new ImplicitSurface(new M3d(-10,-10,-10), new M3d(10,10,10), 5);
    surface.addForce(mover = new MetaBall(0,0,0,1.0));
    surface.addForce(new MetaBall(-4,0,0,1.0));
    
    surfaceRenderer = new ImplicitSurfaceRenderer(surface);
  }

  public void keyPressed(KeyEvent e) {
    switch (e.getKeyCode()) {
    case KeyEvent.VK_SPACE:
      paused = !paused;
      break;
    case KeyEvent.VK_B:
      surfaceRenderer.setShowBoxes(!surfaceRenderer.getShowBoxes());
      break;
    case KeyEvent.VK_E:
      surfaceRenderer.setShowEdges(!surfaceRenderer.getShowEdges());
      break;
    case KeyEvent.VK_1:
      surface.setTargetLevel(1);
      break;
    case KeyEvent.VK_2:
      surface.setTargetLevel(2);
      break;
    case KeyEvent.VK_3:
      surface.setTargetLevel(3);
      break;
    case KeyEvent.VK_4:
      surface.setTargetLevel(4);
      break;
    case KeyEvent.VK_5:
      surface.setTargetLevel(5);
      break;
    case KeyEvent.VK_6:
      surface.setTargetLevel(6);
      break;
    case KeyEvent.VK_7:
      surface.setTargetLevel(7);
      break;
    case KeyEvent.VK_8:
      surface.setTargetLevel(8);
      break;
    default: super.keyPressed(e);
      break;
    }
  }
  
  long then = 0;
  public void display(GLAutoDrawable glDrawable) {
    final GL gl = glDrawable.getGL();
    long now = System.currentTimeMillis();

    if (then == 0) {
      then = now;
    }
    preDisplay(glDrawable);
    if (!paused) {
      mover.setX(4*Math.cos(d));
      d += ((now-then) * 15.0 / 1000.0) * 3.141592/64.0;
      surface.reset();
      surface.refine();
    }
    then = now;
    surfaceRenderer.render(gl);
    postDisplay(glDrawable);
  }
}
